# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['HaVipAssociateArgs', 'HaVipAssociate']

@pulumi.input_type
class HaVipAssociateArgs:
    def __init__(__self__, *,
                 ha_vip_id: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 instance_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a HaVipAssociate resource.
        :param pulumi.Input[str] ha_vip_id: The id of the Ha Vip.
        :param pulumi.Input[str] instance_id: The id of the associated instance.
        :param pulumi.Input[str] instance_type: The type of the associated instance. Valid values: `EcsInstance`, `NetworkInterface`.
        """
        pulumi.set(__self__, "ha_vip_id", ha_vip_id)
        pulumi.set(__self__, "instance_id", instance_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)

    @property
    @pulumi.getter(name="haVipId")
    def ha_vip_id(self) -> pulumi.Input[str]:
        """
        The id of the Ha Vip.
        """
        return pulumi.get(self, "ha_vip_id")

    @ha_vip_id.setter
    def ha_vip_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "ha_vip_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The id of the associated instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the associated instance. Valid values: `EcsInstance`, `NetworkInterface`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)


@pulumi.input_type
class _HaVipAssociateState:
    def __init__(__self__, *,
                 ha_vip_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering HaVipAssociate resources.
        :param pulumi.Input[str] ha_vip_id: The id of the Ha Vip.
        :param pulumi.Input[str] instance_id: The id of the associated instance.
        :param pulumi.Input[str] instance_type: The type of the associated instance. Valid values: `EcsInstance`, `NetworkInterface`.
        """
        if ha_vip_id is not None:
            pulumi.set(__self__, "ha_vip_id", ha_vip_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)

    @property
    @pulumi.getter(name="haVipId")
    def ha_vip_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the Ha Vip.
        """
        return pulumi.get(self, "ha_vip_id")

    @ha_vip_id.setter
    def ha_vip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_vip_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the associated instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the associated instance. Valid values: `EcsInstance`, `NetworkInterface`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)


class HaVipAssociate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ha_vip_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage ha vip associate
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
            security_group_name="acc-test-sg",
            vpc_id=foo_vpc.id)
        foo_network_interface = volcengine.vpc.NetworkInterface("fooNetworkInterface",
            network_interface_name="acc-test-eni",
            description="acc-test",
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id],
            primary_ip_address="172.16.0.253",
            port_security_enabled=False,
            private_ip_addresses=["172.16.0.2"],
            project_name="default",
            tags=[volcengine.vpc.NetworkInterfaceTagArgs(
                key="k1",
                value="v1",
            )])
        foo_ha_vip = volcengine.vpc.HaVip("fooHaVip",
            ha_vip_name="acc-test-ha-vip",
            description="acc-test",
            subnet_id=foo_subnet.id,
            ip_address="172.16.0.5")
        foo_ha_vip_associate = volcengine.vpc.HaVipAssociate("fooHaVipAssociate",
            ha_vip_id=foo_ha_vip.id,
            instance_type="NetworkInterface",
            instance_id=foo_network_interface.id)
        ```

        ## Import

        HaVipAssociate can be imported using the ha_vip_id:instance_id, e.g.

        ```sh
         $ pulumi import volcengine:vpc/haVipAssociate:HaVipAssociate default havip-2byzv8icq1b7k2dx0eegb****:eni-2d5wv84h7onpc58ozfeeu****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ha_vip_id: The id of the Ha Vip.
        :param pulumi.Input[str] instance_id: The id of the associated instance.
        :param pulumi.Input[str] instance_type: The type of the associated instance. Valid values: `EcsInstance`, `NetworkInterface`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HaVipAssociateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage ha vip associate
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
            security_group_name="acc-test-sg",
            vpc_id=foo_vpc.id)
        foo_network_interface = volcengine.vpc.NetworkInterface("fooNetworkInterface",
            network_interface_name="acc-test-eni",
            description="acc-test",
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id],
            primary_ip_address="172.16.0.253",
            port_security_enabled=False,
            private_ip_addresses=["172.16.0.2"],
            project_name="default",
            tags=[volcengine.vpc.NetworkInterfaceTagArgs(
                key="k1",
                value="v1",
            )])
        foo_ha_vip = volcengine.vpc.HaVip("fooHaVip",
            ha_vip_name="acc-test-ha-vip",
            description="acc-test",
            subnet_id=foo_subnet.id,
            ip_address="172.16.0.5")
        foo_ha_vip_associate = volcengine.vpc.HaVipAssociate("fooHaVipAssociate",
            ha_vip_id=foo_ha_vip.id,
            instance_type="NetworkInterface",
            instance_id=foo_network_interface.id)
        ```

        ## Import

        HaVipAssociate can be imported using the ha_vip_id:instance_id, e.g.

        ```sh
         $ pulumi import volcengine:vpc/haVipAssociate:HaVipAssociate default havip-2byzv8icq1b7k2dx0eegb****:eni-2d5wv84h7onpc58ozfeeu****
        ```

        :param str resource_name: The name of the resource.
        :param HaVipAssociateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HaVipAssociateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ha_vip_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HaVipAssociateArgs.__new__(HaVipAssociateArgs)

            if ha_vip_id is None and not opts.urn:
                raise TypeError("Missing required property 'ha_vip_id'")
            __props__.__dict__["ha_vip_id"] = ha_vip_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["instance_type"] = instance_type
        super(HaVipAssociate, __self__).__init__(
            'volcengine:vpc/haVipAssociate:HaVipAssociate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ha_vip_id: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None) -> 'HaVipAssociate':
        """
        Get an existing HaVipAssociate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ha_vip_id: The id of the Ha Vip.
        :param pulumi.Input[str] instance_id: The id of the associated instance.
        :param pulumi.Input[str] instance_type: The type of the associated instance. Valid values: `EcsInstance`, `NetworkInterface`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HaVipAssociateState.__new__(_HaVipAssociateState)

        __props__.__dict__["ha_vip_id"] = ha_vip_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_type"] = instance_type
        return HaVipAssociate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="haVipId")
    def ha_vip_id(self) -> pulumi.Output[str]:
        """
        The id of the Ha Vip.
        """
        return pulumi.get(self, "ha_vip_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The id of the associated instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of the associated instance. Valid values: `EcsInstance`, `NetworkInterface`.
        """
        return pulumi.get(self, "instance_type")

