# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'HaVipsResult',
    'AwaitableHaVipsResult',
    'ha_vips',
    'ha_vips_output',
]

@pulumi.output_type
class HaVipsResult:
    """
    A collection of values returned by HaVips.
    """
    def __init__(__self__, ha_vip_name=None, ha_vips=None, id=None, ids=None, ip_address=None, name_regex=None, output_file=None, project_name=None, status=None, subnet_id=None, total_count=None, vpc_id=None):
        if ha_vip_name and not isinstance(ha_vip_name, str):
            raise TypeError("Expected argument 'ha_vip_name' to be a str")
        pulumi.set(__self__, "ha_vip_name", ha_vip_name)
        if ha_vips and not isinstance(ha_vips, list):
            raise TypeError("Expected argument 'ha_vips' to be a list")
        pulumi.set(__self__, "ha_vips", ha_vips)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if ip_address and not isinstance(ip_address, str):
            raise TypeError("Expected argument 'ip_address' to be a str")
        pulumi.set(__self__, "ip_address", ip_address)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="haVipName")
    def ha_vip_name(self) -> Optional[str]:
        """
        The name of the Ha Vip.
        """
        return pulumi.get(self, "ha_vip_name")

    @property
    @pulumi.getter(name="haVips")
    def ha_vips(self) -> Sequence['outputs.HaVipsHaVipResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "ha_vips")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        The ip address of the Ha Vip.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[str]:
        """
        The project name of the Ha Vip.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the Ha Vip.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        The subnet id of the Ha Vip.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        The vpc id of the Ha Vip.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableHaVipsResult(HaVipsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return HaVipsResult(
            ha_vip_name=self.ha_vip_name,
            ha_vips=self.ha_vips,
            id=self.id,
            ids=self.ids,
            ip_address=self.ip_address,
            name_regex=self.name_regex,
            output_file=self.output_file,
            project_name=self.project_name,
            status=self.status,
            subnet_id=self.subnet_id,
            total_count=self.total_count,
            vpc_id=self.vpc_id)


def ha_vips(ha_vip_name: Optional[str] = None,
            ids: Optional[Sequence[str]] = None,
            ip_address: Optional[str] = None,
            name_regex: Optional[str] = None,
            output_file: Optional[str] = None,
            project_name: Optional[str] = None,
            status: Optional[str] = None,
            subnet_id: Optional[str] = None,
            vpc_id: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableHaVipsResult:
    """
    Use this data source to query detailed information of ha vips
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_ha_vip = volcengine.vpc.HaVip("fooHaVip",
        ha_vip_name="acc-test-ha-vip",
        description="acc-test",
        subnet_id=foo_subnet.id)
    #  ip_address = "172.16.0.5"
    foo_ha_vips = volcengine.vpc.ha_vips_output(ids=[foo_ha_vip.id])
    ```


    :param str ha_vip_name: The name of Ha Vip.
    :param Sequence[str] ids: A list of Ha Vip IDs.
    :param str ip_address: The ip address of Ha Vip.
    :param str name_regex: A Name Regex of Resource.
    :param str output_file: File name where to save data source results.
    :param str project_name: The project name of Ha Vip.
    :param str status: The status of Ha Vip.
    :param str subnet_id: The id of subnet.
    :param str vpc_id: The id of vpc.
    """
    __args__ = dict()
    __args__['haVipName'] = ha_vip_name
    __args__['ids'] = ids
    __args__['ipAddress'] = ip_address
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['projectName'] = project_name
    __args__['status'] = status
    __args__['subnetId'] = subnet_id
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:vpc/haVips:HaVips', __args__, opts=opts, typ=HaVipsResult).value

    return AwaitableHaVipsResult(
        ha_vip_name=pulumi.get(__ret__, 'ha_vip_name'),
        ha_vips=pulumi.get(__ret__, 'ha_vips'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        ip_address=pulumi.get(__ret__, 'ip_address'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        project_name=pulumi.get(__ret__, 'project_name'),
        status=pulumi.get(__ret__, 'status'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        total_count=pulumi.get(__ret__, 'total_count'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))


@_utilities.lift_output_func(ha_vips)
def ha_vips_output(ha_vip_name: Optional[pulumi.Input[Optional[str]]] = None,
                   ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                   ip_address: Optional[pulumi.Input[Optional[str]]] = None,
                   name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                   output_file: Optional[pulumi.Input[Optional[str]]] = None,
                   project_name: Optional[pulumi.Input[Optional[str]]] = None,
                   status: Optional[pulumi.Input[Optional[str]]] = None,
                   subnet_id: Optional[pulumi.Input[Optional[str]]] = None,
                   vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[HaVipsResult]:
    """
    Use this data source to query detailed information of ha vips
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_ha_vip = volcengine.vpc.HaVip("fooHaVip",
        ha_vip_name="acc-test-ha-vip",
        description="acc-test",
        subnet_id=foo_subnet.id)
    #  ip_address = "172.16.0.5"
    foo_ha_vips = volcengine.vpc.ha_vips_output(ids=[foo_ha_vip.id])
    ```


    :param str ha_vip_name: The name of Ha Vip.
    :param Sequence[str] ids: A list of Ha Vip IDs.
    :param str ip_address: The ip address of Ha Vip.
    :param str name_regex: A Name Regex of Resource.
    :param str output_file: File name where to save data source results.
    :param str project_name: The project name of Ha Vip.
    :param str status: The status of Ha Vip.
    :param str subnet_id: The id of subnet.
    :param str vpc_id: The id of vpc.
    """
    ...
