# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['Ipv6AddressBandwidthArgs', 'Ipv6AddressBandwidth']

@pulumi.input_type
class Ipv6AddressBandwidthArgs:
    def __init__(__self__, *,
                 billing_type: pulumi.Input[str],
                 ipv6_address: pulumi.Input[str],
                 bandwidth: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Ipv6AddressBandwidth resource.
        :param pulumi.Input[str] billing_type: BillingType of the Ipv6 bandwidth. Valid values: `PostPaidByBandwidth`; `PostPaidByTraffic`.
        :param pulumi.Input[str] ipv6_address: Ipv6 address.
        :param pulumi.Input[int] bandwidth: Peek bandwidth of the Ipv6 address. Valid values: 1 to 200. Unit: Mbit/s.
        """
        pulumi.set(__self__, "billing_type", billing_type)
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)

    @property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> pulumi.Input[str]:
        """
        BillingType of the Ipv6 bandwidth. Valid values: `PostPaidByBandwidth`; `PostPaidByTraffic`.
        """
        return pulumi.get(self, "billing_type")

    @billing_type.setter
    def billing_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "billing_type", value)

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> pulumi.Input[str]:
        """
        Ipv6 address.
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ipv6_address", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        Peek bandwidth of the Ipv6 address. Valid values: 1 to 200. Unit: Mbit/s.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth", value)


@pulumi.input_type
class _Ipv6AddressBandwidthState:
    def __init__(__self__, *,
                 allocation_id: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 billing_type: Optional[pulumi.Input[str]] = None,
                 business_status: Optional[pulumi.Input[str]] = None,
                 creation_time: Optional[pulumi.Input[str]] = None,
                 delete_time: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 ipv6_address: Optional[pulumi.Input[str]] = None,
                 isp: Optional[pulumi.Input[str]] = None,
                 lock_reason: Optional[pulumi.Input[str]] = None,
                 network_type: Optional[pulumi.Input[str]] = None,
                 overdue_time: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Ipv6AddressBandwidth resources.
        :param pulumi.Input[str] allocation_id: The ID of the Ipv6AddressBandwidth.
        :param pulumi.Input[int] bandwidth: Peek bandwidth of the Ipv6 address. Valid values: 1 to 200. Unit: Mbit/s.
        :param pulumi.Input[str] billing_type: BillingType of the Ipv6 bandwidth. Valid values: `PostPaidByBandwidth`; `PostPaidByTraffic`.
        :param pulumi.Input[str] business_status: The BusinessStatus of the Ipv6AddressBandwidth.
        :param pulumi.Input[str] creation_time: Creation time of the Ipv6AddressBandwidth.
        :param pulumi.Input[str] delete_time: Delete time of the Ipv6AddressBandwidth.
        :param pulumi.Input[str] instance_id: The ID of the associated instance.
        :param pulumi.Input[str] instance_type: The type of the associated instance.
        :param pulumi.Input[str] ipv6_address: Ipv6 address.
        :param pulumi.Input[str] isp: The ISP of the Ipv6AddressBandwidth.
        :param pulumi.Input[str] lock_reason: The BusinessStatus of the Ipv6AddressBandwidth.
        :param pulumi.Input[str] network_type: The network type of the Ipv6AddressBandwidth.
        :param pulumi.Input[str] overdue_time: Overdue time of the Ipv6AddressBandwidth.
        :param pulumi.Input[str] status: The status of the Ipv6AddressBandwidth.
        :param pulumi.Input[str] update_time: Update time of the Ipv6AddressBandwidth.
        """
        if allocation_id is not None:
            pulumi.set(__self__, "allocation_id", allocation_id)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if billing_type is not None:
            pulumi.set(__self__, "billing_type", billing_type)
        if business_status is not None:
            pulumi.set(__self__, "business_status", business_status)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if lock_reason is not None:
            pulumi.set(__self__, "lock_reason", lock_reason)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if overdue_time is not None:
            pulumi.set(__self__, "overdue_time", overdue_time)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Ipv6AddressBandwidth.
        """
        return pulumi.get(self, "allocation_id")

    @allocation_id.setter
    def allocation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocation_id", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        Peek bandwidth of the Ipv6 address. Valid values: 1 to 200. Unit: Mbit/s.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> Optional[pulumi.Input[str]]:
        """
        BillingType of the Ipv6 bandwidth. Valid values: `PostPaidByBandwidth`; `PostPaidByTraffic`.
        """
        return pulumi.get(self, "billing_type")

    @billing_type.setter
    def billing_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "billing_type", value)

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> Optional[pulumi.Input[str]]:
        """
        The BusinessStatus of the Ipv6AddressBandwidth.
        """
        return pulumi.get(self, "business_status")

    @business_status.setter
    def business_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "business_status", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        Creation time of the Ipv6AddressBandwidth.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[str]]:
        """
        Delete time of the Ipv6AddressBandwidth.
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_time", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the associated instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the associated instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[str]]:
        """
        Ipv6 address.
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_address", value)

    @property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[str]]:
        """
        The ISP of the Ipv6AddressBandwidth.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "isp", value)

    @property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> Optional[pulumi.Input[str]]:
        """
        The BusinessStatus of the Ipv6AddressBandwidth.
        """
        return pulumi.get(self, "lock_reason")

    @lock_reason.setter
    def lock_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lock_reason", value)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[str]]:
        """
        The network type of the Ipv6AddressBandwidth.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_type", value)

    @property
    @pulumi.getter(name="overdueTime")
    def overdue_time(self) -> Optional[pulumi.Input[str]]:
        """
        Overdue time of the Ipv6AddressBandwidth.
        """
        return pulumi.get(self, "overdue_time")

    @overdue_time.setter
    def overdue_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "overdue_time", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the Ipv6AddressBandwidth.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Update time of the Ipv6AddressBandwidth.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class Ipv6AddressBandwidth(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 billing_type: Optional[pulumi.Input[str]] = None,
                 ipv6_address: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        data_ecs = volcengine.ecs.instances(ids=["i-ycal1mtpucl8j0hjiihy"])
        data_ipv6 = volcengine.vpc.ipv6_addresses(associated_instance_id=data_ecs.instances[0].instance_id)
        foo = volcengine.vpc.Ipv6AddressBandwidth("foo",
            ipv6_address=data_ipv6.ipv6_addresses[0].ipv6_address,
            billing_type="PostPaidByBandwidth",
            bandwidth=5)
        ```

        ## Import

        Ipv6AddressBandwidth can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpc/ipv6AddressBandwidth:Ipv6AddressBandwidth default eip-2fede9fsgnr4059gp674m6ney
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] bandwidth: Peek bandwidth of the Ipv6 address. Valid values: 1 to 200. Unit: Mbit/s.
        :param pulumi.Input[str] billing_type: BillingType of the Ipv6 bandwidth. Valid values: `PostPaidByBandwidth`; `PostPaidByTraffic`.
        :param pulumi.Input[str] ipv6_address: Ipv6 address.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Ipv6AddressBandwidthArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        data_ecs = volcengine.ecs.instances(ids=["i-ycal1mtpucl8j0hjiihy"])
        data_ipv6 = volcengine.vpc.ipv6_addresses(associated_instance_id=data_ecs.instances[0].instance_id)
        foo = volcengine.vpc.Ipv6AddressBandwidth("foo",
            ipv6_address=data_ipv6.ipv6_addresses[0].ipv6_address,
            billing_type="PostPaidByBandwidth",
            bandwidth=5)
        ```

        ## Import

        Ipv6AddressBandwidth can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpc/ipv6AddressBandwidth:Ipv6AddressBandwidth default eip-2fede9fsgnr4059gp674m6ney
        ```

        :param str resource_name: The name of the resource.
        :param Ipv6AddressBandwidthArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Ipv6AddressBandwidthArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 billing_type: Optional[pulumi.Input[str]] = None,
                 ipv6_address: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Ipv6AddressBandwidthArgs.__new__(Ipv6AddressBandwidthArgs)

            __props__.__dict__["bandwidth"] = bandwidth
            if billing_type is None and not opts.urn:
                raise TypeError("Missing required property 'billing_type'")
            __props__.__dict__["billing_type"] = billing_type
            if ipv6_address is None and not opts.urn:
                raise TypeError("Missing required property 'ipv6_address'")
            __props__.__dict__["ipv6_address"] = ipv6_address
            __props__.__dict__["allocation_id"] = None
            __props__.__dict__["business_status"] = None
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["instance_id"] = None
            __props__.__dict__["instance_type"] = None
            __props__.__dict__["isp"] = None
            __props__.__dict__["lock_reason"] = None
            __props__.__dict__["network_type"] = None
            __props__.__dict__["overdue_time"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["update_time"] = None
        super(Ipv6AddressBandwidth, __self__).__init__(
            'volcengine:vpc/ipv6AddressBandwidth:Ipv6AddressBandwidth',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocation_id: Optional[pulumi.Input[str]] = None,
            bandwidth: Optional[pulumi.Input[int]] = None,
            billing_type: Optional[pulumi.Input[str]] = None,
            business_status: Optional[pulumi.Input[str]] = None,
            creation_time: Optional[pulumi.Input[str]] = None,
            delete_time: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            ipv6_address: Optional[pulumi.Input[str]] = None,
            isp: Optional[pulumi.Input[str]] = None,
            lock_reason: Optional[pulumi.Input[str]] = None,
            network_type: Optional[pulumi.Input[str]] = None,
            overdue_time: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'Ipv6AddressBandwidth':
        """
        Get an existing Ipv6AddressBandwidth resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allocation_id: The ID of the Ipv6AddressBandwidth.
        :param pulumi.Input[int] bandwidth: Peek bandwidth of the Ipv6 address. Valid values: 1 to 200. Unit: Mbit/s.
        :param pulumi.Input[str] billing_type: BillingType of the Ipv6 bandwidth. Valid values: `PostPaidByBandwidth`; `PostPaidByTraffic`.
        :param pulumi.Input[str] business_status: The BusinessStatus of the Ipv6AddressBandwidth.
        :param pulumi.Input[str] creation_time: Creation time of the Ipv6AddressBandwidth.
        :param pulumi.Input[str] delete_time: Delete time of the Ipv6AddressBandwidth.
        :param pulumi.Input[str] instance_id: The ID of the associated instance.
        :param pulumi.Input[str] instance_type: The type of the associated instance.
        :param pulumi.Input[str] ipv6_address: Ipv6 address.
        :param pulumi.Input[str] isp: The ISP of the Ipv6AddressBandwidth.
        :param pulumi.Input[str] lock_reason: The BusinessStatus of the Ipv6AddressBandwidth.
        :param pulumi.Input[str] network_type: The network type of the Ipv6AddressBandwidth.
        :param pulumi.Input[str] overdue_time: Overdue time of the Ipv6AddressBandwidth.
        :param pulumi.Input[str] status: The status of the Ipv6AddressBandwidth.
        :param pulumi.Input[str] update_time: Update time of the Ipv6AddressBandwidth.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Ipv6AddressBandwidthState.__new__(_Ipv6AddressBandwidthState)

        __props__.__dict__["allocation_id"] = allocation_id
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["billing_type"] = billing_type
        __props__.__dict__["business_status"] = business_status
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["delete_time"] = delete_time
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["ipv6_address"] = ipv6_address
        __props__.__dict__["isp"] = isp
        __props__.__dict__["lock_reason"] = lock_reason
        __props__.__dict__["network_type"] = network_type
        __props__.__dict__["overdue_time"] = overdue_time
        __props__.__dict__["status"] = status
        __props__.__dict__["update_time"] = update_time
        return Ipv6AddressBandwidth(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> pulumi.Output[str]:
        """
        The ID of the Ipv6AddressBandwidth.
        """
        return pulumi.get(self, "allocation_id")

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[int]:
        """
        Peek bandwidth of the Ipv6 address. Valid values: 1 to 200. Unit: Mbit/s.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> pulumi.Output[str]:
        """
        BillingType of the Ipv6 bandwidth. Valid values: `PostPaidByBandwidth`; `PostPaidByTraffic`.
        """
        return pulumi.get(self, "billing_type")

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> pulumi.Output[str]:
        """
        The BusinessStatus of the Ipv6AddressBandwidth.
        """
        return pulumi.get(self, "business_status")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        Creation time of the Ipv6AddressBandwidth.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[str]:
        """
        Delete time of the Ipv6AddressBandwidth.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The ID of the associated instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        The type of the associated instance.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> pulumi.Output[str]:
        """
        Ipv6 address.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter
    def isp(self) -> pulumi.Output[str]:
        """
        The ISP of the Ipv6AddressBandwidth.
        """
        return pulumi.get(self, "isp")

    @property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> pulumi.Output[str]:
        """
        The BusinessStatus of the Ipv6AddressBandwidth.
        """
        return pulumi.get(self, "lock_reason")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[str]:
        """
        The network type of the Ipv6AddressBandwidth.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="overdueTime")
    def overdue_time(self) -> pulumi.Output[str]:
        """
        Overdue time of the Ipv6AddressBandwidth.
        """
        return pulumi.get(self, "overdue_time")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the Ipv6AddressBandwidth.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Update time of the Ipv6AddressBandwidth.
        """
        return pulumi.get(self, "update_time")

