# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'Ipv6AddressesResult',
    'AwaitableIpv6AddressesResult',
    'ipv6_addresses',
    'ipv6_addresses_output',
]

@pulumi.output_type
class Ipv6AddressesResult:
    """
    A collection of values returned by Ipv6Addresses.
    """
    def __init__(__self__, associated_instance_id=None, id=None, ipv6_addresses=None, output_file=None, total_count=None):
        if associated_instance_id and not isinstance(associated_instance_id, str):
            raise TypeError("Expected argument 'associated_instance_id' to be a str")
        pulumi.set(__self__, "associated_instance_id", associated_instance_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipv6_addresses and not isinstance(ipv6_addresses, list):
            raise TypeError("Expected argument 'ipv6_addresses' to be a list")
        pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="associatedInstanceId")
    def associated_instance_id(self) -> Optional[str]:
        return pulumi.get(self, "associated_instance_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Sequence['outputs.Ipv6AddressesIpv6AddressResult']:
        """
        The collection of Ipv6Address query.
        """
        return pulumi.get(self, "ipv6_addresses")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of Ipv6Address query.
        """
        return pulumi.get(self, "total_count")


class AwaitableIpv6AddressesResult(Ipv6AddressesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return Ipv6AddressesResult(
            associated_instance_id=self.associated_instance_id,
            id=self.id,
            ipv6_addresses=self.ipv6_addresses,
            output_file=self.output_file,
            total_count=self.total_count)


def ipv6_addresses(associated_instance_id: Optional[str] = None,
                   output_file: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableIpv6AddressesResult:
    """
    Use this data source to query detailed information of vpc ipv6 addresses
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.vpc.ipv6_addresses(associated_instance_id="i-yca53yuhj6gh9zl53kav")
    ```


    :param str associated_instance_id: The ID of the ECS instance that is assigned the IPv6 address.
    :param str output_file: File name where to save data source results.
    """
    __args__ = dict()
    __args__['associatedInstanceId'] = associated_instance_id
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:vpc/ipv6Addresses:Ipv6Addresses', __args__, opts=opts, typ=Ipv6AddressesResult).value

    return AwaitableIpv6AddressesResult(
        associated_instance_id=pulumi.get(__ret__, 'associated_instance_id'),
        id=pulumi.get(__ret__, 'id'),
        ipv6_addresses=pulumi.get(__ret__, 'ipv6_addresses'),
        output_file=pulumi.get(__ret__, 'output_file'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(ipv6_addresses)
def ipv6_addresses_output(associated_instance_id: Optional[pulumi.Input[Optional[str]]] = None,
                          output_file: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[Ipv6AddressesResult]:
    """
    Use this data source to query detailed information of vpc ipv6 addresses
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.vpc.ipv6_addresses(associated_instance_id="i-yca53yuhj6gh9zl53kav")
    ```


    :param str associated_instance_id: The ID of the ECS instance that is assigned the IPv6 address.
    :param str output_file: File name where to save data source results.
    """
    ...
