# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['Ipv6GatewayArgs', 'Ipv6Gateway']

@pulumi.input_type
class Ipv6GatewayArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Ipv6Gateway resource.
        :param pulumi.Input[str] vpc_id: The ID of the VPC which the Ipv6Gateway belongs to.
        :param pulumi.Input[str] description: The description of the Ipv6Gateway.
        :param pulumi.Input[str] name: The name of the Ipv6Gateway.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        The ID of the VPC which the Ipv6Gateway belongs to.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Ipv6Gateway.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Ipv6Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _Ipv6GatewayState:
    def __init__(__self__, *,
                 creation_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ipv6_gateway_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Ipv6Gateway resources.
        :param pulumi.Input[str] creation_time: Creation time of the Ipv6Gateway.
        :param pulumi.Input[str] description: The description of the Ipv6Gateway.
        :param pulumi.Input[str] ipv6_gateway_id: The ID of the Ipv6Gateway.
        :param pulumi.Input[str] name: The name of the Ipv6Gateway.
        :param pulumi.Input[str] status: The Status of the Ipv6Gateway.
        :param pulumi.Input[str] update_time: Update time of the Ipv6Gateway.
        :param pulumi.Input[str] vpc_id: The ID of the VPC which the Ipv6Gateway belongs to.
        """
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ipv6_gateway_id is not None:
            pulumi.set(__self__, "ipv6_gateway_id", ipv6_gateway_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        Creation time of the Ipv6Gateway.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Ipv6Gateway.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ipv6GatewayId")
    def ipv6_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Ipv6Gateway.
        """
        return pulumi.get(self, "ipv6_gateway_id")

    @ipv6_gateway_id.setter
    def ipv6_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_gateway_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Ipv6Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The Status of the Ipv6Gateway.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Update time of the Ipv6Gateway.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPC which the Ipv6Gateway belongs to.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Ipv6Gateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage vpc ipv6 gateway
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.vpc.Ipv6Gateway("foo",
            description="test",
            vpc_id="vpc-12afxho4sxyio17q7y2kkp8ej")
        ```

        ## Import

        Ipv6Gateway can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpc/ipv6Gateway:Ipv6Gateway default ipv6gw-12bcapllb5ukg17q7y2sd3thx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the Ipv6Gateway.
        :param pulumi.Input[str] name: The name of the Ipv6Gateway.
        :param pulumi.Input[str] vpc_id: The ID of the VPC which the Ipv6Gateway belongs to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Ipv6GatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage vpc ipv6 gateway
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.vpc.Ipv6Gateway("foo",
            description="test",
            vpc_id="vpc-12afxho4sxyio17q7y2kkp8ej")
        ```

        ## Import

        Ipv6Gateway can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpc/ipv6Gateway:Ipv6Gateway default ipv6gw-12bcapllb5ukg17q7y2sd3thx
        ```

        :param str resource_name: The name of the resource.
        :param Ipv6GatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Ipv6GatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Ipv6GatewayArgs.__new__(Ipv6GatewayArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["ipv6_gateway_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["update_time"] = None
        super(Ipv6Gateway, __self__).__init__(
            'volcengine:vpc/ipv6Gateway:Ipv6Gateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            ipv6_gateway_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Ipv6Gateway':
        """
        Get an existing Ipv6Gateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] creation_time: Creation time of the Ipv6Gateway.
        :param pulumi.Input[str] description: The description of the Ipv6Gateway.
        :param pulumi.Input[str] ipv6_gateway_id: The ID of the Ipv6Gateway.
        :param pulumi.Input[str] name: The name of the Ipv6Gateway.
        :param pulumi.Input[str] status: The Status of the Ipv6Gateway.
        :param pulumi.Input[str] update_time: Update time of the Ipv6Gateway.
        :param pulumi.Input[str] vpc_id: The ID of the VPC which the Ipv6Gateway belongs to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Ipv6GatewayState.__new__(_Ipv6GatewayState)

        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["description"] = description
        __props__.__dict__["ipv6_gateway_id"] = ipv6_gateway_id
        __props__.__dict__["name"] = name
        __props__.__dict__["status"] = status
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["vpc_id"] = vpc_id
        return Ipv6Gateway(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        Creation time of the Ipv6Gateway.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the Ipv6Gateway.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ipv6GatewayId")
    def ipv6_gateway_id(self) -> pulumi.Output[str]:
        """
        The ID of the Ipv6Gateway.
        """
        return pulumi.get(self, "ipv6_gateway_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Ipv6Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The Status of the Ipv6Gateway.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Update time of the Ipv6Gateway.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The ID of the VPC which the Ipv6Gateway belongs to.
        """
        return pulumi.get(self, "vpc_id")

