# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkAclArgs', 'NetworkAcl']

@pulumi.input_type
class NetworkAclArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 egress_acl_entries: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclEgressAclEntryArgs']]]] = None,
                 ingress_acl_entries: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclIngressAclEntryArgs']]]] = None,
                 network_acl_name: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a NetworkAcl resource.
        :param pulumi.Input[str] vpc_id: The vpc id of Network Acl.
        :param pulumi.Input[str] description: The description of the Network Acl.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAclEgressAclEntryArgs']]] egress_acl_entries: The egress entries of Network Acl.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAclIngressAclEntryArgs']]] ingress_acl_entries: The ingress entries of Network Acl.
        :param pulumi.Input[str] network_acl_name: The name of Network Acl.
        :param pulumi.Input[str] project_name: The project name of the network acl.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if egress_acl_entries is not None:
            pulumi.set(__self__, "egress_acl_entries", egress_acl_entries)
        if ingress_acl_entries is not None:
            pulumi.set(__self__, "ingress_acl_entries", ingress_acl_entries)
        if network_acl_name is not None:
            pulumi.set(__self__, "network_acl_name", network_acl_name)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        The vpc id of Network Acl.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Network Acl.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="egressAclEntries")
    def egress_acl_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclEgressAclEntryArgs']]]]:
        """
        The egress entries of Network Acl.
        """
        return pulumi.get(self, "egress_acl_entries")

    @egress_acl_entries.setter
    def egress_acl_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclEgressAclEntryArgs']]]]):
        pulumi.set(self, "egress_acl_entries", value)

    @property
    @pulumi.getter(name="ingressAclEntries")
    def ingress_acl_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclIngressAclEntryArgs']]]]:
        """
        The ingress entries of Network Acl.
        """
        return pulumi.get(self, "ingress_acl_entries")

    @ingress_acl_entries.setter
    def ingress_acl_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclIngressAclEntryArgs']]]]):
        pulumi.set(self, "ingress_acl_entries", value)

    @property
    @pulumi.getter(name="networkAclName")
    def network_acl_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of Network Acl.
        """
        return pulumi.get(self, "network_acl_name")

    @network_acl_name.setter
    def network_acl_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_acl_name", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name of the network acl.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)


@pulumi.input_type
class _NetworkAclState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 egress_acl_entries: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclEgressAclEntryArgs']]]] = None,
                 ingress_acl_entries: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclIngressAclEntryArgs']]]] = None,
                 network_acl_name: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering NetworkAcl resources.
        :param pulumi.Input[str] description: The description of the Network Acl.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAclEgressAclEntryArgs']]] egress_acl_entries: The egress entries of Network Acl.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAclIngressAclEntryArgs']]] ingress_acl_entries: The ingress entries of Network Acl.
        :param pulumi.Input[str] network_acl_name: The name of Network Acl.
        :param pulumi.Input[str] project_name: The project name of the network acl.
        :param pulumi.Input[str] vpc_id: The vpc id of Network Acl.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if egress_acl_entries is not None:
            pulumi.set(__self__, "egress_acl_entries", egress_acl_entries)
        if ingress_acl_entries is not None:
            pulumi.set(__self__, "ingress_acl_entries", ingress_acl_entries)
        if network_acl_name is not None:
            pulumi.set(__self__, "network_acl_name", network_acl_name)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Network Acl.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="egressAclEntries")
    def egress_acl_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclEgressAclEntryArgs']]]]:
        """
        The egress entries of Network Acl.
        """
        return pulumi.get(self, "egress_acl_entries")

    @egress_acl_entries.setter
    def egress_acl_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclEgressAclEntryArgs']]]]):
        pulumi.set(self, "egress_acl_entries", value)

    @property
    @pulumi.getter(name="ingressAclEntries")
    def ingress_acl_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclIngressAclEntryArgs']]]]:
        """
        The ingress entries of Network Acl.
        """
        return pulumi.get(self, "ingress_acl_entries")

    @ingress_acl_entries.setter
    def ingress_acl_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclIngressAclEntryArgs']]]]):
        pulumi.set(self, "ingress_acl_entries", value)

    @property
    @pulumi.getter(name="networkAclName")
    def network_acl_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of Network Acl.
        """
        return pulumi.get(self, "network_acl_name")

    @network_acl_name.setter
    def network_acl_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_acl_name", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name of the network acl.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vpc id of Network Acl.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class NetworkAcl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 egress_acl_entries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAclEgressAclEntryArgs']]]]] = None,
                 ingress_acl_entries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAclIngressAclEntryArgs']]]]] = None,
                 network_acl_name: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage network acl
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.vpc.NetworkAcl("foo",
            egress_acl_entries=[volcengine.vpc.NetworkAclEgressAclEntryArgs(
                destination_cidr_ip="192.168.0.0/16",
                network_acl_entry_name="egress2",
                policy="accept",
                protocol="all",
            )],
            ingress_acl_entries=[
                volcengine.vpc.NetworkAclIngressAclEntryArgs(
                    network_acl_entry_name="ingress1",
                    policy="accept",
                    protocol="all",
                    source_cidr_ip="192.168.0.0/24",
                ),
                volcengine.vpc.NetworkAclIngressAclEntryArgs(
                    network_acl_entry_name="ingress3",
                    policy="accept",
                    port="80/80",
                    protocol="tcp",
                    source_cidr_ip="192.168.0.0/24",
                ),
            ],
            network_acl_name="tf-test-acl",
            project_name="default",
            vpc_id="vpc-2d6jskar243k058ozfdae13ne")
        ```

        ## Import

        Network Acl can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpc/networkAcl:NetworkAcl default nacl-172leak37mi9s4d1w33pswqkh
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the Network Acl.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAclEgressAclEntryArgs']]]] egress_acl_entries: The egress entries of Network Acl.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAclIngressAclEntryArgs']]]] ingress_acl_entries: The ingress entries of Network Acl.
        :param pulumi.Input[str] network_acl_name: The name of Network Acl.
        :param pulumi.Input[str] project_name: The project name of the network acl.
        :param pulumi.Input[str] vpc_id: The vpc id of Network Acl.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkAclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage network acl
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.vpc.NetworkAcl("foo",
            egress_acl_entries=[volcengine.vpc.NetworkAclEgressAclEntryArgs(
                destination_cidr_ip="192.168.0.0/16",
                network_acl_entry_name="egress2",
                policy="accept",
                protocol="all",
            )],
            ingress_acl_entries=[
                volcengine.vpc.NetworkAclIngressAclEntryArgs(
                    network_acl_entry_name="ingress1",
                    policy="accept",
                    protocol="all",
                    source_cidr_ip="192.168.0.0/24",
                ),
                volcengine.vpc.NetworkAclIngressAclEntryArgs(
                    network_acl_entry_name="ingress3",
                    policy="accept",
                    port="80/80",
                    protocol="tcp",
                    source_cidr_ip="192.168.0.0/24",
                ),
            ],
            network_acl_name="tf-test-acl",
            project_name="default",
            vpc_id="vpc-2d6jskar243k058ozfdae13ne")
        ```

        ## Import

        Network Acl can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpc/networkAcl:NetworkAcl default nacl-172leak37mi9s4d1w33pswqkh
        ```

        :param str resource_name: The name of the resource.
        :param NetworkAclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkAclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 egress_acl_entries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAclEgressAclEntryArgs']]]]] = None,
                 ingress_acl_entries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAclIngressAclEntryArgs']]]]] = None,
                 network_acl_name: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkAclArgs.__new__(NetworkAclArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["egress_acl_entries"] = egress_acl_entries
            __props__.__dict__["ingress_acl_entries"] = ingress_acl_entries
            __props__.__dict__["network_acl_name"] = network_acl_name
            __props__.__dict__["project_name"] = project_name
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
        super(NetworkAcl, __self__).__init__(
            'volcengine:vpc/networkAcl:NetworkAcl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            egress_acl_entries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAclEgressAclEntryArgs']]]]] = None,
            ingress_acl_entries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAclIngressAclEntryArgs']]]]] = None,
            network_acl_name: Optional[pulumi.Input[str]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'NetworkAcl':
        """
        Get an existing NetworkAcl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the Network Acl.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAclEgressAclEntryArgs']]]] egress_acl_entries: The egress entries of Network Acl.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAclIngressAclEntryArgs']]]] ingress_acl_entries: The ingress entries of Network Acl.
        :param pulumi.Input[str] network_acl_name: The name of Network Acl.
        :param pulumi.Input[str] project_name: The project name of the network acl.
        :param pulumi.Input[str] vpc_id: The vpc id of Network Acl.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkAclState.__new__(_NetworkAclState)

        __props__.__dict__["description"] = description
        __props__.__dict__["egress_acl_entries"] = egress_acl_entries
        __props__.__dict__["ingress_acl_entries"] = ingress_acl_entries
        __props__.__dict__["network_acl_name"] = network_acl_name
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["vpc_id"] = vpc_id
        return NetworkAcl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Network Acl.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="egressAclEntries")
    def egress_acl_entries(self) -> pulumi.Output[Sequence['outputs.NetworkAclEgressAclEntry']]:
        """
        The egress entries of Network Acl.
        """
        return pulumi.get(self, "egress_acl_entries")

    @property
    @pulumi.getter(name="ingressAclEntries")
    def ingress_acl_entries(self) -> pulumi.Output[Sequence['outputs.NetworkAclIngressAclEntry']]:
        """
        The ingress entries of Network Acl.
        """
        return pulumi.get(self, "ingress_acl_entries")

    @property
    @pulumi.getter(name="networkAclName")
    def network_acl_name(self) -> pulumi.Output[str]:
        """
        The name of Network Acl.
        """
        return pulumi.get(self, "network_acl_name")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        The project name of the network acl.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The vpc id of Network Acl.
        """
        return pulumi.get(self, "vpc_id")

