# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PrefixListArgs', 'PrefixList']

@pulumi.input_type
class PrefixListArgs:
    def __init__(__self__, *,
                 max_entries: pulumi.Input[int],
                 description: Optional[pulumi.Input[str]] = None,
                 ip_version: Optional[pulumi.Input[str]] = None,
                 prefix_list_entries: Optional[pulumi.Input[Sequence[pulumi.Input['PrefixListPrefixListEntryArgs']]]] = None,
                 prefix_list_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['PrefixListTagArgs']]]] = None):
        """
        The set of arguments for constructing a PrefixList resource.
        :param pulumi.Input[int] max_entries: Maximum number of entries, which is the maximum number of entries that can be added to the prefix list. The value range is 1 to 200.
        :param pulumi.Input[str] description: The description of the prefix list.
        :param pulumi.Input[str] ip_version: IP version type. Possible values:
               IPv4 (default): IPv4 type.
               IPv6: IPv6 type.
        :param pulumi.Input[Sequence[pulumi.Input['PrefixListPrefixListEntryArgs']]] prefix_list_entries: Prefix list entry list.
        :param pulumi.Input[str] prefix_list_name: The name of the prefix list.
        :param pulumi.Input[Sequence[pulumi.Input['PrefixListTagArgs']]] tags: Tags.
        """
        pulumi.set(__self__, "max_entries", max_entries)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if prefix_list_entries is not None:
            pulumi.set(__self__, "prefix_list_entries", prefix_list_entries)
        if prefix_list_name is not None:
            pulumi.set(__self__, "prefix_list_name", prefix_list_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="maxEntries")
    def max_entries(self) -> pulumi.Input[int]:
        """
        Maximum number of entries, which is the maximum number of entries that can be added to the prefix list. The value range is 1 to 200.
        """
        return pulumi.get(self, "max_entries")

    @max_entries.setter
    def max_entries(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_entries", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the prefix list.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[str]]:
        """
        IP version type. Possible values:
        IPv4 (default): IPv4 type.
        IPv6: IPv6 type.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter(name="prefixListEntries")
    def prefix_list_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PrefixListPrefixListEntryArgs']]]]:
        """
        Prefix list entry list.
        """
        return pulumi.get(self, "prefix_list_entries")

    @prefix_list_entries.setter
    def prefix_list_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PrefixListPrefixListEntryArgs']]]]):
        pulumi.set(self, "prefix_list_entries", value)

    @property
    @pulumi.getter(name="prefixListName")
    def prefix_list_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the prefix list.
        """
        return pulumi.get(self, "prefix_list_name")

    @prefix_list_name.setter
    def prefix_list_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix_list_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PrefixListTagArgs']]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PrefixListTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _PrefixListState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_version: Optional[pulumi.Input[str]] = None,
                 max_entries: Optional[pulumi.Input[int]] = None,
                 prefix_list_associations: Optional[pulumi.Input[Sequence[pulumi.Input['PrefixListPrefixListAssociationArgs']]]] = None,
                 prefix_list_entries: Optional[pulumi.Input[Sequence[pulumi.Input['PrefixListPrefixListEntryArgs']]]] = None,
                 prefix_list_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['PrefixListTagArgs']]]] = None):
        """
        Input properties used for looking up and filtering PrefixList resources.
        :param pulumi.Input[str] description: The description of the prefix list.
        :param pulumi.Input[str] ip_version: IP version type. Possible values:
               IPv4 (default): IPv4 type.
               IPv6: IPv6 type.
        :param pulumi.Input[int] max_entries: Maximum number of entries, which is the maximum number of entries that can be added to the prefix list. The value range is 1 to 200.
        :param pulumi.Input[Sequence[pulumi.Input['PrefixListPrefixListAssociationArgs']]] prefix_list_associations: Collection of resources associated with VPC prefix list.
        :param pulumi.Input[Sequence[pulumi.Input['PrefixListPrefixListEntryArgs']]] prefix_list_entries: Prefix list entry list.
        :param pulumi.Input[str] prefix_list_name: The name of the prefix list.
        :param pulumi.Input[Sequence[pulumi.Input['PrefixListTagArgs']]] tags: Tags.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if max_entries is not None:
            pulumi.set(__self__, "max_entries", max_entries)
        if prefix_list_associations is not None:
            pulumi.set(__self__, "prefix_list_associations", prefix_list_associations)
        if prefix_list_entries is not None:
            pulumi.set(__self__, "prefix_list_entries", prefix_list_entries)
        if prefix_list_name is not None:
            pulumi.set(__self__, "prefix_list_name", prefix_list_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the prefix list.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[str]]:
        """
        IP version type. Possible values:
        IPv4 (default): IPv4 type.
        IPv6: IPv6 type.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter(name="maxEntries")
    def max_entries(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of entries, which is the maximum number of entries that can be added to the prefix list. The value range is 1 to 200.
        """
        return pulumi.get(self, "max_entries")

    @max_entries.setter
    def max_entries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_entries", value)

    @property
    @pulumi.getter(name="prefixListAssociations")
    def prefix_list_associations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PrefixListPrefixListAssociationArgs']]]]:
        """
        Collection of resources associated with VPC prefix list.
        """
        return pulumi.get(self, "prefix_list_associations")

    @prefix_list_associations.setter
    def prefix_list_associations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PrefixListPrefixListAssociationArgs']]]]):
        pulumi.set(self, "prefix_list_associations", value)

    @property
    @pulumi.getter(name="prefixListEntries")
    def prefix_list_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PrefixListPrefixListEntryArgs']]]]:
        """
        Prefix list entry list.
        """
        return pulumi.get(self, "prefix_list_entries")

    @prefix_list_entries.setter
    def prefix_list_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PrefixListPrefixListEntryArgs']]]]):
        pulumi.set(self, "prefix_list_entries", value)

    @property
    @pulumi.getter(name="prefixListName")
    def prefix_list_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the prefix list.
        """
        return pulumi.get(self, "prefix_list_name")

    @prefix_list_name.setter
    def prefix_list_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix_list_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PrefixListTagArgs']]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PrefixListTagArgs']]]]):
        pulumi.set(self, "tags", value)


class PrefixList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_version: Optional[pulumi.Input[str]] = None,
                 max_entries: Optional[pulumi.Input[int]] = None,
                 prefix_list_entries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PrefixListPrefixListEntryArgs']]]]] = None,
                 prefix_list_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PrefixListTagArgs']]]]] = None,
                 __props__=None):
        """
        Provides a resource to manage vpc prefix list
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.vpc.PrefixList("foo",
            description="acc test description",
            ip_version="IPv4",
            max_entries=7,
            prefix_list_entries=[
                volcengine.vpc.PrefixListPrefixListEntryArgs(
                    cidr="192.168.4.0/28",
                    description="acc-test-1",
                ),
                volcengine.vpc.PrefixListPrefixListEntryArgs(
                    cidr="192.168.9.0/28",
                    description="acc-test-4",
                ),
                volcengine.vpc.PrefixListPrefixListEntryArgs(
                    cidr="192.168.8.0/28",
                    description="acc-test-5",
                ),
            ],
            prefix_list_name="acc-test-prefix",
            tags=[volcengine.vpc.PrefixListTagArgs(
                key="tf-key1",
                value="tf-value1",
            )])
        ```

        ## Import

        VpcPrefixList can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpc/prefixList:PrefixList default resource_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the prefix list.
        :param pulumi.Input[str] ip_version: IP version type. Possible values:
               IPv4 (default): IPv4 type.
               IPv6: IPv6 type.
        :param pulumi.Input[int] max_entries: Maximum number of entries, which is the maximum number of entries that can be added to the prefix list. The value range is 1 to 200.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PrefixListPrefixListEntryArgs']]]] prefix_list_entries: Prefix list entry list.
        :param pulumi.Input[str] prefix_list_name: The name of the prefix list.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PrefixListTagArgs']]]] tags: Tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrefixListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage vpc prefix list
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.vpc.PrefixList("foo",
            description="acc test description",
            ip_version="IPv4",
            max_entries=7,
            prefix_list_entries=[
                volcengine.vpc.PrefixListPrefixListEntryArgs(
                    cidr="192.168.4.0/28",
                    description="acc-test-1",
                ),
                volcengine.vpc.PrefixListPrefixListEntryArgs(
                    cidr="192.168.9.0/28",
                    description="acc-test-4",
                ),
                volcengine.vpc.PrefixListPrefixListEntryArgs(
                    cidr="192.168.8.0/28",
                    description="acc-test-5",
                ),
            ],
            prefix_list_name="acc-test-prefix",
            tags=[volcengine.vpc.PrefixListTagArgs(
                key="tf-key1",
                value="tf-value1",
            )])
        ```

        ## Import

        VpcPrefixList can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpc/prefixList:PrefixList default resource_id
        ```

        :param str resource_name: The name of the resource.
        :param PrefixListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrefixListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_version: Optional[pulumi.Input[str]] = None,
                 max_entries: Optional[pulumi.Input[int]] = None,
                 prefix_list_entries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PrefixListPrefixListEntryArgs']]]]] = None,
                 prefix_list_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PrefixListTagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrefixListArgs.__new__(PrefixListArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["ip_version"] = ip_version
            if max_entries is None and not opts.urn:
                raise TypeError("Missing required property 'max_entries'")
            __props__.__dict__["max_entries"] = max_entries
            __props__.__dict__["prefix_list_entries"] = prefix_list_entries
            __props__.__dict__["prefix_list_name"] = prefix_list_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["prefix_list_associations"] = None
        super(PrefixList, __self__).__init__(
            'volcengine:vpc/prefixList:PrefixList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            ip_version: Optional[pulumi.Input[str]] = None,
            max_entries: Optional[pulumi.Input[int]] = None,
            prefix_list_associations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PrefixListPrefixListAssociationArgs']]]]] = None,
            prefix_list_entries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PrefixListPrefixListEntryArgs']]]]] = None,
            prefix_list_name: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PrefixListTagArgs']]]]] = None) -> 'PrefixList':
        """
        Get an existing PrefixList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the prefix list.
        :param pulumi.Input[str] ip_version: IP version type. Possible values:
               IPv4 (default): IPv4 type.
               IPv6: IPv6 type.
        :param pulumi.Input[int] max_entries: Maximum number of entries, which is the maximum number of entries that can be added to the prefix list. The value range is 1 to 200.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PrefixListPrefixListAssociationArgs']]]] prefix_list_associations: Collection of resources associated with VPC prefix list.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PrefixListPrefixListEntryArgs']]]] prefix_list_entries: Prefix list entry list.
        :param pulumi.Input[str] prefix_list_name: The name of the prefix list.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PrefixListTagArgs']]]] tags: Tags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PrefixListState.__new__(_PrefixListState)

        __props__.__dict__["description"] = description
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["max_entries"] = max_entries
        __props__.__dict__["prefix_list_associations"] = prefix_list_associations
        __props__.__dict__["prefix_list_entries"] = prefix_list_entries
        __props__.__dict__["prefix_list_name"] = prefix_list_name
        __props__.__dict__["tags"] = tags
        return PrefixList(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the prefix list.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[str]:
        """
        IP version type. Possible values:
        IPv4 (default): IPv4 type.
        IPv6: IPv6 type.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter(name="maxEntries")
    def max_entries(self) -> pulumi.Output[int]:
        """
        Maximum number of entries, which is the maximum number of entries that can be added to the prefix list. The value range is 1 to 200.
        """
        return pulumi.get(self, "max_entries")

    @property
    @pulumi.getter(name="prefixListAssociations")
    def prefix_list_associations(self) -> pulumi.Output[Sequence['outputs.PrefixListPrefixListAssociation']]:
        """
        Collection of resources associated with VPC prefix list.
        """
        return pulumi.get(self, "prefix_list_associations")

    @property
    @pulumi.getter(name="prefixListEntries")
    def prefix_list_entries(self) -> pulumi.Output[Optional[Sequence['outputs.PrefixListPrefixListEntry']]]:
        """
        Prefix list entry list.
        """
        return pulumi.get(self, "prefix_list_entries")

    @property
    @pulumi.getter(name="prefixListName")
    def prefix_list_name(self) -> pulumi.Output[str]:
        """
        The name of the prefix list.
        """
        return pulumi.get(self, "prefix_list_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.PrefixListTag']]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

