# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'PrefixListsResult',
    'AwaitablePrefixListsResult',
    'prefix_lists',
    'prefix_lists_output',
]

@pulumi.output_type
class PrefixListsResult:
    """
    A collection of values returned by PrefixLists.
    """
    def __init__(__self__, id=None, ids=None, ip_version=None, output_file=None, prefix_list_name=None, prefix_lists=None, tag_filters=None, total_count=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if ip_version and not isinstance(ip_version, str):
            raise TypeError("Expected argument 'ip_version' to be a str")
        pulumi.set(__self__, "ip_version", ip_version)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if prefix_list_name and not isinstance(prefix_list_name, str):
            raise TypeError("Expected argument 'prefix_list_name' to be a str")
        pulumi.set(__self__, "prefix_list_name", prefix_list_name)
        if prefix_lists and not isinstance(prefix_lists, list):
            raise TypeError("Expected argument 'prefix_lists' to be a list")
        pulumi.set(__self__, "prefix_lists", prefix_lists)
        if tag_filters and not isinstance(tag_filters, list):
            raise TypeError("Expected argument 'tag_filters' to be a list")
        pulumi.set(__self__, "tag_filters", tag_filters)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[str]:
        """
        The ip version of the prefix list.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="prefixListName")
    def prefix_list_name(self) -> Optional[str]:
        """
        The prefix list name.
        """
        return pulumi.get(self, "prefix_list_name")

    @property
    @pulumi.getter(name="prefixLists")
    def prefix_lists(self) -> Sequence['outputs.PrefixListsPrefixListResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "prefix_lists")

    @property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> Optional[Sequence['outputs.PrefixListsTagFilterResult']]:
        return pulumi.get(self, "tag_filters")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")


class AwaitablePrefixListsResult(PrefixListsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return PrefixListsResult(
            id=self.id,
            ids=self.ids,
            ip_version=self.ip_version,
            output_file=self.output_file,
            prefix_list_name=self.prefix_list_name,
            prefix_lists=self.prefix_lists,
            tag_filters=self.tag_filters,
            total_count=self.total_count)


def prefix_lists(ids: Optional[Sequence[str]] = None,
                 ip_version: Optional[str] = None,
                 output_file: Optional[str] = None,
                 prefix_list_name: Optional[str] = None,
                 tag_filters: Optional[Sequence[pulumi.InputType['PrefixListsTagFilterArgs']]] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitablePrefixListsResult:
    """
    Use this data source to query detailed information of vpc prefix lists
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_prefix_list = volcengine.vpc.PrefixList("fooPrefixList",
        prefix_list_name="acc-test-prefix",
        max_entries=3,
        description="acc test description",
        ip_version="IPv4",
        prefix_list_entries=[
            volcengine.vpc.PrefixListPrefixListEntryArgs(
                cidr="192.168.4.0/28",
                description="acc-test-1",
            ),
            volcengine.vpc.PrefixListPrefixListEntryArgs(
                cidr="192.168.5.0/28",
                description="acc-test-2",
            ),
        ],
        tags=[volcengine.vpc.PrefixListTagArgs(
            key="tf-key1",
            value="tf-value1",
        )])
    foo_prefix_lists = volcengine.vpc.prefix_lists_output(ids=[foo_prefix_list.id])
    ```


    :param Sequence[str] ids: A list of prefix list ids.
    :param str ip_version: IP version of prefix list.
    :param str output_file: File name where to save data source results.
    :param str prefix_list_name: A Name of prefix list.
    :param Sequence[pulumi.InputType['PrefixListsTagFilterArgs']] tag_filters: List of tag filters.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['ipVersion'] = ip_version
    __args__['outputFile'] = output_file
    __args__['prefixListName'] = prefix_list_name
    __args__['tagFilters'] = tag_filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:vpc/prefixLists:PrefixLists', __args__, opts=opts, typ=PrefixListsResult).value

    return AwaitablePrefixListsResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        ip_version=pulumi.get(__ret__, 'ip_version'),
        output_file=pulumi.get(__ret__, 'output_file'),
        prefix_list_name=pulumi.get(__ret__, 'prefix_list_name'),
        prefix_lists=pulumi.get(__ret__, 'prefix_lists'),
        tag_filters=pulumi.get(__ret__, 'tag_filters'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(prefix_lists)
def prefix_lists_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                        ip_version: Optional[pulumi.Input[Optional[str]]] = None,
                        output_file: Optional[pulumi.Input[Optional[str]]] = None,
                        prefix_list_name: Optional[pulumi.Input[Optional[str]]] = None,
                        tag_filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['PrefixListsTagFilterArgs']]]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[PrefixListsResult]:
    """
    Use this data source to query detailed information of vpc prefix lists
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_prefix_list = volcengine.vpc.PrefixList("fooPrefixList",
        prefix_list_name="acc-test-prefix",
        max_entries=3,
        description="acc test description",
        ip_version="IPv4",
        prefix_list_entries=[
            volcengine.vpc.PrefixListPrefixListEntryArgs(
                cidr="192.168.4.0/28",
                description="acc-test-1",
            ),
            volcengine.vpc.PrefixListPrefixListEntryArgs(
                cidr="192.168.5.0/28",
                description="acc-test-2",
            ),
        ],
        tags=[volcengine.vpc.PrefixListTagArgs(
            key="tf-key1",
            value="tf-value1",
        )])
    foo_prefix_lists = volcengine.vpc.prefix_lists_output(ids=[foo_prefix_list.id])
    ```


    :param Sequence[str] ids: A list of prefix list ids.
    :param str ip_version: IP version of prefix list.
    :param str output_file: File name where to save data source results.
    :param str prefix_list_name: A Name of prefix list.
    :param Sequence[pulumi.InputType['PrefixListsTagFilterArgs']] tag_filters: List of tag filters.
    """
    ...
