# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['RouteEntryArgs', 'RouteEntry']

@pulumi.input_type
class RouteEntryArgs:
    def __init__(__self__, *,
                 destination_cidr_block: pulumi.Input[str],
                 next_hop_id: pulumi.Input[str],
                 next_hop_type: pulumi.Input[str],
                 route_table_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 route_entry_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RouteEntry resource.
        :param pulumi.Input[str] destination_cidr_block: The destination CIDR block of the route entry.
        :param pulumi.Input[str] next_hop_id: The id of the next hop.
        :param pulumi.Input[str] next_hop_type: The type of the next hop, Optional choice contains `Instance`, `NetworkInterface`, `NatGW`, `VpnGW`, `TransitRouter`.
        :param pulumi.Input[str] route_table_id: The id of the route table.
        :param pulumi.Input[str] description: The description of the route entry.
        :param pulumi.Input[str] route_entry_name: The name of the route entry.
        """
        pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        pulumi.set(__self__, "next_hop_id", next_hop_id)
        pulumi.set(__self__, "next_hop_type", next_hop_type)
        pulumi.set(__self__, "route_table_id", route_table_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if route_entry_name is not None:
            pulumi.set(__self__, "route_entry_name", route_entry_name)

    @property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> pulumi.Input[str]:
        """
        The destination CIDR block of the route entry.
        """
        return pulumi.get(self, "destination_cidr_block")

    @destination_cidr_block.setter
    def destination_cidr_block(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_cidr_block", value)

    @property
    @pulumi.getter(name="nextHopId")
    def next_hop_id(self) -> pulumi.Input[str]:
        """
        The id of the next hop.
        """
        return pulumi.get(self, "next_hop_id")

    @next_hop_id.setter
    def next_hop_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "next_hop_id", value)

    @property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> pulumi.Input[str]:
        """
        The type of the next hop, Optional choice contains `Instance`, `NetworkInterface`, `NatGW`, `VpnGW`, `TransitRouter`.
        """
        return pulumi.get(self, "next_hop_type")

    @next_hop_type.setter
    def next_hop_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "next_hop_type", value)

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Input[str]:
        """
        The id of the route table.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "route_table_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the route entry.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="routeEntryName")
    def route_entry_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the route entry.
        """
        return pulumi.get(self, "route_entry_name")

    @route_entry_name.setter
    def route_entry_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route_entry_name", value)


@pulumi.input_type
class _RouteEntryState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_cidr_block: Optional[pulumi.Input[str]] = None,
                 next_hop_id: Optional[pulumi.Input[str]] = None,
                 next_hop_type: Optional[pulumi.Input[str]] = None,
                 route_entry_id: Optional[pulumi.Input[str]] = None,
                 route_entry_name: Optional[pulumi.Input[str]] = None,
                 route_table_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RouteEntry resources.
        :param pulumi.Input[str] description: The description of the route entry.
        :param pulumi.Input[str] destination_cidr_block: The destination CIDR block of the route entry.
        :param pulumi.Input[str] next_hop_id: The id of the next hop.
        :param pulumi.Input[str] next_hop_type: The type of the next hop, Optional choice contains `Instance`, `NetworkInterface`, `NatGW`, `VpnGW`, `TransitRouter`.
        :param pulumi.Input[str] route_entry_id: The id of the route entry.
        :param pulumi.Input[str] route_entry_name: The name of the route entry.
        :param pulumi.Input[str] route_table_id: The id of the route table.
        :param pulumi.Input[str] status: The description of the route entry.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_cidr_block is not None:
            pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        if next_hop_id is not None:
            pulumi.set(__self__, "next_hop_id", next_hop_id)
        if next_hop_type is not None:
            pulumi.set(__self__, "next_hop_type", next_hop_type)
        if route_entry_id is not None:
            pulumi.set(__self__, "route_entry_id", route_entry_id)
        if route_entry_name is not None:
            pulumi.set(__self__, "route_entry_name", route_entry_name)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the route entry.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The destination CIDR block of the route entry.
        """
        return pulumi.get(self, "destination_cidr_block")

    @destination_cidr_block.setter
    def destination_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_cidr_block", value)

    @property
    @pulumi.getter(name="nextHopId")
    def next_hop_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the next hop.
        """
        return pulumi.get(self, "next_hop_id")

    @next_hop_id.setter
    def next_hop_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_id", value)

    @property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the next hop, Optional choice contains `Instance`, `NetworkInterface`, `NatGW`, `VpnGW`, `TransitRouter`.
        """
        return pulumi.get(self, "next_hop_type")

    @next_hop_type.setter
    def next_hop_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_type", value)

    @property
    @pulumi.getter(name="routeEntryId")
    def route_entry_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the route entry.
        """
        return pulumi.get(self, "route_entry_id")

    @route_entry_id.setter
    def route_entry_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route_entry_id", value)

    @property
    @pulumi.getter(name="routeEntryName")
    def route_entry_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the route entry.
        """
        return pulumi.get(self, "route_entry_name")

    @route_entry_name.setter
    def route_entry_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route_entry_name", value)

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the route table.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route_table_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the route entry.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class RouteEntry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_cidr_block: Optional[pulumi.Input[str]] = None,
                 next_hop_id: Optional[pulumi.Input[str]] = None,
                 next_hop_type: Optional[pulumi.Input[str]] = None,
                 route_entry_name: Optional[pulumi.Input[str]] = None,
                 route_table_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage route entry
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.vpc.RouteEntry("foo",
            description="tf-test-up",
            destination_cidr_block="0.0.0.0/2",
            next_hop_id="ngw-274gwbqe340zk7fap8spkzo7x",
            next_hop_type="NatGW",
            route_entry_name="tf-test-up",
            route_table_id="vtb-2744hslq5b7r47fap8tjomgnj")
        ```

        ## Import

        Route entry can be imported using the route_table_id:route_entry_id, e.g.

        ```sh
         $ pulumi import volcengine:vpc/routeEntry:RouteEntry default vtb-274e19skkuhog7fap8u4i8ird:rte-274e1g9ei4k5c7fap8sp974fq
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the route entry.
        :param pulumi.Input[str] destination_cidr_block: The destination CIDR block of the route entry.
        :param pulumi.Input[str] next_hop_id: The id of the next hop.
        :param pulumi.Input[str] next_hop_type: The type of the next hop, Optional choice contains `Instance`, `NetworkInterface`, `NatGW`, `VpnGW`, `TransitRouter`.
        :param pulumi.Input[str] route_entry_name: The name of the route entry.
        :param pulumi.Input[str] route_table_id: The id of the route table.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteEntryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage route entry
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.vpc.RouteEntry("foo",
            description="tf-test-up",
            destination_cidr_block="0.0.0.0/2",
            next_hop_id="ngw-274gwbqe340zk7fap8spkzo7x",
            next_hop_type="NatGW",
            route_entry_name="tf-test-up",
            route_table_id="vtb-2744hslq5b7r47fap8tjomgnj")
        ```

        ## Import

        Route entry can be imported using the route_table_id:route_entry_id, e.g.

        ```sh
         $ pulumi import volcengine:vpc/routeEntry:RouteEntry default vtb-274e19skkuhog7fap8u4i8ird:rte-274e1g9ei4k5c7fap8sp974fq
        ```

        :param str resource_name: The name of the resource.
        :param RouteEntryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteEntryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_cidr_block: Optional[pulumi.Input[str]] = None,
                 next_hop_id: Optional[pulumi.Input[str]] = None,
                 next_hop_type: Optional[pulumi.Input[str]] = None,
                 route_entry_name: Optional[pulumi.Input[str]] = None,
                 route_table_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteEntryArgs.__new__(RouteEntryArgs)

            __props__.__dict__["description"] = description
            if destination_cidr_block is None and not opts.urn:
                raise TypeError("Missing required property 'destination_cidr_block'")
            __props__.__dict__["destination_cidr_block"] = destination_cidr_block
            if next_hop_id is None and not opts.urn:
                raise TypeError("Missing required property 'next_hop_id'")
            __props__.__dict__["next_hop_id"] = next_hop_id
            if next_hop_type is None and not opts.urn:
                raise TypeError("Missing required property 'next_hop_type'")
            __props__.__dict__["next_hop_type"] = next_hop_type
            __props__.__dict__["route_entry_name"] = route_entry_name
            if route_table_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_table_id'")
            __props__.__dict__["route_table_id"] = route_table_id
            __props__.__dict__["route_entry_id"] = None
            __props__.__dict__["status"] = None
        super(RouteEntry, __self__).__init__(
            'volcengine:vpc/routeEntry:RouteEntry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            destination_cidr_block: Optional[pulumi.Input[str]] = None,
            next_hop_id: Optional[pulumi.Input[str]] = None,
            next_hop_type: Optional[pulumi.Input[str]] = None,
            route_entry_id: Optional[pulumi.Input[str]] = None,
            route_entry_name: Optional[pulumi.Input[str]] = None,
            route_table_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'RouteEntry':
        """
        Get an existing RouteEntry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the route entry.
        :param pulumi.Input[str] destination_cidr_block: The destination CIDR block of the route entry.
        :param pulumi.Input[str] next_hop_id: The id of the next hop.
        :param pulumi.Input[str] next_hop_type: The type of the next hop, Optional choice contains `Instance`, `NetworkInterface`, `NatGW`, `VpnGW`, `TransitRouter`.
        :param pulumi.Input[str] route_entry_id: The id of the route entry.
        :param pulumi.Input[str] route_entry_name: The name of the route entry.
        :param pulumi.Input[str] route_table_id: The id of the route table.
        :param pulumi.Input[str] status: The description of the route entry.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteEntryState.__new__(_RouteEntryState)

        __props__.__dict__["description"] = description
        __props__.__dict__["destination_cidr_block"] = destination_cidr_block
        __props__.__dict__["next_hop_id"] = next_hop_id
        __props__.__dict__["next_hop_type"] = next_hop_type
        __props__.__dict__["route_entry_id"] = route_entry_id
        __props__.__dict__["route_entry_name"] = route_entry_name
        __props__.__dict__["route_table_id"] = route_table_id
        __props__.__dict__["status"] = status
        return RouteEntry(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the route entry.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> pulumi.Output[str]:
        """
        The destination CIDR block of the route entry.
        """
        return pulumi.get(self, "destination_cidr_block")

    @property
    @pulumi.getter(name="nextHopId")
    def next_hop_id(self) -> pulumi.Output[str]:
        """
        The id of the next hop.
        """
        return pulumi.get(self, "next_hop_id")

    @property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> pulumi.Output[str]:
        """
        The type of the next hop, Optional choice contains `Instance`, `NetworkInterface`, `NatGW`, `VpnGW`, `TransitRouter`.
        """
        return pulumi.get(self, "next_hop_type")

    @property
    @pulumi.getter(name="routeEntryId")
    def route_entry_id(self) -> pulumi.Output[str]:
        """
        The id of the route entry.
        """
        return pulumi.get(self, "route_entry_id")

    @property
    @pulumi.getter(name="routeEntryName")
    def route_entry_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the route entry.
        """
        return pulumi.get(self, "route_entry_name")

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Output[str]:
        """
        The id of the route table.
        """
        return pulumi.get(self, "route_table_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The description of the route entry.
        """
        return pulumi.get(self, "status")

