# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'RouteTablesResult',
    'AwaitableRouteTablesResult',
    'route_tables',
    'route_tables_output',
]

@pulumi.output_type
class RouteTablesResult:
    """
    A collection of values returned by RouteTables.
    """
    def __init__(__self__, id=None, ids=None, output_file=None, project_name=None, route_table_name=None, route_tables=None, total_count=None, vpc_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)
        if route_table_name and not isinstance(route_table_name, str):
            raise TypeError("Expected argument 'route_table_name' to be a str")
        pulumi.set(__self__, "route_table_name", route_table_name)
        if route_tables and not isinstance(route_tables, list):
            raise TypeError("Expected argument 'route_tables' to be a list")
        pulumi.set(__self__, "route_tables", route_tables)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[str]:
        """
        The ProjectName of the route table.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="routeTableName")
    def route_table_name(self) -> Optional[str]:
        """
        The name of the route table.
        """
        return pulumi.get(self, "route_table_name")

    @property
    @pulumi.getter(name="routeTables")
    def route_tables(self) -> Sequence['outputs.RouteTablesRouteTableResult']:
        """
        The collection of route tables.
        """
        return pulumi.get(self, "route_tables")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of route table query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        The id of the virtual private cloud (VPC) to which the route entry belongs.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableRouteTablesResult(RouteTablesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return RouteTablesResult(
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            project_name=self.project_name,
            route_table_name=self.route_table_name,
            route_tables=self.route_tables,
            total_count=self.total_count,
            vpc_id=self.vpc_id)


def route_tables(ids: Optional[Sequence[str]] = None,
                 output_file: Optional[str] = None,
                 project_name: Optional[str] = None,
                 route_table_name: Optional[str] = None,
                 vpc_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableRouteTablesResult:
    """
    Use this data source to query detailed information of route tables
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.vpc.route_tables(ids=[
            "vtb-274e19skkuhog7fap8u4i8ird",
            "vtb-2744hslq5b7r47fap8tjomgnj",
        ],
        route_table_name="vpc-fast")
    ```


    :param Sequence[str] ids: A list of route table ids.
    :param str output_file: File name where to save data source results.
    :param str project_name: The ProjectName of the route table.
    :param str route_table_name: A name of route table.
    :param str vpc_id: An id of VPC.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['projectName'] = project_name
    __args__['routeTableName'] = route_table_name
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:vpc/routeTables:RouteTables', __args__, opts=opts, typ=RouteTablesResult).value

    return AwaitableRouteTablesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        project_name=pulumi.get(__ret__, 'project_name'),
        route_table_name=pulumi.get(__ret__, 'route_table_name'),
        route_tables=pulumi.get(__ret__, 'route_tables'),
        total_count=pulumi.get(__ret__, 'total_count'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))


@_utilities.lift_output_func(route_tables)
def route_tables_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                        output_file: Optional[pulumi.Input[Optional[str]]] = None,
                        project_name: Optional[pulumi.Input[Optional[str]]] = None,
                        route_table_name: Optional[pulumi.Input[Optional[str]]] = None,
                        vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[RouteTablesResult]:
    """
    Use this data source to query detailed information of route tables
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.vpc.route_tables(ids=[
            "vtb-274e19skkuhog7fap8u4i8ird",
            "vtb-2744hslq5b7r47fap8tjomgnj",
        ],
        route_table_name="vpc-fast")
    ```


    :param Sequence[str] ids: A list of route table ids.
    :param str output_file: File name where to save data source results.
    :param str project_name: The ProjectName of the route table.
    :param str route_table_name: A name of route table.
    :param str vpc_id: An id of VPC.
    """
    ...
