# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SecurityGroupRuleArgs', 'SecurityGroupRule']

@pulumi.input_type
class SecurityGroupRuleArgs:
    def __init__(__self__, *,
                 direction: pulumi.Input[str],
                 port_end: pulumi.Input[int],
                 port_start: pulumi.Input[int],
                 protocol: pulumi.Input[str],
                 security_group_id: pulumi.Input[str],
                 cidr_ip: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 source_group_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SecurityGroupRule resource.
        :param pulumi.Input[str] direction: Direction of rule, ingress (inbound) or egress (outbound).
        :param pulumi.Input[int] port_end: Port end of egress/ingress Rule.
        :param pulumi.Input[int] port_start: Port start of egress/ingress Rule.
        :param pulumi.Input[str] protocol: Protocol of the SecurityGroup, the value can be `tcp` or `udp` or `icmp` or `all` or `icmpv6`.
        :param pulumi.Input[str] security_group_id: Id of SecurityGroup.
        :param pulumi.Input[str] cidr_ip: Cidr ip of egress/ingress Rule.
        :param pulumi.Input[str] description: description of a egress rule.
        :param pulumi.Input[str] policy: Access strategy.
        :param pulumi.Input[int] priority: Priority of a security group rule.
        :param pulumi.Input[str] source_group_id: ID of the source security group whose access permission you want to set.
        """
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "port_end", port_end)
        pulumi.set(__self__, "port_start", port_start)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "security_group_id", security_group_id)
        if cidr_ip is not None:
            pulumi.set(__self__, "cidr_ip", cidr_ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source_group_id is not None:
            pulumi.set(__self__, "source_group_id", source_group_id)

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Input[str]:
        """
        Direction of rule, ingress (inbound) or egress (outbound).
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[str]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter(name="portEnd")
    def port_end(self) -> pulumi.Input[int]:
        """
        Port end of egress/ingress Rule.
        """
        return pulumi.get(self, "port_end")

    @port_end.setter
    def port_end(self, value: pulumi.Input[int]):
        pulumi.set(self, "port_end", value)

    @property
    @pulumi.getter(name="portStart")
    def port_start(self) -> pulumi.Input[int]:
        """
        Port start of egress/ingress Rule.
        """
        return pulumi.get(self, "port_start")

    @port_start.setter
    def port_start(self, value: pulumi.Input[int]):
        pulumi.set(self, "port_start", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        Protocol of the SecurityGroup, the value can be `tcp` or `udp` or `icmp` or `all` or `icmpv6`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[str]:
        """
        Id of SecurityGroup.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="cidrIp")
    def cidr_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Cidr ip of egress/ingress Rule.
        """
        return pulumi.get(self, "cidr_ip")

    @cidr_ip.setter
    def cidr_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr_ip", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        description of a egress rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        Access strategy.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority of a security group rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="sourceGroupId")
    def source_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the source security group whose access permission you want to set.
        """
        return pulumi.get(self, "source_group_id")

    @source_group_id.setter
    def source_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_group_id", value)


@pulumi.input_type
class _SecurityGroupRuleState:
    def __init__(__self__, *,
                 cidr_ip: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 port_end: Optional[pulumi.Input[int]] = None,
                 port_start: Optional[pulumi.Input[int]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 source_group_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SecurityGroupRule resources.
        :param pulumi.Input[str] cidr_ip: Cidr ip of egress/ingress Rule.
        :param pulumi.Input[str] description: description of a egress rule.
        :param pulumi.Input[str] direction: Direction of rule, ingress (inbound) or egress (outbound).
        :param pulumi.Input[str] policy: Access strategy.
        :param pulumi.Input[int] port_end: Port end of egress/ingress Rule.
        :param pulumi.Input[int] port_start: Port start of egress/ingress Rule.
        :param pulumi.Input[int] priority: Priority of a security group rule.
        :param pulumi.Input[str] protocol: Protocol of the SecurityGroup, the value can be `tcp` or `udp` or `icmp` or `all` or `icmpv6`.
        :param pulumi.Input[str] security_group_id: Id of SecurityGroup.
        :param pulumi.Input[str] source_group_id: ID of the source security group whose access permission you want to set.
        :param pulumi.Input[str] status: Status of SecurityGroup.
        """
        if cidr_ip is not None:
            pulumi.set(__self__, "cidr_ip", cidr_ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if port_end is not None:
            pulumi.set(__self__, "port_end", port_end)
        if port_start is not None:
            pulumi.set(__self__, "port_start", port_start)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if source_group_id is not None:
            pulumi.set(__self__, "source_group_id", source_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="cidrIp")
    def cidr_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Cidr ip of egress/ingress Rule.
        """
        return pulumi.get(self, "cidr_ip")

    @cidr_ip.setter
    def cidr_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr_ip", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        description of a egress rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[str]]:
        """
        Direction of rule, ingress (inbound) or egress (outbound).
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        Access strategy.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="portEnd")
    def port_end(self) -> Optional[pulumi.Input[int]]:
        """
        Port end of egress/ingress Rule.
        """
        return pulumi.get(self, "port_end")

    @port_end.setter
    def port_end(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port_end", value)

    @property
    @pulumi.getter(name="portStart")
    def port_start(self) -> Optional[pulumi.Input[int]]:
        """
        Port start of egress/ingress Rule.
        """
        return pulumi.get(self, "port_start")

    @port_start.setter
    def port_start(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port_start", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority of a security group rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol of the SecurityGroup, the value can be `tcp` or `udp` or `icmp` or `all` or `icmpv6`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of SecurityGroup.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="sourceGroupId")
    def source_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the source security group whose access permission you want to set.
        """
        return pulumi.get(self, "source_group_id")

    @source_group_id.setter
    def source_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_group_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of SecurityGroup.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class SecurityGroupRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr_ip: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 port_end: Optional[pulumi.Input[int]] = None,
                 port_start: Optional[pulumi.Input[int]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 source_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage security group rule
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        g1test3 = volcengine.vpc.SecurityGroupRule("g1test3",
            cidr_ip="10.0.0.0/8",
            description="tft1234",
            direction="egress",
            port_end=9003,
            port_start=8000,
            protocol="tcp",
            security_group_id="sg-2d6722jpp55og58ozfd1sqtdb")
        g1test2 = volcengine.vpc.SecurityGroupRule("g1test2",
            cidr_ip="10.0.0.0/24",
            direction="egress",
            port_end=9003,
            port_start=8000,
            protocol="tcp",
            security_group_id="sg-2d6722jpp55og58ozfd1sqtdb")
        g1test1 = volcengine.vpc.SecurityGroupRule("g1test1",
            cidr_ip="10.0.0.0/24",
            direction="egress",
            port_end=9003,
            port_start=8000,
            priority=2,
            protocol="tcp",
            security_group_id="sg-2d6722jpp55og58ozfd1sqtdb")
        g1test0 = volcengine.vpc.SecurityGroupRule("g1test0",
            cidr_ip="10.0.0.0/24",
            description="tft",
            direction="ingress",
            policy="drop",
            port_end=80,
            port_start=80,
            priority=2,
            protocol="tcp",
            security_group_id="sg-2d6722jpp55og58ozfd1sqtdb")
        g1test06 = volcengine.vpc.SecurityGroupRule("g1test06",
            description="tft",
            direction="ingress",
            policy="drop",
            port_end=9003,
            port_start=8000,
            priority=2,
            protocol="tcp",
            security_group_id="sg-2d6722jpp55og58ozfd1sqtdb",
            source_group_id="sg-3rfe5j4xdnklc5zsk2hcw5c6q")
        ```

        ## Import

        SecurityGroupRule can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpc/securityGroupRule:SecurityGroupRule default ID is a string concatenated with colons(SecurityGroupId:Protocol:PortStart:PortEnd:CidrIp:SourceGroupId:Direction:Policy:Priority)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cidr_ip: Cidr ip of egress/ingress Rule.
        :param pulumi.Input[str] description: description of a egress rule.
        :param pulumi.Input[str] direction: Direction of rule, ingress (inbound) or egress (outbound).
        :param pulumi.Input[str] policy: Access strategy.
        :param pulumi.Input[int] port_end: Port end of egress/ingress Rule.
        :param pulumi.Input[int] port_start: Port start of egress/ingress Rule.
        :param pulumi.Input[int] priority: Priority of a security group rule.
        :param pulumi.Input[str] protocol: Protocol of the SecurityGroup, the value can be `tcp` or `udp` or `icmp` or `all` or `icmpv6`.
        :param pulumi.Input[str] security_group_id: Id of SecurityGroup.
        :param pulumi.Input[str] source_group_id: ID of the source security group whose access permission you want to set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityGroupRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage security group rule
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        g1test3 = volcengine.vpc.SecurityGroupRule("g1test3",
            cidr_ip="10.0.0.0/8",
            description="tft1234",
            direction="egress",
            port_end=9003,
            port_start=8000,
            protocol="tcp",
            security_group_id="sg-2d6722jpp55og58ozfd1sqtdb")
        g1test2 = volcengine.vpc.SecurityGroupRule("g1test2",
            cidr_ip="10.0.0.0/24",
            direction="egress",
            port_end=9003,
            port_start=8000,
            protocol="tcp",
            security_group_id="sg-2d6722jpp55og58ozfd1sqtdb")
        g1test1 = volcengine.vpc.SecurityGroupRule("g1test1",
            cidr_ip="10.0.0.0/24",
            direction="egress",
            port_end=9003,
            port_start=8000,
            priority=2,
            protocol="tcp",
            security_group_id="sg-2d6722jpp55og58ozfd1sqtdb")
        g1test0 = volcengine.vpc.SecurityGroupRule("g1test0",
            cidr_ip="10.0.0.0/24",
            description="tft",
            direction="ingress",
            policy="drop",
            port_end=80,
            port_start=80,
            priority=2,
            protocol="tcp",
            security_group_id="sg-2d6722jpp55og58ozfd1sqtdb")
        g1test06 = volcengine.vpc.SecurityGroupRule("g1test06",
            description="tft",
            direction="ingress",
            policy="drop",
            port_end=9003,
            port_start=8000,
            priority=2,
            protocol="tcp",
            security_group_id="sg-2d6722jpp55og58ozfd1sqtdb",
            source_group_id="sg-3rfe5j4xdnklc5zsk2hcw5c6q")
        ```

        ## Import

        SecurityGroupRule can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpc/securityGroupRule:SecurityGroupRule default ID is a string concatenated with colons(SecurityGroupId:Protocol:PortStart:PortEnd:CidrIp:SourceGroupId:Direction:Policy:Priority)
        ```

        :param str resource_name: The name of the resource.
        :param SecurityGroupRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityGroupRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr_ip: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 port_end: Optional[pulumi.Input[int]] = None,
                 port_start: Optional[pulumi.Input[int]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 source_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityGroupRuleArgs.__new__(SecurityGroupRuleArgs)

            __props__.__dict__["cidr_ip"] = cidr_ip
            __props__.__dict__["description"] = description
            if direction is None and not opts.urn:
                raise TypeError("Missing required property 'direction'")
            __props__.__dict__["direction"] = direction
            __props__.__dict__["policy"] = policy
            if port_end is None and not opts.urn:
                raise TypeError("Missing required property 'port_end'")
            __props__.__dict__["port_end"] = port_end
            if port_start is None and not opts.urn:
                raise TypeError("Missing required property 'port_start'")
            __props__.__dict__["port_start"] = port_start
            __props__.__dict__["priority"] = priority
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["source_group_id"] = source_group_id
            __props__.__dict__["status"] = None
        super(SecurityGroupRule, __self__).__init__(
            'volcengine:vpc/securityGroupRule:SecurityGroupRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cidr_ip: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            direction: Optional[pulumi.Input[str]] = None,
            policy: Optional[pulumi.Input[str]] = None,
            port_end: Optional[pulumi.Input[int]] = None,
            port_start: Optional[pulumi.Input[int]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            source_group_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'SecurityGroupRule':
        """
        Get an existing SecurityGroupRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cidr_ip: Cidr ip of egress/ingress Rule.
        :param pulumi.Input[str] description: description of a egress rule.
        :param pulumi.Input[str] direction: Direction of rule, ingress (inbound) or egress (outbound).
        :param pulumi.Input[str] policy: Access strategy.
        :param pulumi.Input[int] port_end: Port end of egress/ingress Rule.
        :param pulumi.Input[int] port_start: Port start of egress/ingress Rule.
        :param pulumi.Input[int] priority: Priority of a security group rule.
        :param pulumi.Input[str] protocol: Protocol of the SecurityGroup, the value can be `tcp` or `udp` or `icmp` or `all` or `icmpv6`.
        :param pulumi.Input[str] security_group_id: Id of SecurityGroup.
        :param pulumi.Input[str] source_group_id: ID of the source security group whose access permission you want to set.
        :param pulumi.Input[str] status: Status of SecurityGroup.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityGroupRuleState.__new__(_SecurityGroupRuleState)

        __props__.__dict__["cidr_ip"] = cidr_ip
        __props__.__dict__["description"] = description
        __props__.__dict__["direction"] = direction
        __props__.__dict__["policy"] = policy
        __props__.__dict__["port_end"] = port_end
        __props__.__dict__["port_start"] = port_start
        __props__.__dict__["priority"] = priority
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["source_group_id"] = source_group_id
        __props__.__dict__["status"] = status
        return SecurityGroupRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cidrIp")
    def cidr_ip(self) -> pulumi.Output[Optional[str]]:
        """
        Cidr ip of egress/ingress Rule.
        """
        return pulumi.get(self, "cidr_ip")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        description of a egress rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Output[str]:
        """
        Direction of rule, ingress (inbound) or egress (outbound).
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Output[Optional[str]]:
        """
        Access strategy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="portEnd")
    def port_end(self) -> pulumi.Output[int]:
        """
        Port end of egress/ingress Rule.
        """
        return pulumi.get(self, "port_end")

    @property
    @pulumi.getter(name="portStart")
    def port_start(self) -> pulumi.Output[int]:
        """
        Port start of egress/ingress Rule.
        """
        return pulumi.get(self, "port_start")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[int]]:
        """
        Priority of a security group rule.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        Protocol of the SecurityGroup, the value can be `tcp` or `udp` or `icmp` or `all` or `icmpv6`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        Id of SecurityGroup.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="sourceGroupId")
    def source_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        ID of the source security group whose access permission you want to set.
        """
        return pulumi.get(self, "source_group_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of SecurityGroup.
        """
        return pulumi.get(self, "status")

