# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'SecurityGroupRulesResult',
    'AwaitableSecurityGroupRulesResult',
    'security_group_rules',
    'security_group_rules_output',
]

@pulumi.output_type
class SecurityGroupRulesResult:
    """
    A collection of values returned by SecurityGroupRules.
    """
    def __init__(__self__, cidr_ip=None, direction=None, id=None, output_file=None, protocol=None, security_group_id=None, security_group_rules=None, source_group_id=None):
        if cidr_ip and not isinstance(cidr_ip, str):
            raise TypeError("Expected argument 'cidr_ip' to be a str")
        pulumi.set(__self__, "cidr_ip", cidr_ip)
        if direction and not isinstance(direction, str):
            raise TypeError("Expected argument 'direction' to be a str")
        pulumi.set(__self__, "direction", direction)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if security_group_id and not isinstance(security_group_id, str):
            raise TypeError("Expected argument 'security_group_id' to be a str")
        pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_rules and not isinstance(security_group_rules, list):
            raise TypeError("Expected argument 'security_group_rules' to be a list")
        pulumi.set(__self__, "security_group_rules", security_group_rules)
        if source_group_id and not isinstance(source_group_id, str):
            raise TypeError("Expected argument 'source_group_id' to be a str")
        pulumi.set(__self__, "source_group_id", source_group_id)

    @property
    @pulumi.getter(name="cidrIp")
    def cidr_ip(self) -> Optional[str]:
        """
        Cidr ip of egress/ingress Rule.
        """
        return pulumi.get(self, "cidr_ip")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        Direction of rule, ingress (inbound) or egress (outbound).
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Protocol of the SecurityGroup, the value can be `tcp` or `udp` or `icmp` or `all`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        Id of SecurityGroup.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="securityGroupRules")
    def security_group_rules(self) -> Sequence['outputs.SecurityGroupRulesSecurityGroupRuleResult']:
        """
        The collection of SecurityGroup query.
        """
        return pulumi.get(self, "security_group_rules")

    @property
    @pulumi.getter(name="sourceGroupId")
    def source_group_id(self) -> Optional[str]:
        """
        ID of the source security group whose access permission you want to set.
        """
        return pulumi.get(self, "source_group_id")


class AwaitableSecurityGroupRulesResult(SecurityGroupRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return SecurityGroupRulesResult(
            cidr_ip=self.cidr_ip,
            direction=self.direction,
            id=self.id,
            output_file=self.output_file,
            protocol=self.protocol,
            security_group_id=self.security_group_id,
            security_group_rules=self.security_group_rules,
            source_group_id=self.source_group_id)


def security_group_rules(cidr_ip: Optional[str] = None,
                         direction: Optional[str] = None,
                         output_file: Optional[str] = None,
                         protocol: Optional[str] = None,
                         security_group_id: Optional[str] = None,
                         source_group_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableSecurityGroupRulesResult:
    """
    Use this data source to query detailed information of security group rules
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.vpc.security_group_rules(security_group_id="sg-13f2nau7x93wg3n6nu3z5sxib")
    ```


    :param str cidr_ip: Cidr ip of egress/ingress Rule.
    :param str direction: Direction of rule, ingress (inbound) or egress (outbound).
    :param str output_file: File name where to save data source results.
    :param str protocol: Protocol of the SecurityGroup, the value can be `tcp` or `udp` or `icmp` or `all`.
    :param str security_group_id: SecurityGroup ID.
    :param str source_group_id: ID of the source security group whose access permission you want to set.
    """
    __args__ = dict()
    __args__['cidrIp'] = cidr_ip
    __args__['direction'] = direction
    __args__['outputFile'] = output_file
    __args__['protocol'] = protocol
    __args__['securityGroupId'] = security_group_id
    __args__['sourceGroupId'] = source_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:vpc/securityGroupRules:SecurityGroupRules', __args__, opts=opts, typ=SecurityGroupRulesResult).value

    return AwaitableSecurityGroupRulesResult(
        cidr_ip=pulumi.get(__ret__, 'cidr_ip'),
        direction=pulumi.get(__ret__, 'direction'),
        id=pulumi.get(__ret__, 'id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        protocol=pulumi.get(__ret__, 'protocol'),
        security_group_id=pulumi.get(__ret__, 'security_group_id'),
        security_group_rules=pulumi.get(__ret__, 'security_group_rules'),
        source_group_id=pulumi.get(__ret__, 'source_group_id'))


@_utilities.lift_output_func(security_group_rules)
def security_group_rules_output(cidr_ip: Optional[pulumi.Input[Optional[str]]] = None,
                                direction: Optional[pulumi.Input[Optional[str]]] = None,
                                output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                protocol: Optional[pulumi.Input[Optional[str]]] = None,
                                security_group_id: Optional[pulumi.Input[str]] = None,
                                source_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[SecurityGroupRulesResult]:
    """
    Use this data source to query detailed information of security group rules
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.vpc.security_group_rules(security_group_id="sg-13f2nau7x93wg3n6nu3z5sxib")
    ```


    :param str cidr_ip: Cidr ip of egress/ingress Rule.
    :param str direction: Direction of rule, ingress (inbound) or egress (outbound).
    :param str output_file: File name where to save data source results.
    :param str protocol: Protocol of the SecurityGroup, the value can be `tcp` or `udp` or `icmp` or `all`.
    :param str security_group_id: SecurityGroup ID.
    :param str source_group_id: ID of the source security group whose access permission you want to set.
    """
    ...
