# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'SecurityGroupsResult',
    'AwaitableSecurityGroupsResult',
    'security_groups',
    'security_groups_output',
]

@pulumi.output_type
class SecurityGroupsResult:
    """
    A collection of values returned by SecurityGroups.
    """
    def __init__(__self__, id=None, ids=None, name_regex=None, output_file=None, project_name=None, security_group_names=None, security_groups=None, tags=None, total_count=None, vpc_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)
        if security_group_names and not isinstance(security_group_names, list):
            raise TypeError("Expected argument 'security_group_names' to be a list")
        pulumi.set(__self__, "security_group_names", security_group_names)
        if security_groups and not isinstance(security_groups, list):
            raise TypeError("Expected argument 'security_groups' to be a list")
        pulumi.set(__self__, "security_groups", security_groups)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[str]:
        """
        The ProjectName of SecurityGroup.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="securityGroupNames")
    def security_group_names(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "security_group_names")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Sequence['outputs.SecurityGroupsSecurityGroupResult']:
        """
        The collection of SecurityGroup query.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.SecurityGroupsTagResult']]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of SecurityGroup query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        The ID of Vpc.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableSecurityGroupsResult(SecurityGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return SecurityGroupsResult(
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            output_file=self.output_file,
            project_name=self.project_name,
            security_group_names=self.security_group_names,
            security_groups=self.security_groups,
            tags=self.tags,
            total_count=self.total_count,
            vpc_id=self.vpc_id)


def security_groups(ids: Optional[Sequence[str]] = None,
                    name_regex: Optional[str] = None,
                    output_file: Optional[str] = None,
                    project_name: Optional[str] = None,
                    security_group_names: Optional[Sequence[str]] = None,
                    tags: Optional[Sequence[pulumi.InputType['SecurityGroupsTagArgs']]] = None,
                    vpc_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableSecurityGroupsResult:
    """
    Use this data source to query detailed information of security groups
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.vpc.security_groups(ids=["sg-273ycgql3ig3k7fap8t3dyvqx"])
    ```


    :param Sequence[str] ids: A list of SecurityGroup IDs.
    :param str name_regex: A Name Regex of SecurityGroup.
    :param str output_file: File name where to save data source results.
    :param str project_name: The ProjectName of SecurityGroup.
    :param Sequence[str] security_group_names: The list of security group name to query.
    :param Sequence[pulumi.InputType['SecurityGroupsTagArgs']] tags: Tags.
    :param str vpc_id: The ID of vpc where security group is located.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['projectName'] = project_name
    __args__['securityGroupNames'] = security_group_names
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:vpc/securityGroups:SecurityGroups', __args__, opts=opts, typ=SecurityGroupsResult).value

    return AwaitableSecurityGroupsResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        project_name=pulumi.get(__ret__, 'project_name'),
        security_group_names=pulumi.get(__ret__, 'security_group_names'),
        security_groups=pulumi.get(__ret__, 'security_groups'),
        tags=pulumi.get(__ret__, 'tags'),
        total_count=pulumi.get(__ret__, 'total_count'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))


@_utilities.lift_output_func(security_groups)
def security_groups_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                           name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                           output_file: Optional[pulumi.Input[Optional[str]]] = None,
                           project_name: Optional[pulumi.Input[Optional[str]]] = None,
                           security_group_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                           tags: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['SecurityGroupsTagArgs']]]]] = None,
                           vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[SecurityGroupsResult]:
    """
    Use this data source to query detailed information of security groups
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.vpc.security_groups(ids=["sg-273ycgql3ig3k7fap8t3dyvqx"])
    ```


    :param Sequence[str] ids: A list of SecurityGroup IDs.
    :param str name_regex: A Name Regex of SecurityGroup.
    :param str output_file: File name where to save data source results.
    :param str project_name: The ProjectName of SecurityGroup.
    :param Sequence[str] security_group_names: The list of security group name to query.
    :param Sequence[pulumi.InputType['SecurityGroupsTagArgs']] tags: Tags.
    :param str vpc_id: The ID of vpc where security group is located.
    """
    ...
