# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'SubnetsResult',
    'AwaitableSubnetsResult',
    'subnets',
    'subnets_output',
]

@pulumi.output_type
class SubnetsResult:
    """
    A collection of values returned by Subnets.
    """
    def __init__(__self__, id=None, ids=None, name_regex=None, output_file=None, route_table_id=None, subnet_name=None, subnets=None, total_count=None, vpc_id=None, zone_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if route_table_id and not isinstance(route_table_id, str):
            raise TypeError("Expected argument 'route_table_id' to be a str")
        pulumi.set(__self__, "route_table_id", route_table_id)
        if subnet_name and not isinstance(subnet_name, str):
            raise TypeError("Expected argument 'subnet_name' to be a str")
        pulumi.set(__self__, "subnet_name", subnet_name)
        if subnets and not isinstance(subnets, list):
            raise TypeError("Expected argument 'subnets' to be a list")
        pulumi.set(__self__, "subnets", subnets)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[str]:
        """
        The route table ID.
        """
        return pulumi.get(self, "route_table_id")

    @property
    @pulumi.getter(name="subnetName")
    def subnet_name(self) -> Optional[str]:
        """
        The Name of Subnet.
        """
        return pulumi.get(self, "subnet_name")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence['outputs.SubnetsSubnetResult']:
        """
        The collection of Subnet query.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of Subnet query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        The Vpc ID of Subnet.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[str]:
        """
        The ID of Zone.
        """
        return pulumi.get(self, "zone_id")


class AwaitableSubnetsResult(SubnetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return SubnetsResult(
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            output_file=self.output_file,
            route_table_id=self.route_table_id,
            subnet_name=self.subnet_name,
            subnets=self.subnets,
            total_count=self.total_count,
            vpc_id=self.vpc_id,
            zone_id=self.zone_id)


def subnets(ids: Optional[Sequence[str]] = None,
            name_regex: Optional[str] = None,
            output_file: Optional[str] = None,
            route_table_id: Optional[str] = None,
            subnet_name: Optional[str] = None,
            vpc_id: Optional[str] = None,
            zone_id: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableSubnetsResult:
    """
    Use this data source to query detailed information of subnets
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.vpc.subnets(ids=["subnet-274zsa5kfmj287fap8soo5e19"])
    ```


    :param Sequence[str] ids: A list of Subnet IDs.
    :param str name_regex: A Name Regex of Subnet.
    :param str output_file: File name where to save data source results.
    :param str route_table_id: The ID of route table which subnet associated with.
    :param str subnet_name: The subnet name to query.
    :param str vpc_id: The ID of VPC which subnet belongs to.
    :param str zone_id: The ID of zone which subnet belongs to.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['routeTableId'] = route_table_id
    __args__['subnetName'] = subnet_name
    __args__['vpcId'] = vpc_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:vpc/subnets:Subnets', __args__, opts=opts, typ=SubnetsResult).value

    return AwaitableSubnetsResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        route_table_id=pulumi.get(__ret__, 'route_table_id'),
        subnet_name=pulumi.get(__ret__, 'subnet_name'),
        subnets=pulumi.get(__ret__, 'subnets'),
        total_count=pulumi.get(__ret__, 'total_count'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'),
        zone_id=pulumi.get(__ret__, 'zone_id'))


@_utilities.lift_output_func(subnets)
def subnets_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                   name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                   output_file: Optional[pulumi.Input[Optional[str]]] = None,
                   route_table_id: Optional[pulumi.Input[Optional[str]]] = None,
                   subnet_name: Optional[pulumi.Input[Optional[str]]] = None,
                   vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                   zone_id: Optional[pulumi.Input[Optional[str]]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[SubnetsResult]:
    """
    Use this data source to query detailed information of subnets
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.vpc.subnets(ids=["subnet-274zsa5kfmj287fap8soo5e19"])
    ```


    :param Sequence[str] ids: A list of Subnet IDs.
    :param str name_regex: A Name Regex of Subnet.
    :param str output_file: File name where to save data source results.
    :param str route_table_id: The ID of route table which subnet associated with.
    :param str subnet_name: The subnet name to query.
    :param str vpc_id: The ID of VPC which subnet belongs to.
    :param str zone_id: The ID of zone which subnet belongs to.
    """
    ...
