# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpcArgs', 'Vpc']

@pulumi.input_type
class VpcArgs:
    def __init__(__self__, *,
                 cidr_block: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_ipv6: Optional[pulumi.Input[bool]] = None,
                 ipv6_cidr_block: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['VpcTagArgs']]]] = None,
                 vpc_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Vpc resource.
        :param pulumi.Input[str] cidr_block: A network address block which should be a subnet of the three internal network segments (10.0.0.0/16, 172.16.0.0/12 and 192.168.0.0/16).
        :param pulumi.Input[str] description: The description of the VPC.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: The DNS server list of the VPC. And you can specify 0 to 5 servers to this list.
        :param pulumi.Input[bool] enable_ipv6: Specifies whether to enable the IPv6 CIDR block of the VPC.
        :param pulumi.Input[str] ipv6_cidr_block: The IPv6 CIDR block of the VPC.
        :param pulumi.Input[str] project_name: The ProjectName of the VPC.
        :param pulumi.Input[Sequence[pulumi.Input['VpcTagArgs']]] tags: Tags.
        :param pulumi.Input[str] vpc_name: The name of the VPC.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if enable_ipv6 is not None:
            pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        if ipv6_cidr_block is not None:
            pulumi.set(__self__, "ipv6_cidr_block", ipv6_cidr_block)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_name is not None:
            pulumi.set(__self__, "vpc_name", vpc_name)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Input[str]:
        """
        A network address block which should be a subnet of the three internal network segments (10.0.0.0/16, 172.16.0.0/12 and 192.168.0.0/16).
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: pulumi.Input[str]):
        pulumi.set(self, "cidr_block", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the VPC.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The DNS server list of the VPC. And you can specify 0 to 5 servers to this list.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_servers", value)

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the IPv6 CIDR block of the VPC.
        """
        return pulumi.get(self, "enable_ipv6")

    @enable_ipv6.setter
    def enable_ipv6(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ipv6", value)

    @property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 CIDR block of the VPC.
        """
        return pulumi.get(self, "ipv6_cidr_block")

    @ipv6_cidr_block.setter
    def ipv6_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_cidr_block", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The ProjectName of the VPC.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcTagArgs']]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC.
        """
        return pulumi.get(self, "vpc_name")

    @vpc_name.setter
    def vpc_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_name", value)


@pulumi.input_type
class _VpcState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 associate_cens: Optional[pulumi.Input[Sequence[pulumi.Input['VpcAssociateCenArgs']]]] = None,
                 auxiliary_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cidr_block: Optional[pulumi.Input[str]] = None,
                 creation_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_ipv6: Optional[pulumi.Input[bool]] = None,
                 ipv6_cidr_block: Optional[pulumi.Input[str]] = None,
                 nat_gateway_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 route_table_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['VpcTagArgs']]]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpc_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Vpc resources.
        :param pulumi.Input[str] account_id: The account ID of VPC.
        :param pulumi.Input[Sequence[pulumi.Input['VpcAssociateCenArgs']]] associate_cens: The associate cen list of VPC.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] auxiliary_cidr_blocks: The auxiliary cidr block list of VPC.
        :param pulumi.Input[str] cidr_block: A network address block which should be a subnet of the three internal network segments (10.0.0.0/16, 172.16.0.0/12 and 192.168.0.0/16).
        :param pulumi.Input[str] creation_time: Creation time of VPC.
        :param pulumi.Input[str] description: The description of the VPC.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: The DNS server list of the VPC. And you can specify 0 to 5 servers to this list.
        :param pulumi.Input[bool] enable_ipv6: Specifies whether to enable the IPv6 CIDR block of the VPC.
        :param pulumi.Input[str] ipv6_cidr_block: The IPv6 CIDR block of the VPC.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nat_gateway_ids: The nat gateway ID list of VPC.
        :param pulumi.Input[str] project_name: The ProjectName of the VPC.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] route_table_ids: The route table ID list of VPC.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: The security group ID list of VPC.
        :param pulumi.Input[str] status: Status of VPC.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: The subnet ID list of VPC.
        :param pulumi.Input[Sequence[pulumi.Input['VpcTagArgs']]] tags: Tags.
        :param pulumi.Input[str] update_time: The update time of VPC.
        :param pulumi.Input[str] vpc_id: The ID of VPC.
        :param pulumi.Input[str] vpc_name: The name of the VPC.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if associate_cens is not None:
            pulumi.set(__self__, "associate_cens", associate_cens)
        if auxiliary_cidr_blocks is not None:
            pulumi.set(__self__, "auxiliary_cidr_blocks", auxiliary_cidr_blocks)
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if enable_ipv6 is not None:
            pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        if ipv6_cidr_block is not None:
            pulumi.set(__self__, "ipv6_cidr_block", ipv6_cidr_block)
        if nat_gateway_ids is not None:
            pulumi.set(__self__, "nat_gateway_ids", nat_gateway_ids)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if route_table_ids is not None:
            pulumi.set(__self__, "route_table_ids", route_table_ids)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_name is not None:
            pulumi.set(__self__, "vpc_name", vpc_name)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account ID of VPC.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="associateCens")
    def associate_cens(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcAssociateCenArgs']]]]:
        """
        The associate cen list of VPC.
        """
        return pulumi.get(self, "associate_cens")

    @associate_cens.setter
    def associate_cens(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcAssociateCenArgs']]]]):
        pulumi.set(self, "associate_cens", value)

    @property
    @pulumi.getter(name="auxiliaryCidrBlocks")
    def auxiliary_cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The auxiliary cidr block list of VPC.
        """
        return pulumi.get(self, "auxiliary_cidr_blocks")

    @auxiliary_cidr_blocks.setter
    def auxiliary_cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "auxiliary_cidr_blocks", value)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        A network address block which should be a subnet of the three internal network segments (10.0.0.0/16, 172.16.0.0/12 and 192.168.0.0/16).
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr_block", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        Creation time of VPC.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the VPC.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The DNS server list of the VPC. And you can specify 0 to 5 servers to this list.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_servers", value)

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the IPv6 CIDR block of the VPC.
        """
        return pulumi.get(self, "enable_ipv6")

    @enable_ipv6.setter
    def enable_ipv6(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ipv6", value)

    @property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 CIDR block of the VPC.
        """
        return pulumi.get(self, "ipv6_cidr_block")

    @ipv6_cidr_block.setter
    def ipv6_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_cidr_block", value)

    @property
    @pulumi.getter(name="natGatewayIds")
    def nat_gateway_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The nat gateway ID list of VPC.
        """
        return pulumi.get(self, "nat_gateway_ids")

    @nat_gateway_ids.setter
    def nat_gateway_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nat_gateway_ids", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The ProjectName of the VPC.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="routeTableIds")
    def route_table_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The route table ID list of VPC.
        """
        return pulumi.get(self, "route_table_ids")

    @route_table_ids.setter
    def route_table_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "route_table_ids", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The security group ID list of VPC.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of VPC.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The subnet ID list of VPC.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcTagArgs']]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The update time of VPC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC.
        """
        return pulumi.get(self, "vpc_name")

    @vpc_name.setter
    def vpc_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_name", value)


class Vpc(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr_block: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_ipv6: Optional[pulumi.Input[bool]] = None,
                 ipv6_cidr_block: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcTagArgs']]]]] = None,
                 vpc_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage vpc
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.vpc.Vpc("foo",
            cidr_block="172.16.0.0/16",
            dns_servers=[
                "8.8.8.8",
                "114.114.114.114",
            ],
            project_name="AS_test",
            vpc_name="tf-project-1")
        ```

        ## Import

        VPC can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpc/vpc:Vpc default vpc-mizl7m1kqccg5smt1bdpijuj
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cidr_block: A network address block which should be a subnet of the three internal network segments (10.0.0.0/16, 172.16.0.0/12 and 192.168.0.0/16).
        :param pulumi.Input[str] description: The description of the VPC.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: The DNS server list of the VPC. And you can specify 0 to 5 servers to this list.
        :param pulumi.Input[bool] enable_ipv6: Specifies whether to enable the IPv6 CIDR block of the VPC.
        :param pulumi.Input[str] ipv6_cidr_block: The IPv6 CIDR block of the VPC.
        :param pulumi.Input[str] project_name: The ProjectName of the VPC.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcTagArgs']]]] tags: Tags.
        :param pulumi.Input[str] vpc_name: The name of the VPC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage vpc
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.vpc.Vpc("foo",
            cidr_block="172.16.0.0/16",
            dns_servers=[
                "8.8.8.8",
                "114.114.114.114",
            ],
            project_name="AS_test",
            vpc_name="tf-project-1")
        ```

        ## Import

        VPC can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpc/vpc:Vpc default vpc-mizl7m1kqccg5smt1bdpijuj
        ```

        :param str resource_name: The name of the resource.
        :param VpcArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr_block: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_ipv6: Optional[pulumi.Input[bool]] = None,
                 ipv6_cidr_block: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcTagArgs']]]]] = None,
                 vpc_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcArgs.__new__(VpcArgs)

            if cidr_block is None and not opts.urn:
                raise TypeError("Missing required property 'cidr_block'")
            __props__.__dict__["cidr_block"] = cidr_block
            __props__.__dict__["description"] = description
            __props__.__dict__["dns_servers"] = dns_servers
            __props__.__dict__["enable_ipv6"] = enable_ipv6
            __props__.__dict__["ipv6_cidr_block"] = ipv6_cidr_block
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_name"] = vpc_name
            __props__.__dict__["account_id"] = None
            __props__.__dict__["associate_cens"] = None
            __props__.__dict__["auxiliary_cidr_blocks"] = None
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["nat_gateway_ids"] = None
            __props__.__dict__["route_table_ids"] = None
            __props__.__dict__["security_group_ids"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["subnet_ids"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["vpc_id"] = None
        super(Vpc, __self__).__init__(
            'volcengine:vpc/vpc:Vpc',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            associate_cens: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcAssociateCenArgs']]]]] = None,
            auxiliary_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            cidr_block: Optional[pulumi.Input[str]] = None,
            creation_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            enable_ipv6: Optional[pulumi.Input[bool]] = None,
            ipv6_cidr_block: Optional[pulumi.Input[str]] = None,
            nat_gateway_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            route_table_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcTagArgs']]]]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vpc_name: Optional[pulumi.Input[str]] = None) -> 'Vpc':
        """
        Get an existing Vpc resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account ID of VPC.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcAssociateCenArgs']]]] associate_cens: The associate cen list of VPC.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] auxiliary_cidr_blocks: The auxiliary cidr block list of VPC.
        :param pulumi.Input[str] cidr_block: A network address block which should be a subnet of the three internal network segments (10.0.0.0/16, 172.16.0.0/12 and 192.168.0.0/16).
        :param pulumi.Input[str] creation_time: Creation time of VPC.
        :param pulumi.Input[str] description: The description of the VPC.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: The DNS server list of the VPC. And you can specify 0 to 5 servers to this list.
        :param pulumi.Input[bool] enable_ipv6: Specifies whether to enable the IPv6 CIDR block of the VPC.
        :param pulumi.Input[str] ipv6_cidr_block: The IPv6 CIDR block of the VPC.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nat_gateway_ids: The nat gateway ID list of VPC.
        :param pulumi.Input[str] project_name: The ProjectName of the VPC.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] route_table_ids: The route table ID list of VPC.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: The security group ID list of VPC.
        :param pulumi.Input[str] status: Status of VPC.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: The subnet ID list of VPC.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcTagArgs']]]] tags: Tags.
        :param pulumi.Input[str] update_time: The update time of VPC.
        :param pulumi.Input[str] vpc_id: The ID of VPC.
        :param pulumi.Input[str] vpc_name: The name of the VPC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcState.__new__(_VpcState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["associate_cens"] = associate_cens
        __props__.__dict__["auxiliary_cidr_blocks"] = auxiliary_cidr_blocks
        __props__.__dict__["cidr_block"] = cidr_block
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["description"] = description
        __props__.__dict__["dns_servers"] = dns_servers
        __props__.__dict__["enable_ipv6"] = enable_ipv6
        __props__.__dict__["ipv6_cidr_block"] = ipv6_cidr_block
        __props__.__dict__["nat_gateway_ids"] = nat_gateway_ids
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["route_table_ids"] = route_table_ids
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpc_name"] = vpc_name
        return Vpc(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The account ID of VPC.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="associateCens")
    def associate_cens(self) -> pulumi.Output[Sequence['outputs.VpcAssociateCen']]:
        """
        The associate cen list of VPC.
        """
        return pulumi.get(self, "associate_cens")

    @property
    @pulumi.getter(name="auxiliaryCidrBlocks")
    def auxiliary_cidr_blocks(self) -> pulumi.Output[Sequence[str]]:
        """
        The auxiliary cidr block list of VPC.
        """
        return pulumi.get(self, "auxiliary_cidr_blocks")

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Output[str]:
        """
        A network address block which should be a subnet of the three internal network segments (10.0.0.0/16, 172.16.0.0/12 and 192.168.0.0/16).
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        Creation time of VPC.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the VPC.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The DNS server list of the VPC. And you can specify 0 to 5 servers to this list.
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> pulumi.Output[bool]:
        """
        Specifies whether to enable the IPv6 CIDR block of the VPC.
        """
        return pulumi.get(self, "enable_ipv6")

    @property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> pulumi.Output[str]:
        """
        The IPv6 CIDR block of the VPC.
        """
        return pulumi.get(self, "ipv6_cidr_block")

    @property
    @pulumi.getter(name="natGatewayIds")
    def nat_gateway_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The nat gateway ID list of VPC.
        """
        return pulumi.get(self, "nat_gateway_ids")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        The ProjectName of the VPC.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="routeTableIds")
    def route_table_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The route table ID list of VPC.
        """
        return pulumi.get(self, "route_table_ids")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The security group ID list of VPC.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of VPC.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The subnet ID list of VPC.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.VpcTag']]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The update time of VPC.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The ID of VPC.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> pulumi.Output[str]:
        """
        The name of the VPC.
        """
        return pulumi.get(self, "vpc_name")

