# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ConnectionArgs', 'Connection']

@pulumi.input_type
class ConnectionArgs:
    def __init__(__self__, *,
                 customer_gateway_id: pulumi.Input[str],
                 ike_config_psk: pulumi.Input[str],
                 local_subnets: pulumi.Input[Sequence[pulumi.Input[str]]],
                 remote_subnets: pulumi.Input[Sequence[pulumi.Input[str]]],
                 attach_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dpd_action: Optional[pulumi.Input[str]] = None,
                 ike_config_auth_alg: Optional[pulumi.Input[str]] = None,
                 ike_config_dh_group: Optional[pulumi.Input[str]] = None,
                 ike_config_enc_alg: Optional[pulumi.Input[str]] = None,
                 ike_config_lifetime: Optional[pulumi.Input[int]] = None,
                 ike_config_local_id: Optional[pulumi.Input[str]] = None,
                 ike_config_mode: Optional[pulumi.Input[str]] = None,
                 ike_config_remote_id: Optional[pulumi.Input[str]] = None,
                 ike_config_version: Optional[pulumi.Input[str]] = None,
                 ipsec_config_auth_alg: Optional[pulumi.Input[str]] = None,
                 ipsec_config_dh_group: Optional[pulumi.Input[str]] = None,
                 ipsec_config_enc_alg: Optional[pulumi.Input[str]] = None,
                 ipsec_config_lifetime: Optional[pulumi.Input[int]] = None,
                 log_enabled: Optional[pulumi.Input[bool]] = None,
                 nat_traversal: Optional[pulumi.Input[bool]] = None,
                 negotiate_instantly: Optional[pulumi.Input[bool]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 vpn_connection_name: Optional[pulumi.Input[str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Connection resource.
        :param pulumi.Input[str] customer_gateway_id: The ID of the customer gateway.
        :param pulumi.Input[str] ike_config_psk: The psk of the ike config of the VPN connection. The length does not exceed 100 characters, and only uppercase and lowercase letters, special symbols and numbers are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_subnets: The local subnet of the VPN connection. Up to 5 network segments are supported.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_subnets: The remote subnet of the VPN connection. Up to 5 network segments are supported.
        :param pulumi.Input[str] attach_type: The attach type of the VPN connection, the value can be `VpnGateway` or `TransitRouter`.
        :param pulumi.Input[str] description: The description of the VPN connection.
        :param pulumi.Input[str] dpd_action: The dpd action of the VPN connection.
        :param pulumi.Input[str] ike_config_auth_alg: The auth alg of the ike config of the VPN connection. Valid value are `sha1`, `md5`, `sha256`, `sha384`, `sha512`, `sm3`. The default value is `sha1`.
        :param pulumi.Input[str] ike_config_dh_group: The dk group of the ike config of the VPN connection. Valid value are `group1`, `group2`, `group5`, `group14`. The default value is `group2`.
        :param pulumi.Input[str] ike_config_enc_alg: The enc alg of the ike config of the VPN connection. Valid value are `aes`, `aes192`, `aes256`, `des`, `3des`, `sm4`. The default value is `aes`.
        :param pulumi.Input[int] ike_config_lifetime: The lifetime of the ike config of the VPN connection. Value: 900~86400.
        :param pulumi.Input[str] ike_config_local_id: The local_id of the ike config of the VPN connection.
        :param pulumi.Input[str] ike_config_mode: The mode of the ike config of the VPN connection. Valid values are `main`, `aggressive`, and default value is `main`.
        :param pulumi.Input[str] ike_config_remote_id: The remote id of the ike config of the VPN connection.
        :param pulumi.Input[str] ike_config_version: The version of the ike config of the VPN connection. The value can be `ikev1` or `ikev2`. The default value is `ikev1`.
        :param pulumi.Input[str] ipsec_config_auth_alg: The auth alg of the ipsec config of the VPN connection. Valid value are `sha1`, `md5`, `sha256`, `sha384`, `sha512`, `sm3`. The default value is `sha1`.
        :param pulumi.Input[str] ipsec_config_dh_group: The dh group of the ipsec config of the VPN connection. Valid value are `group1`, `group2`, `group5`, `group14` and `disable`. The default value is `group2`.
        :param pulumi.Input[str] ipsec_config_enc_alg: The enc alg of the ipsec config of the VPN connection. Valid value are `aes`, `aes192`, `aes256`, `des`, `3des`, `sm4`. The default value is `aes`.
        :param pulumi.Input[int] ipsec_config_lifetime: The ipsec config of the ike config of the VPN connection. Value: 900~86400.
        :param pulumi.Input[bool] log_enabled: Whether to enable connection logging. After enabling Connection Day, you can view and download IPsec connection logs, and use the log information to troubleshoot IPsec connection problems yourself.
        :param pulumi.Input[bool] nat_traversal: The nat traversal of the VPN connection.
        :param pulumi.Input[bool] negotiate_instantly: Whether to initiate negotiation mode immediately.
        :param pulumi.Input[str] project_name: The project name of the VPN connection.
        :param pulumi.Input[str] vpn_connection_name: The name of the VPN connection.
        :param pulumi.Input[str] vpn_gateway_id: The ID of the vpn gateway. If the `AttachType` is not passed or the passed value is `VpnGateway`, this parameter must be filled. If the value of `AttachType` is `TransitRouter`, this parameter does not need to be filled.
        """
        pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        pulumi.set(__self__, "ike_config_psk", ike_config_psk)
        pulumi.set(__self__, "local_subnets", local_subnets)
        pulumi.set(__self__, "remote_subnets", remote_subnets)
        if attach_type is not None:
            pulumi.set(__self__, "attach_type", attach_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dpd_action is not None:
            pulumi.set(__self__, "dpd_action", dpd_action)
        if ike_config_auth_alg is not None:
            pulumi.set(__self__, "ike_config_auth_alg", ike_config_auth_alg)
        if ike_config_dh_group is not None:
            pulumi.set(__self__, "ike_config_dh_group", ike_config_dh_group)
        if ike_config_enc_alg is not None:
            pulumi.set(__self__, "ike_config_enc_alg", ike_config_enc_alg)
        if ike_config_lifetime is not None:
            pulumi.set(__self__, "ike_config_lifetime", ike_config_lifetime)
        if ike_config_local_id is not None:
            pulumi.set(__self__, "ike_config_local_id", ike_config_local_id)
        if ike_config_mode is not None:
            pulumi.set(__self__, "ike_config_mode", ike_config_mode)
        if ike_config_remote_id is not None:
            pulumi.set(__self__, "ike_config_remote_id", ike_config_remote_id)
        if ike_config_version is not None:
            pulumi.set(__self__, "ike_config_version", ike_config_version)
        if ipsec_config_auth_alg is not None:
            pulumi.set(__self__, "ipsec_config_auth_alg", ipsec_config_auth_alg)
        if ipsec_config_dh_group is not None:
            pulumi.set(__self__, "ipsec_config_dh_group", ipsec_config_dh_group)
        if ipsec_config_enc_alg is not None:
            pulumi.set(__self__, "ipsec_config_enc_alg", ipsec_config_enc_alg)
        if ipsec_config_lifetime is not None:
            pulumi.set(__self__, "ipsec_config_lifetime", ipsec_config_lifetime)
        if log_enabled is not None:
            pulumi.set(__self__, "log_enabled", log_enabled)
        if nat_traversal is not None:
            pulumi.set(__self__, "nat_traversal", nat_traversal)
        if negotiate_instantly is not None:
            pulumi.set(__self__, "negotiate_instantly", negotiate_instantly)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if vpn_connection_name is not None:
            pulumi.set(__self__, "vpn_connection_name", vpn_connection_name)
        if vpn_gateway_id is not None:
            pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)

    @property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> pulumi.Input[str]:
        """
        The ID of the customer gateway.
        """
        return pulumi.get(self, "customer_gateway_id")

    @customer_gateway_id.setter
    def customer_gateway_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "customer_gateway_id", value)

    @property
    @pulumi.getter(name="ikeConfigPsk")
    def ike_config_psk(self) -> pulumi.Input[str]:
        """
        The psk of the ike config of the VPN connection. The length does not exceed 100 characters, and only uppercase and lowercase letters, special symbols and numbers are allowed.
        """
        return pulumi.get(self, "ike_config_psk")

    @ike_config_psk.setter
    def ike_config_psk(self, value: pulumi.Input[str]):
        pulumi.set(self, "ike_config_psk", value)

    @property
    @pulumi.getter(name="localSubnets")
    def local_subnets(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The local subnet of the VPN connection. Up to 5 network segments are supported.
        """
        return pulumi.get(self, "local_subnets")

    @local_subnets.setter
    def local_subnets(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "local_subnets", value)

    @property
    @pulumi.getter(name="remoteSubnets")
    def remote_subnets(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The remote subnet of the VPN connection. Up to 5 network segments are supported.
        """
        return pulumi.get(self, "remote_subnets")

    @remote_subnets.setter
    def remote_subnets(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "remote_subnets", value)

    @property
    @pulumi.getter(name="attachType")
    def attach_type(self) -> Optional[pulumi.Input[str]]:
        """
        The attach type of the VPN connection, the value can be `VpnGateway` or `TransitRouter`.
        """
        return pulumi.get(self, "attach_type")

    @attach_type.setter
    def attach_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attach_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the VPN connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dpdAction")
    def dpd_action(self) -> Optional[pulumi.Input[str]]:
        """
        The dpd action of the VPN connection.
        """
        return pulumi.get(self, "dpd_action")

    @dpd_action.setter
    def dpd_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dpd_action", value)

    @property
    @pulumi.getter(name="ikeConfigAuthAlg")
    def ike_config_auth_alg(self) -> Optional[pulumi.Input[str]]:
        """
        The auth alg of the ike config of the VPN connection. Valid value are `sha1`, `md5`, `sha256`, `sha384`, `sha512`, `sm3`. The default value is `sha1`.
        """
        return pulumi.get(self, "ike_config_auth_alg")

    @ike_config_auth_alg.setter
    def ike_config_auth_alg(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ike_config_auth_alg", value)

    @property
    @pulumi.getter(name="ikeConfigDhGroup")
    def ike_config_dh_group(self) -> Optional[pulumi.Input[str]]:
        """
        The dk group of the ike config of the VPN connection. Valid value are `group1`, `group2`, `group5`, `group14`. The default value is `group2`.
        """
        return pulumi.get(self, "ike_config_dh_group")

    @ike_config_dh_group.setter
    def ike_config_dh_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ike_config_dh_group", value)

    @property
    @pulumi.getter(name="ikeConfigEncAlg")
    def ike_config_enc_alg(self) -> Optional[pulumi.Input[str]]:
        """
        The enc alg of the ike config of the VPN connection. Valid value are `aes`, `aes192`, `aes256`, `des`, `3des`, `sm4`. The default value is `aes`.
        """
        return pulumi.get(self, "ike_config_enc_alg")

    @ike_config_enc_alg.setter
    def ike_config_enc_alg(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ike_config_enc_alg", value)

    @property
    @pulumi.getter(name="ikeConfigLifetime")
    def ike_config_lifetime(self) -> Optional[pulumi.Input[int]]:
        """
        The lifetime of the ike config of the VPN connection. Value: 900~86400.
        """
        return pulumi.get(self, "ike_config_lifetime")

    @ike_config_lifetime.setter
    def ike_config_lifetime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ike_config_lifetime", value)

    @property
    @pulumi.getter(name="ikeConfigLocalId")
    def ike_config_local_id(self) -> Optional[pulumi.Input[str]]:
        """
        The local_id of the ike config of the VPN connection.
        """
        return pulumi.get(self, "ike_config_local_id")

    @ike_config_local_id.setter
    def ike_config_local_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ike_config_local_id", value)

    @property
    @pulumi.getter(name="ikeConfigMode")
    def ike_config_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The mode of the ike config of the VPN connection. Valid values are `main`, `aggressive`, and default value is `main`.
        """
        return pulumi.get(self, "ike_config_mode")

    @ike_config_mode.setter
    def ike_config_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ike_config_mode", value)

    @property
    @pulumi.getter(name="ikeConfigRemoteId")
    def ike_config_remote_id(self) -> Optional[pulumi.Input[str]]:
        """
        The remote id of the ike config of the VPN connection.
        """
        return pulumi.get(self, "ike_config_remote_id")

    @ike_config_remote_id.setter
    def ike_config_remote_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ike_config_remote_id", value)

    @property
    @pulumi.getter(name="ikeConfigVersion")
    def ike_config_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the ike config of the VPN connection. The value can be `ikev1` or `ikev2`. The default value is `ikev1`.
        """
        return pulumi.get(self, "ike_config_version")

    @ike_config_version.setter
    def ike_config_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ike_config_version", value)

    @property
    @pulumi.getter(name="ipsecConfigAuthAlg")
    def ipsec_config_auth_alg(self) -> Optional[pulumi.Input[str]]:
        """
        The auth alg of the ipsec config of the VPN connection. Valid value are `sha1`, `md5`, `sha256`, `sha384`, `sha512`, `sm3`. The default value is `sha1`.
        """
        return pulumi.get(self, "ipsec_config_auth_alg")

    @ipsec_config_auth_alg.setter
    def ipsec_config_auth_alg(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipsec_config_auth_alg", value)

    @property
    @pulumi.getter(name="ipsecConfigDhGroup")
    def ipsec_config_dh_group(self) -> Optional[pulumi.Input[str]]:
        """
        The dh group of the ipsec config of the VPN connection. Valid value are `group1`, `group2`, `group5`, `group14` and `disable`. The default value is `group2`.
        """
        return pulumi.get(self, "ipsec_config_dh_group")

    @ipsec_config_dh_group.setter
    def ipsec_config_dh_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipsec_config_dh_group", value)

    @property
    @pulumi.getter(name="ipsecConfigEncAlg")
    def ipsec_config_enc_alg(self) -> Optional[pulumi.Input[str]]:
        """
        The enc alg of the ipsec config of the VPN connection. Valid value are `aes`, `aes192`, `aes256`, `des`, `3des`, `sm4`. The default value is `aes`.
        """
        return pulumi.get(self, "ipsec_config_enc_alg")

    @ipsec_config_enc_alg.setter
    def ipsec_config_enc_alg(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipsec_config_enc_alg", value)

    @property
    @pulumi.getter(name="ipsecConfigLifetime")
    def ipsec_config_lifetime(self) -> Optional[pulumi.Input[int]]:
        """
        The ipsec config of the ike config of the VPN connection. Value: 900~86400.
        """
        return pulumi.get(self, "ipsec_config_lifetime")

    @ipsec_config_lifetime.setter
    def ipsec_config_lifetime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipsec_config_lifetime", value)

    @property
    @pulumi.getter(name="logEnabled")
    def log_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable connection logging. After enabling Connection Day, you can view and download IPsec connection logs, and use the log information to troubleshoot IPsec connection problems yourself.
        """
        return pulumi.get(self, "log_enabled")

    @log_enabled.setter
    def log_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "log_enabled", value)

    @property
    @pulumi.getter(name="natTraversal")
    def nat_traversal(self) -> Optional[pulumi.Input[bool]]:
        """
        The nat traversal of the VPN connection.
        """
        return pulumi.get(self, "nat_traversal")

    @nat_traversal.setter
    def nat_traversal(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "nat_traversal", value)

    @property
    @pulumi.getter(name="negotiateInstantly")
    def negotiate_instantly(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to initiate negotiation mode immediately.
        """
        return pulumi.get(self, "negotiate_instantly")

    @negotiate_instantly.setter
    def negotiate_instantly(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negotiate_instantly", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name of the VPN connection.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="vpnConnectionName")
    def vpn_connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPN connection.
        """
        return pulumi.get(self, "vpn_connection_name")

    @vpn_connection_name.setter
    def vpn_connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_connection_name", value)

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the vpn gateway. If the `AttachType` is not passed or the passed value is `VpnGateway`, this parameter must be filled. If the value of `AttachType` is `TransitRouter`, this parameter does not need to be filled.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @vpn_gateway_id.setter
    def vpn_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_gateway_id", value)


@pulumi.input_type
class _ConnectionState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 attach_status: Optional[pulumi.Input[str]] = None,
                 attach_type: Optional[pulumi.Input[str]] = None,
                 business_status: Optional[pulumi.Input[str]] = None,
                 connect_status: Optional[pulumi.Input[str]] = None,
                 creation_time: Optional[pulumi.Input[str]] = None,
                 customer_gateway_id: Optional[pulumi.Input[str]] = None,
                 deleted_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dpd_action: Optional[pulumi.Input[str]] = None,
                 ike_config_auth_alg: Optional[pulumi.Input[str]] = None,
                 ike_config_dh_group: Optional[pulumi.Input[str]] = None,
                 ike_config_enc_alg: Optional[pulumi.Input[str]] = None,
                 ike_config_lifetime: Optional[pulumi.Input[int]] = None,
                 ike_config_local_id: Optional[pulumi.Input[str]] = None,
                 ike_config_mode: Optional[pulumi.Input[str]] = None,
                 ike_config_psk: Optional[pulumi.Input[str]] = None,
                 ike_config_remote_id: Optional[pulumi.Input[str]] = None,
                 ike_config_version: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ipsec_config_auth_alg: Optional[pulumi.Input[str]] = None,
                 ipsec_config_dh_group: Optional[pulumi.Input[str]] = None,
                 ipsec_config_enc_alg: Optional[pulumi.Input[str]] = None,
                 ipsec_config_lifetime: Optional[pulumi.Input[int]] = None,
                 local_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_enabled: Optional[pulumi.Input[bool]] = None,
                 nat_traversal: Optional[pulumi.Input[bool]] = None,
                 negotiate_instantly: Optional[pulumi.Input[bool]] = None,
                 overdue_time: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 remote_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 transit_router_id: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 vpn_connection_id: Optional[pulumi.Input[str]] = None,
                 vpn_connection_name: Optional[pulumi.Input[str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Connection resources.
        :param pulumi.Input[str] account_id: The account ID of the VPN connection.
        :param pulumi.Input[str] attach_status: The IPsec attach status.
        :param pulumi.Input[str] attach_type: The attach type of the VPN connection, the value can be `VpnGateway` or `TransitRouter`.
        :param pulumi.Input[str] business_status: The business status of IPsec connection, valid when the attach type is 'TransitRouter'.
        :param pulumi.Input[str] connect_status: The connect status of the VPN connection.
        :param pulumi.Input[str] creation_time: The create time of VPN connection.
        :param pulumi.Input[str] customer_gateway_id: The ID of the customer gateway.
        :param pulumi.Input[str] deleted_time: The delete time of resource, valid when the attach type is 'TransitRouter'.
        :param pulumi.Input[str] description: The description of the VPN connection.
        :param pulumi.Input[str] dpd_action: The dpd action of the VPN connection.
        :param pulumi.Input[str] ike_config_auth_alg: The auth alg of the ike config of the VPN connection. Valid value are `sha1`, `md5`, `sha256`, `sha384`, `sha512`, `sm3`. The default value is `sha1`.
        :param pulumi.Input[str] ike_config_dh_group: The dk group of the ike config of the VPN connection. Valid value are `group1`, `group2`, `group5`, `group14`. The default value is `group2`.
        :param pulumi.Input[str] ike_config_enc_alg: The enc alg of the ike config of the VPN connection. Valid value are `aes`, `aes192`, `aes256`, `des`, `3des`, `sm4`. The default value is `aes`.
        :param pulumi.Input[int] ike_config_lifetime: The lifetime of the ike config of the VPN connection. Value: 900~86400.
        :param pulumi.Input[str] ike_config_local_id: The local_id of the ike config of the VPN connection.
        :param pulumi.Input[str] ike_config_mode: The mode of the ike config of the VPN connection. Valid values are `main`, `aggressive`, and default value is `main`.
        :param pulumi.Input[str] ike_config_psk: The psk of the ike config of the VPN connection. The length does not exceed 100 characters, and only uppercase and lowercase letters, special symbols and numbers are allowed.
        :param pulumi.Input[str] ike_config_remote_id: The remote id of the ike config of the VPN connection.
        :param pulumi.Input[str] ike_config_version: The version of the ike config of the VPN connection. The value can be `ikev1` or `ikev2`. The default value is `ikev1`.
        :param pulumi.Input[str] ip_address: The ip address of transit router, valid when the attach type is 'TransitRouter'.
        :param pulumi.Input[str] ipsec_config_auth_alg: The auth alg of the ipsec config of the VPN connection. Valid value are `sha1`, `md5`, `sha256`, `sha384`, `sha512`, `sm3`. The default value is `sha1`.
        :param pulumi.Input[str] ipsec_config_dh_group: The dh group of the ipsec config of the VPN connection. Valid value are `group1`, `group2`, `group5`, `group14` and `disable`. The default value is `group2`.
        :param pulumi.Input[str] ipsec_config_enc_alg: The enc alg of the ipsec config of the VPN connection. Valid value are `aes`, `aes192`, `aes256`, `des`, `3des`, `sm4`. The default value is `aes`.
        :param pulumi.Input[int] ipsec_config_lifetime: The ipsec config of the ike config of the VPN connection. Value: 900~86400.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_subnets: The local subnet of the VPN connection. Up to 5 network segments are supported.
        :param pulumi.Input[bool] log_enabled: Whether to enable connection logging. After enabling Connection Day, you can view and download IPsec connection logs, and use the log information to troubleshoot IPsec connection problems yourself.
        :param pulumi.Input[bool] nat_traversal: The nat traversal of the VPN connection.
        :param pulumi.Input[bool] negotiate_instantly: Whether to initiate negotiation mode immediately.
        :param pulumi.Input[str] overdue_time: The overdue time of resource, valid when the attach type is 'TransitRouter'.
        :param pulumi.Input[str] project_name: The project name of the VPN connection.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_subnets: The remote subnet of the VPN connection. Up to 5 network segments are supported.
        :param pulumi.Input[str] status: The status of the VPN connection.
        :param pulumi.Input[str] transit_router_id: The id of transit router, valid when the attach type is 'TransitRouter'.
        :param pulumi.Input[str] update_time: The update time of VPN connection.
        :param pulumi.Input[str] vpn_connection_id: The ID of the VPN connection.
        :param pulumi.Input[str] vpn_connection_name: The name of the VPN connection.
        :param pulumi.Input[str] vpn_gateway_id: The ID of the vpn gateway. If the `AttachType` is not passed or the passed value is `VpnGateway`, this parameter must be filled. If the value of `AttachType` is `TransitRouter`, this parameter does not need to be filled.
        :param pulumi.Input[str] zone_id: The zone id of transit router, valid when the attach type is 'TransitRouter'.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if attach_status is not None:
            pulumi.set(__self__, "attach_status", attach_status)
        if attach_type is not None:
            pulumi.set(__self__, "attach_type", attach_type)
        if business_status is not None:
            pulumi.set(__self__, "business_status", business_status)
        if connect_status is not None:
            pulumi.set(__self__, "connect_status", connect_status)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if customer_gateway_id is not None:
            pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        if deleted_time is not None:
            pulumi.set(__self__, "deleted_time", deleted_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dpd_action is not None:
            pulumi.set(__self__, "dpd_action", dpd_action)
        if ike_config_auth_alg is not None:
            pulumi.set(__self__, "ike_config_auth_alg", ike_config_auth_alg)
        if ike_config_dh_group is not None:
            pulumi.set(__self__, "ike_config_dh_group", ike_config_dh_group)
        if ike_config_enc_alg is not None:
            pulumi.set(__self__, "ike_config_enc_alg", ike_config_enc_alg)
        if ike_config_lifetime is not None:
            pulumi.set(__self__, "ike_config_lifetime", ike_config_lifetime)
        if ike_config_local_id is not None:
            pulumi.set(__self__, "ike_config_local_id", ike_config_local_id)
        if ike_config_mode is not None:
            pulumi.set(__self__, "ike_config_mode", ike_config_mode)
        if ike_config_psk is not None:
            pulumi.set(__self__, "ike_config_psk", ike_config_psk)
        if ike_config_remote_id is not None:
            pulumi.set(__self__, "ike_config_remote_id", ike_config_remote_id)
        if ike_config_version is not None:
            pulumi.set(__self__, "ike_config_version", ike_config_version)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ipsec_config_auth_alg is not None:
            pulumi.set(__self__, "ipsec_config_auth_alg", ipsec_config_auth_alg)
        if ipsec_config_dh_group is not None:
            pulumi.set(__self__, "ipsec_config_dh_group", ipsec_config_dh_group)
        if ipsec_config_enc_alg is not None:
            pulumi.set(__self__, "ipsec_config_enc_alg", ipsec_config_enc_alg)
        if ipsec_config_lifetime is not None:
            pulumi.set(__self__, "ipsec_config_lifetime", ipsec_config_lifetime)
        if local_subnets is not None:
            pulumi.set(__self__, "local_subnets", local_subnets)
        if log_enabled is not None:
            pulumi.set(__self__, "log_enabled", log_enabled)
        if nat_traversal is not None:
            pulumi.set(__self__, "nat_traversal", nat_traversal)
        if negotiate_instantly is not None:
            pulumi.set(__self__, "negotiate_instantly", negotiate_instantly)
        if overdue_time is not None:
            pulumi.set(__self__, "overdue_time", overdue_time)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if remote_subnets is not None:
            pulumi.set(__self__, "remote_subnets", remote_subnets)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if vpn_connection_id is not None:
            pulumi.set(__self__, "vpn_connection_id", vpn_connection_id)
        if vpn_connection_name is not None:
            pulumi.set(__self__, "vpn_connection_name", vpn_connection_name)
        if vpn_gateway_id is not None:
            pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account ID of the VPN connection.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="attachStatus")
    def attach_status(self) -> Optional[pulumi.Input[str]]:
        """
        The IPsec attach status.
        """
        return pulumi.get(self, "attach_status")

    @attach_status.setter
    def attach_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attach_status", value)

    @property
    @pulumi.getter(name="attachType")
    def attach_type(self) -> Optional[pulumi.Input[str]]:
        """
        The attach type of the VPN connection, the value can be `VpnGateway` or `TransitRouter`.
        """
        return pulumi.get(self, "attach_type")

    @attach_type.setter
    def attach_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attach_type", value)

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> Optional[pulumi.Input[str]]:
        """
        The business status of IPsec connection, valid when the attach type is 'TransitRouter'.
        """
        return pulumi.get(self, "business_status")

    @business_status.setter
    def business_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "business_status", value)

    @property
    @pulumi.getter(name="connectStatus")
    def connect_status(self) -> Optional[pulumi.Input[str]]:
        """
        The connect status of the VPN connection.
        """
        return pulumi.get(self, "connect_status")

    @connect_status.setter
    def connect_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connect_status", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        The create time of VPN connection.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the customer gateway.
        """
        return pulumi.get(self, "customer_gateway_id")

    @customer_gateway_id.setter
    def customer_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_gateway_id", value)

    @property
    @pulumi.getter(name="deletedTime")
    def deleted_time(self) -> Optional[pulumi.Input[str]]:
        """
        The delete time of resource, valid when the attach type is 'TransitRouter'.
        """
        return pulumi.get(self, "deleted_time")

    @deleted_time.setter
    def deleted_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deleted_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the VPN connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dpdAction")
    def dpd_action(self) -> Optional[pulumi.Input[str]]:
        """
        The dpd action of the VPN connection.
        """
        return pulumi.get(self, "dpd_action")

    @dpd_action.setter
    def dpd_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dpd_action", value)

    @property
    @pulumi.getter(name="ikeConfigAuthAlg")
    def ike_config_auth_alg(self) -> Optional[pulumi.Input[str]]:
        """
        The auth alg of the ike config of the VPN connection. Valid value are `sha1`, `md5`, `sha256`, `sha384`, `sha512`, `sm3`. The default value is `sha1`.
        """
        return pulumi.get(self, "ike_config_auth_alg")

    @ike_config_auth_alg.setter
    def ike_config_auth_alg(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ike_config_auth_alg", value)

    @property
    @pulumi.getter(name="ikeConfigDhGroup")
    def ike_config_dh_group(self) -> Optional[pulumi.Input[str]]:
        """
        The dk group of the ike config of the VPN connection. Valid value are `group1`, `group2`, `group5`, `group14`. The default value is `group2`.
        """
        return pulumi.get(self, "ike_config_dh_group")

    @ike_config_dh_group.setter
    def ike_config_dh_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ike_config_dh_group", value)

    @property
    @pulumi.getter(name="ikeConfigEncAlg")
    def ike_config_enc_alg(self) -> Optional[pulumi.Input[str]]:
        """
        The enc alg of the ike config of the VPN connection. Valid value are `aes`, `aes192`, `aes256`, `des`, `3des`, `sm4`. The default value is `aes`.
        """
        return pulumi.get(self, "ike_config_enc_alg")

    @ike_config_enc_alg.setter
    def ike_config_enc_alg(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ike_config_enc_alg", value)

    @property
    @pulumi.getter(name="ikeConfigLifetime")
    def ike_config_lifetime(self) -> Optional[pulumi.Input[int]]:
        """
        The lifetime of the ike config of the VPN connection. Value: 900~86400.
        """
        return pulumi.get(self, "ike_config_lifetime")

    @ike_config_lifetime.setter
    def ike_config_lifetime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ike_config_lifetime", value)

    @property
    @pulumi.getter(name="ikeConfigLocalId")
    def ike_config_local_id(self) -> Optional[pulumi.Input[str]]:
        """
        The local_id of the ike config of the VPN connection.
        """
        return pulumi.get(self, "ike_config_local_id")

    @ike_config_local_id.setter
    def ike_config_local_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ike_config_local_id", value)

    @property
    @pulumi.getter(name="ikeConfigMode")
    def ike_config_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The mode of the ike config of the VPN connection. Valid values are `main`, `aggressive`, and default value is `main`.
        """
        return pulumi.get(self, "ike_config_mode")

    @ike_config_mode.setter
    def ike_config_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ike_config_mode", value)

    @property
    @pulumi.getter(name="ikeConfigPsk")
    def ike_config_psk(self) -> Optional[pulumi.Input[str]]:
        """
        The psk of the ike config of the VPN connection. The length does not exceed 100 characters, and only uppercase and lowercase letters, special symbols and numbers are allowed.
        """
        return pulumi.get(self, "ike_config_psk")

    @ike_config_psk.setter
    def ike_config_psk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ike_config_psk", value)

    @property
    @pulumi.getter(name="ikeConfigRemoteId")
    def ike_config_remote_id(self) -> Optional[pulumi.Input[str]]:
        """
        The remote id of the ike config of the VPN connection.
        """
        return pulumi.get(self, "ike_config_remote_id")

    @ike_config_remote_id.setter
    def ike_config_remote_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ike_config_remote_id", value)

    @property
    @pulumi.getter(name="ikeConfigVersion")
    def ike_config_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the ike config of the VPN connection. The value can be `ikev1` or `ikev2`. The default value is `ikev1`.
        """
        return pulumi.get(self, "ike_config_version")

    @ike_config_version.setter
    def ike_config_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ike_config_version", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The ip address of transit router, valid when the attach type is 'TransitRouter'.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipsecConfigAuthAlg")
    def ipsec_config_auth_alg(self) -> Optional[pulumi.Input[str]]:
        """
        The auth alg of the ipsec config of the VPN connection. Valid value are `sha1`, `md5`, `sha256`, `sha384`, `sha512`, `sm3`. The default value is `sha1`.
        """
        return pulumi.get(self, "ipsec_config_auth_alg")

    @ipsec_config_auth_alg.setter
    def ipsec_config_auth_alg(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipsec_config_auth_alg", value)

    @property
    @pulumi.getter(name="ipsecConfigDhGroup")
    def ipsec_config_dh_group(self) -> Optional[pulumi.Input[str]]:
        """
        The dh group of the ipsec config of the VPN connection. Valid value are `group1`, `group2`, `group5`, `group14` and `disable`. The default value is `group2`.
        """
        return pulumi.get(self, "ipsec_config_dh_group")

    @ipsec_config_dh_group.setter
    def ipsec_config_dh_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipsec_config_dh_group", value)

    @property
    @pulumi.getter(name="ipsecConfigEncAlg")
    def ipsec_config_enc_alg(self) -> Optional[pulumi.Input[str]]:
        """
        The enc alg of the ipsec config of the VPN connection. Valid value are `aes`, `aes192`, `aes256`, `des`, `3des`, `sm4`. The default value is `aes`.
        """
        return pulumi.get(self, "ipsec_config_enc_alg")

    @ipsec_config_enc_alg.setter
    def ipsec_config_enc_alg(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipsec_config_enc_alg", value)

    @property
    @pulumi.getter(name="ipsecConfigLifetime")
    def ipsec_config_lifetime(self) -> Optional[pulumi.Input[int]]:
        """
        The ipsec config of the ike config of the VPN connection. Value: 900~86400.
        """
        return pulumi.get(self, "ipsec_config_lifetime")

    @ipsec_config_lifetime.setter
    def ipsec_config_lifetime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipsec_config_lifetime", value)

    @property
    @pulumi.getter(name="localSubnets")
    def local_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The local subnet of the VPN connection. Up to 5 network segments are supported.
        """
        return pulumi.get(self, "local_subnets")

    @local_subnets.setter
    def local_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "local_subnets", value)

    @property
    @pulumi.getter(name="logEnabled")
    def log_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable connection logging. After enabling Connection Day, you can view and download IPsec connection logs, and use the log information to troubleshoot IPsec connection problems yourself.
        """
        return pulumi.get(self, "log_enabled")

    @log_enabled.setter
    def log_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "log_enabled", value)

    @property
    @pulumi.getter(name="natTraversal")
    def nat_traversal(self) -> Optional[pulumi.Input[bool]]:
        """
        The nat traversal of the VPN connection.
        """
        return pulumi.get(self, "nat_traversal")

    @nat_traversal.setter
    def nat_traversal(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "nat_traversal", value)

    @property
    @pulumi.getter(name="negotiateInstantly")
    def negotiate_instantly(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to initiate negotiation mode immediately.
        """
        return pulumi.get(self, "negotiate_instantly")

    @negotiate_instantly.setter
    def negotiate_instantly(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negotiate_instantly", value)

    @property
    @pulumi.getter(name="overdueTime")
    def overdue_time(self) -> Optional[pulumi.Input[str]]:
        """
        The overdue time of resource, valid when the attach type is 'TransitRouter'.
        """
        return pulumi.get(self, "overdue_time")

    @overdue_time.setter
    def overdue_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "overdue_time", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name of the VPN connection.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="remoteSubnets")
    def remote_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The remote subnet of the VPN connection. Up to 5 network segments are supported.
        """
        return pulumi.get(self, "remote_subnets")

    @remote_subnets.setter
    def remote_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "remote_subnets", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the VPN connection.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of transit router, valid when the attach type is 'TransitRouter'.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_id", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The update time of VPN connection.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="vpnConnectionId")
    def vpn_connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPN connection.
        """
        return pulumi.get(self, "vpn_connection_id")

    @vpn_connection_id.setter
    def vpn_connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_connection_id", value)

    @property
    @pulumi.getter(name="vpnConnectionName")
    def vpn_connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPN connection.
        """
        return pulumi.get(self, "vpn_connection_name")

    @vpn_connection_name.setter
    def vpn_connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_connection_name", value)

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the vpn gateway. If the `AttachType` is not passed or the passed value is `VpnGateway`, this parameter must be filled. If the value of `AttachType` is `TransitRouter`, this parameter does not need to be filled.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @vpn_gateway_id.setter
    def vpn_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_gateway_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone id of transit router, valid when the attach type is 'TransitRouter'.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class Connection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attach_type: Optional[pulumi.Input[str]] = None,
                 customer_gateway_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dpd_action: Optional[pulumi.Input[str]] = None,
                 ike_config_auth_alg: Optional[pulumi.Input[str]] = None,
                 ike_config_dh_group: Optional[pulumi.Input[str]] = None,
                 ike_config_enc_alg: Optional[pulumi.Input[str]] = None,
                 ike_config_lifetime: Optional[pulumi.Input[int]] = None,
                 ike_config_local_id: Optional[pulumi.Input[str]] = None,
                 ike_config_mode: Optional[pulumi.Input[str]] = None,
                 ike_config_psk: Optional[pulumi.Input[str]] = None,
                 ike_config_remote_id: Optional[pulumi.Input[str]] = None,
                 ike_config_version: Optional[pulumi.Input[str]] = None,
                 ipsec_config_auth_alg: Optional[pulumi.Input[str]] = None,
                 ipsec_config_dh_group: Optional[pulumi.Input[str]] = None,
                 ipsec_config_enc_alg: Optional[pulumi.Input[str]] = None,
                 ipsec_config_lifetime: Optional[pulumi.Input[int]] = None,
                 local_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_enabled: Optional[pulumi.Input[bool]] = None,
                 nat_traversal: Optional[pulumi.Input[bool]] = None,
                 negotiate_instantly: Optional[pulumi.Input[bool]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 remote_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpn_connection_name: Optional[pulumi.Input[str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage vpn connection
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id="cn-beijing-a",
            vpc_id=foo_vpc.id)
        foo_gateway = volcengine.vpn.Gateway("fooGateway",
            vpc_id=foo_vpc.id,
            subnet_id=foo_subnet.id,
            bandwidth=20,
            vpn_gateway_name="acc-test",
            description="acc-test",
            period=2,
            project_name="default")
        foo_customer_gateway = volcengine.vpn.CustomerGateway("fooCustomerGateway",
            ip_address="192.0.1.3",
            customer_gateway_name="acc-test",
            description="acc-test",
            project_name="default")
        foo_connection = volcengine.vpn.Connection("fooConnection",
            vpn_connection_name="acc-tf-test",
            description="acc-tf-test",
            vpn_gateway_id=foo_gateway.id,
            customer_gateway_id=foo_customer_gateway.id,
            local_subnets=["192.168.0.0/22"],
            remote_subnets=["192.161.0.0/20"],
            dpd_action="none",
            nat_traversal=True,
            ike_config_psk="acctest@!3",
            ike_config_version="ikev1",
            ike_config_mode="main",
            ike_config_enc_alg="aes",
            ike_config_auth_alg="md5",
            ike_config_dh_group="group2",
            ike_config_lifetime=9000,
            ike_config_local_id="acc_test",
            ike_config_remote_id="acc_test",
            ipsec_config_enc_alg="aes",
            ipsec_config_auth_alg="sha256",
            ipsec_config_dh_group="group2",
            ipsec_config_lifetime=9000,
            project_name="default")
        ```

        ## Import

        VpnConnection can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpn/connection:Connection default vgc-3tex2x1cwd4c6c0v****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] attach_type: The attach type of the VPN connection, the value can be `VpnGateway` or `TransitRouter`.
        :param pulumi.Input[str] customer_gateway_id: The ID of the customer gateway.
        :param pulumi.Input[str] description: The description of the VPN connection.
        :param pulumi.Input[str] dpd_action: The dpd action of the VPN connection.
        :param pulumi.Input[str] ike_config_auth_alg: The auth alg of the ike config of the VPN connection. Valid value are `sha1`, `md5`, `sha256`, `sha384`, `sha512`, `sm3`. The default value is `sha1`.
        :param pulumi.Input[str] ike_config_dh_group: The dk group of the ike config of the VPN connection. Valid value are `group1`, `group2`, `group5`, `group14`. The default value is `group2`.
        :param pulumi.Input[str] ike_config_enc_alg: The enc alg of the ike config of the VPN connection. Valid value are `aes`, `aes192`, `aes256`, `des`, `3des`, `sm4`. The default value is `aes`.
        :param pulumi.Input[int] ike_config_lifetime: The lifetime of the ike config of the VPN connection. Value: 900~86400.
        :param pulumi.Input[str] ike_config_local_id: The local_id of the ike config of the VPN connection.
        :param pulumi.Input[str] ike_config_mode: The mode of the ike config of the VPN connection. Valid values are `main`, `aggressive`, and default value is `main`.
        :param pulumi.Input[str] ike_config_psk: The psk of the ike config of the VPN connection. The length does not exceed 100 characters, and only uppercase and lowercase letters, special symbols and numbers are allowed.
        :param pulumi.Input[str] ike_config_remote_id: The remote id of the ike config of the VPN connection.
        :param pulumi.Input[str] ike_config_version: The version of the ike config of the VPN connection. The value can be `ikev1` or `ikev2`. The default value is `ikev1`.
        :param pulumi.Input[str] ipsec_config_auth_alg: The auth alg of the ipsec config of the VPN connection. Valid value are `sha1`, `md5`, `sha256`, `sha384`, `sha512`, `sm3`. The default value is `sha1`.
        :param pulumi.Input[str] ipsec_config_dh_group: The dh group of the ipsec config of the VPN connection. Valid value are `group1`, `group2`, `group5`, `group14` and `disable`. The default value is `group2`.
        :param pulumi.Input[str] ipsec_config_enc_alg: The enc alg of the ipsec config of the VPN connection. Valid value are `aes`, `aes192`, `aes256`, `des`, `3des`, `sm4`. The default value is `aes`.
        :param pulumi.Input[int] ipsec_config_lifetime: The ipsec config of the ike config of the VPN connection. Value: 900~86400.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_subnets: The local subnet of the VPN connection. Up to 5 network segments are supported.
        :param pulumi.Input[bool] log_enabled: Whether to enable connection logging. After enabling Connection Day, you can view and download IPsec connection logs, and use the log information to troubleshoot IPsec connection problems yourself.
        :param pulumi.Input[bool] nat_traversal: The nat traversal of the VPN connection.
        :param pulumi.Input[bool] negotiate_instantly: Whether to initiate negotiation mode immediately.
        :param pulumi.Input[str] project_name: The project name of the VPN connection.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_subnets: The remote subnet of the VPN connection. Up to 5 network segments are supported.
        :param pulumi.Input[str] vpn_connection_name: The name of the VPN connection.
        :param pulumi.Input[str] vpn_gateway_id: The ID of the vpn gateway. If the `AttachType` is not passed or the passed value is `VpnGateway`, this parameter must be filled. If the value of `AttachType` is `TransitRouter`, this parameter does not need to be filled.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage vpn connection
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id="cn-beijing-a",
            vpc_id=foo_vpc.id)
        foo_gateway = volcengine.vpn.Gateway("fooGateway",
            vpc_id=foo_vpc.id,
            subnet_id=foo_subnet.id,
            bandwidth=20,
            vpn_gateway_name="acc-test",
            description="acc-test",
            period=2,
            project_name="default")
        foo_customer_gateway = volcengine.vpn.CustomerGateway("fooCustomerGateway",
            ip_address="192.0.1.3",
            customer_gateway_name="acc-test",
            description="acc-test",
            project_name="default")
        foo_connection = volcengine.vpn.Connection("fooConnection",
            vpn_connection_name="acc-tf-test",
            description="acc-tf-test",
            vpn_gateway_id=foo_gateway.id,
            customer_gateway_id=foo_customer_gateway.id,
            local_subnets=["192.168.0.0/22"],
            remote_subnets=["192.161.0.0/20"],
            dpd_action="none",
            nat_traversal=True,
            ike_config_psk="acctest@!3",
            ike_config_version="ikev1",
            ike_config_mode="main",
            ike_config_enc_alg="aes",
            ike_config_auth_alg="md5",
            ike_config_dh_group="group2",
            ike_config_lifetime=9000,
            ike_config_local_id="acc_test",
            ike_config_remote_id="acc_test",
            ipsec_config_enc_alg="aes",
            ipsec_config_auth_alg="sha256",
            ipsec_config_dh_group="group2",
            ipsec_config_lifetime=9000,
            project_name="default")
        ```

        ## Import

        VpnConnection can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpn/connection:Connection default vgc-3tex2x1cwd4c6c0v****
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attach_type: Optional[pulumi.Input[str]] = None,
                 customer_gateway_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dpd_action: Optional[pulumi.Input[str]] = None,
                 ike_config_auth_alg: Optional[pulumi.Input[str]] = None,
                 ike_config_dh_group: Optional[pulumi.Input[str]] = None,
                 ike_config_enc_alg: Optional[pulumi.Input[str]] = None,
                 ike_config_lifetime: Optional[pulumi.Input[int]] = None,
                 ike_config_local_id: Optional[pulumi.Input[str]] = None,
                 ike_config_mode: Optional[pulumi.Input[str]] = None,
                 ike_config_psk: Optional[pulumi.Input[str]] = None,
                 ike_config_remote_id: Optional[pulumi.Input[str]] = None,
                 ike_config_version: Optional[pulumi.Input[str]] = None,
                 ipsec_config_auth_alg: Optional[pulumi.Input[str]] = None,
                 ipsec_config_dh_group: Optional[pulumi.Input[str]] = None,
                 ipsec_config_enc_alg: Optional[pulumi.Input[str]] = None,
                 ipsec_config_lifetime: Optional[pulumi.Input[int]] = None,
                 local_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_enabled: Optional[pulumi.Input[bool]] = None,
                 nat_traversal: Optional[pulumi.Input[bool]] = None,
                 negotiate_instantly: Optional[pulumi.Input[bool]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 remote_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpn_connection_name: Optional[pulumi.Input[str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionArgs.__new__(ConnectionArgs)

            __props__.__dict__["attach_type"] = attach_type
            if customer_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'customer_gateway_id'")
            __props__.__dict__["customer_gateway_id"] = customer_gateway_id
            __props__.__dict__["description"] = description
            __props__.__dict__["dpd_action"] = dpd_action
            __props__.__dict__["ike_config_auth_alg"] = ike_config_auth_alg
            __props__.__dict__["ike_config_dh_group"] = ike_config_dh_group
            __props__.__dict__["ike_config_enc_alg"] = ike_config_enc_alg
            __props__.__dict__["ike_config_lifetime"] = ike_config_lifetime
            __props__.__dict__["ike_config_local_id"] = ike_config_local_id
            __props__.__dict__["ike_config_mode"] = ike_config_mode
            if ike_config_psk is None and not opts.urn:
                raise TypeError("Missing required property 'ike_config_psk'")
            __props__.__dict__["ike_config_psk"] = ike_config_psk
            __props__.__dict__["ike_config_remote_id"] = ike_config_remote_id
            __props__.__dict__["ike_config_version"] = ike_config_version
            __props__.__dict__["ipsec_config_auth_alg"] = ipsec_config_auth_alg
            __props__.__dict__["ipsec_config_dh_group"] = ipsec_config_dh_group
            __props__.__dict__["ipsec_config_enc_alg"] = ipsec_config_enc_alg
            __props__.__dict__["ipsec_config_lifetime"] = ipsec_config_lifetime
            if local_subnets is None and not opts.urn:
                raise TypeError("Missing required property 'local_subnets'")
            __props__.__dict__["local_subnets"] = local_subnets
            __props__.__dict__["log_enabled"] = log_enabled
            __props__.__dict__["nat_traversal"] = nat_traversal
            __props__.__dict__["negotiate_instantly"] = negotiate_instantly
            __props__.__dict__["project_name"] = project_name
            if remote_subnets is None and not opts.urn:
                raise TypeError("Missing required property 'remote_subnets'")
            __props__.__dict__["remote_subnets"] = remote_subnets
            __props__.__dict__["vpn_connection_name"] = vpn_connection_name
            __props__.__dict__["vpn_gateway_id"] = vpn_gateway_id
            __props__.__dict__["account_id"] = None
            __props__.__dict__["attach_status"] = None
            __props__.__dict__["business_status"] = None
            __props__.__dict__["connect_status"] = None
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["deleted_time"] = None
            __props__.__dict__["ip_address"] = None
            __props__.__dict__["overdue_time"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["transit_router_id"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["vpn_connection_id"] = None
            __props__.__dict__["zone_id"] = None
        super(Connection, __self__).__init__(
            'volcengine:vpn/connection:Connection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            attach_status: Optional[pulumi.Input[str]] = None,
            attach_type: Optional[pulumi.Input[str]] = None,
            business_status: Optional[pulumi.Input[str]] = None,
            connect_status: Optional[pulumi.Input[str]] = None,
            creation_time: Optional[pulumi.Input[str]] = None,
            customer_gateway_id: Optional[pulumi.Input[str]] = None,
            deleted_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dpd_action: Optional[pulumi.Input[str]] = None,
            ike_config_auth_alg: Optional[pulumi.Input[str]] = None,
            ike_config_dh_group: Optional[pulumi.Input[str]] = None,
            ike_config_enc_alg: Optional[pulumi.Input[str]] = None,
            ike_config_lifetime: Optional[pulumi.Input[int]] = None,
            ike_config_local_id: Optional[pulumi.Input[str]] = None,
            ike_config_mode: Optional[pulumi.Input[str]] = None,
            ike_config_psk: Optional[pulumi.Input[str]] = None,
            ike_config_remote_id: Optional[pulumi.Input[str]] = None,
            ike_config_version: Optional[pulumi.Input[str]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            ipsec_config_auth_alg: Optional[pulumi.Input[str]] = None,
            ipsec_config_dh_group: Optional[pulumi.Input[str]] = None,
            ipsec_config_enc_alg: Optional[pulumi.Input[str]] = None,
            ipsec_config_lifetime: Optional[pulumi.Input[int]] = None,
            local_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            log_enabled: Optional[pulumi.Input[bool]] = None,
            nat_traversal: Optional[pulumi.Input[bool]] = None,
            negotiate_instantly: Optional[pulumi.Input[bool]] = None,
            overdue_time: Optional[pulumi.Input[str]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            remote_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            transit_router_id: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            vpn_connection_id: Optional[pulumi.Input[str]] = None,
            vpn_connection_name: Optional[pulumi.Input[str]] = None,
            vpn_gateway_id: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'Connection':
        """
        Get an existing Connection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account ID of the VPN connection.
        :param pulumi.Input[str] attach_status: The IPsec attach status.
        :param pulumi.Input[str] attach_type: The attach type of the VPN connection, the value can be `VpnGateway` or `TransitRouter`.
        :param pulumi.Input[str] business_status: The business status of IPsec connection, valid when the attach type is 'TransitRouter'.
        :param pulumi.Input[str] connect_status: The connect status of the VPN connection.
        :param pulumi.Input[str] creation_time: The create time of VPN connection.
        :param pulumi.Input[str] customer_gateway_id: The ID of the customer gateway.
        :param pulumi.Input[str] deleted_time: The delete time of resource, valid when the attach type is 'TransitRouter'.
        :param pulumi.Input[str] description: The description of the VPN connection.
        :param pulumi.Input[str] dpd_action: The dpd action of the VPN connection.
        :param pulumi.Input[str] ike_config_auth_alg: The auth alg of the ike config of the VPN connection. Valid value are `sha1`, `md5`, `sha256`, `sha384`, `sha512`, `sm3`. The default value is `sha1`.
        :param pulumi.Input[str] ike_config_dh_group: The dk group of the ike config of the VPN connection. Valid value are `group1`, `group2`, `group5`, `group14`. The default value is `group2`.
        :param pulumi.Input[str] ike_config_enc_alg: The enc alg of the ike config of the VPN connection. Valid value are `aes`, `aes192`, `aes256`, `des`, `3des`, `sm4`. The default value is `aes`.
        :param pulumi.Input[int] ike_config_lifetime: The lifetime of the ike config of the VPN connection. Value: 900~86400.
        :param pulumi.Input[str] ike_config_local_id: The local_id of the ike config of the VPN connection.
        :param pulumi.Input[str] ike_config_mode: The mode of the ike config of the VPN connection. Valid values are `main`, `aggressive`, and default value is `main`.
        :param pulumi.Input[str] ike_config_psk: The psk of the ike config of the VPN connection. The length does not exceed 100 characters, and only uppercase and lowercase letters, special symbols and numbers are allowed.
        :param pulumi.Input[str] ike_config_remote_id: The remote id of the ike config of the VPN connection.
        :param pulumi.Input[str] ike_config_version: The version of the ike config of the VPN connection. The value can be `ikev1` or `ikev2`. The default value is `ikev1`.
        :param pulumi.Input[str] ip_address: The ip address of transit router, valid when the attach type is 'TransitRouter'.
        :param pulumi.Input[str] ipsec_config_auth_alg: The auth alg of the ipsec config of the VPN connection. Valid value are `sha1`, `md5`, `sha256`, `sha384`, `sha512`, `sm3`. The default value is `sha1`.
        :param pulumi.Input[str] ipsec_config_dh_group: The dh group of the ipsec config of the VPN connection. Valid value are `group1`, `group2`, `group5`, `group14` and `disable`. The default value is `group2`.
        :param pulumi.Input[str] ipsec_config_enc_alg: The enc alg of the ipsec config of the VPN connection. Valid value are `aes`, `aes192`, `aes256`, `des`, `3des`, `sm4`. The default value is `aes`.
        :param pulumi.Input[int] ipsec_config_lifetime: The ipsec config of the ike config of the VPN connection. Value: 900~86400.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_subnets: The local subnet of the VPN connection. Up to 5 network segments are supported.
        :param pulumi.Input[bool] log_enabled: Whether to enable connection logging. After enabling Connection Day, you can view and download IPsec connection logs, and use the log information to troubleshoot IPsec connection problems yourself.
        :param pulumi.Input[bool] nat_traversal: The nat traversal of the VPN connection.
        :param pulumi.Input[bool] negotiate_instantly: Whether to initiate negotiation mode immediately.
        :param pulumi.Input[str] overdue_time: The overdue time of resource, valid when the attach type is 'TransitRouter'.
        :param pulumi.Input[str] project_name: The project name of the VPN connection.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_subnets: The remote subnet of the VPN connection. Up to 5 network segments are supported.
        :param pulumi.Input[str] status: The status of the VPN connection.
        :param pulumi.Input[str] transit_router_id: The id of transit router, valid when the attach type is 'TransitRouter'.
        :param pulumi.Input[str] update_time: The update time of VPN connection.
        :param pulumi.Input[str] vpn_connection_id: The ID of the VPN connection.
        :param pulumi.Input[str] vpn_connection_name: The name of the VPN connection.
        :param pulumi.Input[str] vpn_gateway_id: The ID of the vpn gateway. If the `AttachType` is not passed or the passed value is `VpnGateway`, this parameter must be filled. If the value of `AttachType` is `TransitRouter`, this parameter does not need to be filled.
        :param pulumi.Input[str] zone_id: The zone id of transit router, valid when the attach type is 'TransitRouter'.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionState.__new__(_ConnectionState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["attach_status"] = attach_status
        __props__.__dict__["attach_type"] = attach_type
        __props__.__dict__["business_status"] = business_status
        __props__.__dict__["connect_status"] = connect_status
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["customer_gateway_id"] = customer_gateway_id
        __props__.__dict__["deleted_time"] = deleted_time
        __props__.__dict__["description"] = description
        __props__.__dict__["dpd_action"] = dpd_action
        __props__.__dict__["ike_config_auth_alg"] = ike_config_auth_alg
        __props__.__dict__["ike_config_dh_group"] = ike_config_dh_group
        __props__.__dict__["ike_config_enc_alg"] = ike_config_enc_alg
        __props__.__dict__["ike_config_lifetime"] = ike_config_lifetime
        __props__.__dict__["ike_config_local_id"] = ike_config_local_id
        __props__.__dict__["ike_config_mode"] = ike_config_mode
        __props__.__dict__["ike_config_psk"] = ike_config_psk
        __props__.__dict__["ike_config_remote_id"] = ike_config_remote_id
        __props__.__dict__["ike_config_version"] = ike_config_version
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["ipsec_config_auth_alg"] = ipsec_config_auth_alg
        __props__.__dict__["ipsec_config_dh_group"] = ipsec_config_dh_group
        __props__.__dict__["ipsec_config_enc_alg"] = ipsec_config_enc_alg
        __props__.__dict__["ipsec_config_lifetime"] = ipsec_config_lifetime
        __props__.__dict__["local_subnets"] = local_subnets
        __props__.__dict__["log_enabled"] = log_enabled
        __props__.__dict__["nat_traversal"] = nat_traversal
        __props__.__dict__["negotiate_instantly"] = negotiate_instantly
        __props__.__dict__["overdue_time"] = overdue_time
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["remote_subnets"] = remote_subnets
        __props__.__dict__["status"] = status
        __props__.__dict__["transit_router_id"] = transit_router_id
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["vpn_connection_id"] = vpn_connection_id
        __props__.__dict__["vpn_connection_name"] = vpn_connection_name
        __props__.__dict__["vpn_gateway_id"] = vpn_gateway_id
        __props__.__dict__["zone_id"] = zone_id
        return Connection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The account ID of the VPN connection.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="attachStatus")
    def attach_status(self) -> pulumi.Output[str]:
        """
        The IPsec attach status.
        """
        return pulumi.get(self, "attach_status")

    @property
    @pulumi.getter(name="attachType")
    def attach_type(self) -> pulumi.Output[Optional[str]]:
        """
        The attach type of the VPN connection, the value can be `VpnGateway` or `TransitRouter`.
        """
        return pulumi.get(self, "attach_type")

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> pulumi.Output[str]:
        """
        The business status of IPsec connection, valid when the attach type is 'TransitRouter'.
        """
        return pulumi.get(self, "business_status")

    @property
    @pulumi.getter(name="connectStatus")
    def connect_status(self) -> pulumi.Output[str]:
        """
        The connect status of the VPN connection.
        """
        return pulumi.get(self, "connect_status")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        The create time of VPN connection.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> pulumi.Output[str]:
        """
        The ID of the customer gateway.
        """
        return pulumi.get(self, "customer_gateway_id")

    @property
    @pulumi.getter(name="deletedTime")
    def deleted_time(self) -> pulumi.Output[str]:
        """
        The delete time of resource, valid when the attach type is 'TransitRouter'.
        """
        return pulumi.get(self, "deleted_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the VPN connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dpdAction")
    def dpd_action(self) -> pulumi.Output[Optional[str]]:
        """
        The dpd action of the VPN connection.
        """
        return pulumi.get(self, "dpd_action")

    @property
    @pulumi.getter(name="ikeConfigAuthAlg")
    def ike_config_auth_alg(self) -> pulumi.Output[Optional[str]]:
        """
        The auth alg of the ike config of the VPN connection. Valid value are `sha1`, `md5`, `sha256`, `sha384`, `sha512`, `sm3`. The default value is `sha1`.
        """
        return pulumi.get(self, "ike_config_auth_alg")

    @property
    @pulumi.getter(name="ikeConfigDhGroup")
    def ike_config_dh_group(self) -> pulumi.Output[Optional[str]]:
        """
        The dk group of the ike config of the VPN connection. Valid value are `group1`, `group2`, `group5`, `group14`. The default value is `group2`.
        """
        return pulumi.get(self, "ike_config_dh_group")

    @property
    @pulumi.getter(name="ikeConfigEncAlg")
    def ike_config_enc_alg(self) -> pulumi.Output[Optional[str]]:
        """
        The enc alg of the ike config of the VPN connection. Valid value are `aes`, `aes192`, `aes256`, `des`, `3des`, `sm4`. The default value is `aes`.
        """
        return pulumi.get(self, "ike_config_enc_alg")

    @property
    @pulumi.getter(name="ikeConfigLifetime")
    def ike_config_lifetime(self) -> pulumi.Output[Optional[int]]:
        """
        The lifetime of the ike config of the VPN connection. Value: 900~86400.
        """
        return pulumi.get(self, "ike_config_lifetime")

    @property
    @pulumi.getter(name="ikeConfigLocalId")
    def ike_config_local_id(self) -> pulumi.Output[str]:
        """
        The local_id of the ike config of the VPN connection.
        """
        return pulumi.get(self, "ike_config_local_id")

    @property
    @pulumi.getter(name="ikeConfigMode")
    def ike_config_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The mode of the ike config of the VPN connection. Valid values are `main`, `aggressive`, and default value is `main`.
        """
        return pulumi.get(self, "ike_config_mode")

    @property
    @pulumi.getter(name="ikeConfigPsk")
    def ike_config_psk(self) -> pulumi.Output[str]:
        """
        The psk of the ike config of the VPN connection. The length does not exceed 100 characters, and only uppercase and lowercase letters, special symbols and numbers are allowed.
        """
        return pulumi.get(self, "ike_config_psk")

    @property
    @pulumi.getter(name="ikeConfigRemoteId")
    def ike_config_remote_id(self) -> pulumi.Output[str]:
        """
        The remote id of the ike config of the VPN connection.
        """
        return pulumi.get(self, "ike_config_remote_id")

    @property
    @pulumi.getter(name="ikeConfigVersion")
    def ike_config_version(self) -> pulumi.Output[Optional[str]]:
        """
        The version of the ike config of the VPN connection. The value can be `ikev1` or `ikev2`. The default value is `ikev1`.
        """
        return pulumi.get(self, "ike_config_version")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        The ip address of transit router, valid when the attach type is 'TransitRouter'.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipsecConfigAuthAlg")
    def ipsec_config_auth_alg(self) -> pulumi.Output[Optional[str]]:
        """
        The auth alg of the ipsec config of the VPN connection. Valid value are `sha1`, `md5`, `sha256`, `sha384`, `sha512`, `sm3`. The default value is `sha1`.
        """
        return pulumi.get(self, "ipsec_config_auth_alg")

    @property
    @pulumi.getter(name="ipsecConfigDhGroup")
    def ipsec_config_dh_group(self) -> pulumi.Output[Optional[str]]:
        """
        The dh group of the ipsec config of the VPN connection. Valid value are `group1`, `group2`, `group5`, `group14` and `disable`. The default value is `group2`.
        """
        return pulumi.get(self, "ipsec_config_dh_group")

    @property
    @pulumi.getter(name="ipsecConfigEncAlg")
    def ipsec_config_enc_alg(self) -> pulumi.Output[Optional[str]]:
        """
        The enc alg of the ipsec config of the VPN connection. Valid value are `aes`, `aes192`, `aes256`, `des`, `3des`, `sm4`. The default value is `aes`.
        """
        return pulumi.get(self, "ipsec_config_enc_alg")

    @property
    @pulumi.getter(name="ipsecConfigLifetime")
    def ipsec_config_lifetime(self) -> pulumi.Output[Optional[int]]:
        """
        The ipsec config of the ike config of the VPN connection. Value: 900~86400.
        """
        return pulumi.get(self, "ipsec_config_lifetime")

    @property
    @pulumi.getter(name="localSubnets")
    def local_subnets(self) -> pulumi.Output[Sequence[str]]:
        """
        The local subnet of the VPN connection. Up to 5 network segments are supported.
        """
        return pulumi.get(self, "local_subnets")

    @property
    @pulumi.getter(name="logEnabled")
    def log_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable connection logging. After enabling Connection Day, you can view and download IPsec connection logs, and use the log information to troubleshoot IPsec connection problems yourself.
        """
        return pulumi.get(self, "log_enabled")

    @property
    @pulumi.getter(name="natTraversal")
    def nat_traversal(self) -> pulumi.Output[Optional[bool]]:
        """
        The nat traversal of the VPN connection.
        """
        return pulumi.get(self, "nat_traversal")

    @property
    @pulumi.getter(name="negotiateInstantly")
    def negotiate_instantly(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to initiate negotiation mode immediately.
        """
        return pulumi.get(self, "negotiate_instantly")

    @property
    @pulumi.getter(name="overdueTime")
    def overdue_time(self) -> pulumi.Output[str]:
        """
        The overdue time of resource, valid when the attach type is 'TransitRouter'.
        """
        return pulumi.get(self, "overdue_time")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        The project name of the VPN connection.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="remoteSubnets")
    def remote_subnets(self) -> pulumi.Output[Sequence[str]]:
        """
        The remote subnet of the VPN connection. Up to 5 network segments are supported.
        """
        return pulumi.get(self, "remote_subnets")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the VPN connection.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Output[str]:
        """
        The id of transit router, valid when the attach type is 'TransitRouter'.
        """
        return pulumi.get(self, "transit_router_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The update time of VPN connection.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vpnConnectionId")
    def vpn_connection_id(self) -> pulumi.Output[str]:
        """
        The ID of the VPN connection.
        """
        return pulumi.get(self, "vpn_connection_id")

    @property
    @pulumi.getter(name="vpnConnectionName")
    def vpn_connection_name(self) -> pulumi.Output[str]:
        """
        The name of the VPN connection.
        """
        return pulumi.get(self, "vpn_connection_name")

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the vpn gateway. If the `AttachType` is not passed or the passed value is `VpnGateway`, this parameter must be filled. If the value of `AttachType` is `TransitRouter`, this parameter does not need to be filled.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone id of transit router, valid when the attach type is 'TransitRouter'.
        """
        return pulumi.get(self, "zone_id")

