# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['CustomerGatewayArgs', 'CustomerGateway']

@pulumi.input_type
class CustomerGatewayArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[str],
                 customer_gateway_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CustomerGateway resource.
        :param pulumi.Input[str] ip_address: The IP address of the customer gateway.
        :param pulumi.Input[str] customer_gateway_name: The name of the customer gateway.
        :param pulumi.Input[str] description: The description of the customer gateway.
        :param pulumi.Input[str] project_name: The project name of the VPN customer gateway.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        if customer_gateway_name is not None:
            pulumi.set(__self__, "customer_gateway_name", customer_gateway_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The IP address of the customer gateway.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="customerGatewayName")
    def customer_gateway_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the customer gateway.
        """
        return pulumi.get(self, "customer_gateway_name")

    @customer_gateway_name.setter
    def customer_gateway_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_gateway_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the customer gateway.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name of the VPN customer gateway.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)


@pulumi.input_type
class _CustomerGatewayState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 connection_count: Optional[pulumi.Input[int]] = None,
                 creation_time: Optional[pulumi.Input[str]] = None,
                 customer_gateway_id: Optional[pulumi.Input[str]] = None,
                 customer_gateway_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CustomerGateway resources.
        :param pulumi.Input[str] account_id: The account ID of the customer gateway.
        :param pulumi.Input[int] connection_count: The connection count of the customer gateway.
        :param pulumi.Input[str] creation_time: The create time of customer gateway.
        :param pulumi.Input[str] customer_gateway_id: The ID of the customer gateway.
        :param pulumi.Input[str] customer_gateway_name: The name of the customer gateway.
        :param pulumi.Input[str] description: The description of the customer gateway.
        :param pulumi.Input[str] ip_address: The IP address of the customer gateway.
        :param pulumi.Input[str] project_name: The project name of the VPN customer gateway.
        :param pulumi.Input[str] status: The status of the customer gateway.
        :param pulumi.Input[str] update_time: The update time of customer gateway.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if connection_count is not None:
            pulumi.set(__self__, "connection_count", connection_count)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if customer_gateway_id is not None:
            pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        if customer_gateway_name is not None:
            pulumi.set(__self__, "customer_gateway_name", customer_gateway_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account ID of the customer gateway.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="connectionCount")
    def connection_count(self) -> Optional[pulumi.Input[int]]:
        """
        The connection count of the customer gateway.
        """
        return pulumi.get(self, "connection_count")

    @connection_count.setter
    def connection_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connection_count", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        The create time of customer gateway.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the customer gateway.
        """
        return pulumi.get(self, "customer_gateway_id")

    @customer_gateway_id.setter
    def customer_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_gateway_id", value)

    @property
    @pulumi.getter(name="customerGatewayName")
    def customer_gateway_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the customer gateway.
        """
        return pulumi.get(self, "customer_gateway_name")

    @customer_gateway_name.setter
    def customer_gateway_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_gateway_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the customer gateway.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the customer gateway.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name of the VPN customer gateway.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the customer gateway.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The update time of customer gateway.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class CustomerGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_gateway_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage customer gateway
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.vpn.CustomerGateway("foo",
            customer_gateway_name="acc-test",
            description="acc-test",
            ip_address="192.0.1.3",
            project_name="default")
        ```

        ## Import

        CustomerGateway can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpn/customerGateway:CustomerGateway default cgw-2byswc356dybk2dx0eed2****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] customer_gateway_name: The name of the customer gateway.
        :param pulumi.Input[str] description: The description of the customer gateway.
        :param pulumi.Input[str] ip_address: The IP address of the customer gateway.
        :param pulumi.Input[str] project_name: The project name of the VPN customer gateway.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomerGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage customer gateway
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.vpn.CustomerGateway("foo",
            customer_gateway_name="acc-test",
            description="acc-test",
            ip_address="192.0.1.3",
            project_name="default")
        ```

        ## Import

        CustomerGateway can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpn/customerGateway:CustomerGateway default cgw-2byswc356dybk2dx0eed2****
        ```

        :param str resource_name: The name of the resource.
        :param CustomerGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomerGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_gateway_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomerGatewayArgs.__new__(CustomerGatewayArgs)

            __props__.__dict__["customer_gateway_name"] = customer_gateway_name
            __props__.__dict__["description"] = description
            if ip_address is None and not opts.urn:
                raise TypeError("Missing required property 'ip_address'")
            __props__.__dict__["ip_address"] = ip_address
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["account_id"] = None
            __props__.__dict__["connection_count"] = None
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["customer_gateway_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["update_time"] = None
        super(CustomerGateway, __self__).__init__(
            'volcengine:vpn/customerGateway:CustomerGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            connection_count: Optional[pulumi.Input[int]] = None,
            creation_time: Optional[pulumi.Input[str]] = None,
            customer_gateway_id: Optional[pulumi.Input[str]] = None,
            customer_gateway_name: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'CustomerGateway':
        """
        Get an existing CustomerGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account ID of the customer gateway.
        :param pulumi.Input[int] connection_count: The connection count of the customer gateway.
        :param pulumi.Input[str] creation_time: The create time of customer gateway.
        :param pulumi.Input[str] customer_gateway_id: The ID of the customer gateway.
        :param pulumi.Input[str] customer_gateway_name: The name of the customer gateway.
        :param pulumi.Input[str] description: The description of the customer gateway.
        :param pulumi.Input[str] ip_address: The IP address of the customer gateway.
        :param pulumi.Input[str] project_name: The project name of the VPN customer gateway.
        :param pulumi.Input[str] status: The status of the customer gateway.
        :param pulumi.Input[str] update_time: The update time of customer gateway.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomerGatewayState.__new__(_CustomerGatewayState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["connection_count"] = connection_count
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["customer_gateway_id"] = customer_gateway_id
        __props__.__dict__["customer_gateway_name"] = customer_gateway_name
        __props__.__dict__["description"] = description
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["status"] = status
        __props__.__dict__["update_time"] = update_time
        return CustomerGateway(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The account ID of the customer gateway.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="connectionCount")
    def connection_count(self) -> pulumi.Output[int]:
        """
        The connection count of the customer gateway.
        """
        return pulumi.get(self, "connection_count")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        The create time of customer gateway.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> pulumi.Output[str]:
        """
        The ID of the customer gateway.
        """
        return pulumi.get(self, "customer_gateway_id")

    @property
    @pulumi.getter(name="customerGatewayName")
    def customer_gateway_name(self) -> pulumi.Output[str]:
        """
        The name of the customer gateway.
        """
        return pulumi.get(self, "customer_gateway_name")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the customer gateway.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        The IP address of the customer gateway.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        The project name of the VPN customer gateway.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the customer gateway.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The update time of customer gateway.
        """
        return pulumi.get(self, "update_time")

