# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GatewayArgs', 'Gateway']

@pulumi.input_type
class GatewayArgs:
    def __init__(__self__, *,
                 bandwidth: pulumi.Input[int],
                 subnet_id: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 billing_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ipsec_enabled: Optional[pulumi.Input[bool]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 ssl_enabled: Optional[pulumi.Input[bool]] = None,
                 ssl_max_connections: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayTagArgs']]]] = None,
                 vpn_gateway_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Gateway resource.
        :param pulumi.Input[int] bandwidth: The bandwidth of the VPN gateway. Unit: Mbps. Values: 5, 10, 20, 50, 100, 200, 500.
        :param pulumi.Input[str] subnet_id: The ID of the subnet where you want to create the VPN gateway.
        :param pulumi.Input[str] vpc_id: The ID of the VPC where you want to create the VPN gateway.
        :param pulumi.Input[str] billing_type: The BillingType of the VPN gateway. Only support `PrePaid`. Terraform will only remove the PrePaid VPN gateway from the
               state file, not actually remove.
        :param pulumi.Input[str] description: The description of the VPN gateway.
        :param pulumi.Input[bool] ipsec_enabled: Whether ipsec is enabled.
        :param pulumi.Input[int] period: The Period of the VPN gateway. Default value is 12. This parameter is only useful when creating vpn gateway. Default period unit is Month.
               Value range: 1~9, 12, 24, 36. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] project_name: The project name of the VPN gateway.
        :param pulumi.Input[bool] ssl_enabled: Whether ssl is enabled.
        :param pulumi.Input[int] ssl_max_connections: The max connections of ssl. This parameter can only be passed in when ssl_enabled is true. Default is 5.
        :param pulumi.Input[Sequence[pulumi.Input['GatewayTagArgs']]] tags: Tags.
        :param pulumi.Input[str] vpn_gateway_name: The name of the VPN gateway.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if billing_type is not None:
            pulumi.set(__self__, "billing_type", billing_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ipsec_enabled is not None:
            pulumi.set(__self__, "ipsec_enabled", ipsec_enabled)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if ssl_enabled is not None:
            pulumi.set(__self__, "ssl_enabled", ssl_enabled)
        if ssl_max_connections is not None:
            pulumi.set(__self__, "ssl_max_connections", ssl_max_connections)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpn_gateway_name is not None:
            pulumi.set(__self__, "vpn_gateway_name", vpn_gateway_name)

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Input[int]:
        """
        The bandwidth of the VPN gateway. Unit: Mbps. Values: 5, 10, 20, 50, 100, 200, 500.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: pulumi.Input[int]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The ID of the subnet where you want to create the VPN gateway.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        The ID of the VPC where you want to create the VPN gateway.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> Optional[pulumi.Input[str]]:
        """
        The BillingType of the VPN gateway. Only support `PrePaid`. Terraform will only remove the PrePaid VPN gateway from the
        state file, not actually remove.
        """
        return pulumi.get(self, "billing_type")

    @billing_type.setter
    def billing_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "billing_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the VPN gateway.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ipsecEnabled")
    def ipsec_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether ipsec is enabled.
        """
        return pulumi.get(self, "ipsec_enabled")

    @ipsec_enabled.setter
    def ipsec_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipsec_enabled", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The Period of the VPN gateway. Default value is 12. This parameter is only useful when creating vpn gateway. Default period unit is Month.
        Value range: 1~9, 12, 24, 36. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name of the VPN gateway.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether ssl is enabled.
        """
        return pulumi.get(self, "ssl_enabled")

    @ssl_enabled.setter
    def ssl_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl_enabled", value)

    @property
    @pulumi.getter(name="sslMaxConnections")
    def ssl_max_connections(self) -> Optional[pulumi.Input[int]]:
        """
        The max connections of ssl. This parameter can only be passed in when ssl_enabled is true. Default is 5.
        """
        return pulumi.get(self, "ssl_max_connections")

    @ssl_max_connections.setter
    def ssl_max_connections(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ssl_max_connections", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GatewayTagArgs']]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpnGatewayName")
    def vpn_gateway_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPN gateway.
        """
        return pulumi.get(self, "vpn_gateway_name")

    @vpn_gateway_name.setter
    def vpn_gateway_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_gateway_name", value)


@pulumi.input_type
class _GatewayState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 billing_type: Optional[pulumi.Input[str]] = None,
                 business_status: Optional[pulumi.Input[str]] = None,
                 connection_count: Optional[pulumi.Input[int]] = None,
                 creation_time: Optional[pulumi.Input[str]] = None,
                 deleted_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expired_time: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ipsec_enabled: Optional[pulumi.Input[bool]] = None,
                 lock_reason: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 renew_type: Optional[pulumi.Input[str]] = None,
                 route_count: Optional[pulumi.Input[int]] = None,
                 ssl_enabled: Optional[pulumi.Input[bool]] = None,
                 ssl_max_connections: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayTagArgs']]]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[str]] = None,
                 vpn_gateway_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Gateway resources.
        :param pulumi.Input[str] account_id: The account ID of the VPN gateway.
        :param pulumi.Input[int] bandwidth: The bandwidth of the VPN gateway. Unit: Mbps. Values: 5, 10, 20, 50, 100, 200, 500.
        :param pulumi.Input[str] billing_type: The BillingType of the VPN gateway. Only support `PrePaid`. Terraform will only remove the PrePaid VPN gateway from the
               state file, not actually remove.
        :param pulumi.Input[str] business_status: The business status of the VPN gateway.
        :param pulumi.Input[int] connection_count: The connection count of the VPN gateway.
        :param pulumi.Input[str] creation_time: The create time of VPN gateway.
        :param pulumi.Input[str] deleted_time: The deleted time of the VPN gateway.
        :param pulumi.Input[str] description: The description of the VPN gateway.
        :param pulumi.Input[str] expired_time: The expired time of the VPN gateway.
        :param pulumi.Input[str] ip_address: The IP address of the VPN gateway.
        :param pulumi.Input[bool] ipsec_enabled: Whether ipsec is enabled.
        :param pulumi.Input[str] lock_reason: The lock reason of the VPN gateway.
        :param pulumi.Input[int] period: The Period of the VPN gateway. Default value is 12. This parameter is only useful when creating vpn gateway. Default period unit is Month.
               Value range: 1~9, 12, 24, 36. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] project_name: The project name of the VPN gateway.
        :param pulumi.Input[str] renew_type: The renew type of the VPN gateway.
        :param pulumi.Input[int] route_count: The route count of the VPN gateway.
        :param pulumi.Input[bool] ssl_enabled: Whether ssl is enabled.
        :param pulumi.Input[int] ssl_max_connections: The max connections of ssl. This parameter can only be passed in when ssl_enabled is true. Default is 5.
        :param pulumi.Input[str] status: The status of the VPN gateway.
        :param pulumi.Input[str] subnet_id: The ID of the subnet where you want to create the VPN gateway.
        :param pulumi.Input[Sequence[pulumi.Input['GatewayTagArgs']]] tags: Tags.
        :param pulumi.Input[str] update_time: The update time of VPN gateway.
        :param pulumi.Input[str] vpc_id: The ID of the VPC where you want to create the VPN gateway.
        :param pulumi.Input[str] vpn_gateway_id: The ID of the VPN gateway.
        :param pulumi.Input[str] vpn_gateway_name: The name of the VPN gateway.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if billing_type is not None:
            pulumi.set(__self__, "billing_type", billing_type)
        if business_status is not None:
            pulumi.set(__self__, "business_status", business_status)
        if connection_count is not None:
            pulumi.set(__self__, "connection_count", connection_count)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if deleted_time is not None:
            pulumi.set(__self__, "deleted_time", deleted_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expired_time is not None:
            pulumi.set(__self__, "expired_time", expired_time)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ipsec_enabled is not None:
            pulumi.set(__self__, "ipsec_enabled", ipsec_enabled)
        if lock_reason is not None:
            pulumi.set(__self__, "lock_reason", lock_reason)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if renew_type is not None:
            pulumi.set(__self__, "renew_type", renew_type)
        if route_count is not None:
            pulumi.set(__self__, "route_count", route_count)
        if ssl_enabled is not None:
            pulumi.set(__self__, "ssl_enabled", ssl_enabled)
        if ssl_max_connections is not None:
            pulumi.set(__self__, "ssl_max_connections", ssl_max_connections)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpn_gateway_id is not None:
            pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)
        if vpn_gateway_name is not None:
            pulumi.set(__self__, "vpn_gateway_name", vpn_gateway_name)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account ID of the VPN gateway.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The bandwidth of the VPN gateway. Unit: Mbps. Values: 5, 10, 20, 50, 100, 200, 500.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> Optional[pulumi.Input[str]]:
        """
        The BillingType of the VPN gateway. Only support `PrePaid`. Terraform will only remove the PrePaid VPN gateway from the
        state file, not actually remove.
        """
        return pulumi.get(self, "billing_type")

    @billing_type.setter
    def billing_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "billing_type", value)

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> Optional[pulumi.Input[str]]:
        """
        The business status of the VPN gateway.
        """
        return pulumi.get(self, "business_status")

    @business_status.setter
    def business_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "business_status", value)

    @property
    @pulumi.getter(name="connectionCount")
    def connection_count(self) -> Optional[pulumi.Input[int]]:
        """
        The connection count of the VPN gateway.
        """
        return pulumi.get(self, "connection_count")

    @connection_count.setter
    def connection_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connection_count", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        The create time of VPN gateway.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="deletedTime")
    def deleted_time(self) -> Optional[pulumi.Input[str]]:
        """
        The deleted time of the VPN gateway.
        """
        return pulumi.get(self, "deleted_time")

    @deleted_time.setter
    def deleted_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deleted_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the VPN gateway.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> Optional[pulumi.Input[str]]:
        """
        The expired time of the VPN gateway.
        """
        return pulumi.get(self, "expired_time")

    @expired_time.setter
    def expired_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expired_time", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the VPN gateway.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipsecEnabled")
    def ipsec_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether ipsec is enabled.
        """
        return pulumi.get(self, "ipsec_enabled")

    @ipsec_enabled.setter
    def ipsec_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipsec_enabled", value)

    @property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> Optional[pulumi.Input[str]]:
        """
        The lock reason of the VPN gateway.
        """
        return pulumi.get(self, "lock_reason")

    @lock_reason.setter
    def lock_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lock_reason", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The Period of the VPN gateway. Default value is 12. This parameter is only useful when creating vpn gateway. Default period unit is Month.
        Value range: 1~9, 12, 24, 36. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name of the VPN gateway.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="renewType")
    def renew_type(self) -> Optional[pulumi.Input[str]]:
        """
        The renew type of the VPN gateway.
        """
        return pulumi.get(self, "renew_type")

    @renew_type.setter
    def renew_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "renew_type", value)

    @property
    @pulumi.getter(name="routeCount")
    def route_count(self) -> Optional[pulumi.Input[int]]:
        """
        The route count of the VPN gateway.
        """
        return pulumi.get(self, "route_count")

    @route_count.setter
    def route_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "route_count", value)

    @property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether ssl is enabled.
        """
        return pulumi.get(self, "ssl_enabled")

    @ssl_enabled.setter
    def ssl_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl_enabled", value)

    @property
    @pulumi.getter(name="sslMaxConnections")
    def ssl_max_connections(self) -> Optional[pulumi.Input[int]]:
        """
        The max connections of ssl. This parameter can only be passed in when ssl_enabled is true. Default is 5.
        """
        return pulumi.get(self, "ssl_max_connections")

    @ssl_max_connections.setter
    def ssl_max_connections(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ssl_max_connections", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the VPN gateway.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the subnet where you want to create the VPN gateway.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GatewayTagArgs']]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The update time of VPN gateway.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPC where you want to create the VPN gateway.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPN gateway.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @vpn_gateway_id.setter
    def vpn_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_gateway_id", value)

    @property
    @pulumi.getter(name="vpnGatewayName")
    def vpn_gateway_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPN gateway.
        """
        return pulumi.get(self, "vpn_gateway_name")

    @vpn_gateway_name.setter
    def vpn_gateway_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_gateway_name", value)


class Gateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 billing_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ipsec_enabled: Optional[pulumi.Input[bool]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 ssl_enabled: Optional[pulumi.Input[bool]] = None,
                 ssl_max_connections: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GatewayTagArgs']]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpn_gateway_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id="cn-beijing-a",
            vpc_id=foo_vpc.id)
        foo_gateway = volcengine.vpn.Gateway("fooGateway",
            vpc_id=foo_vpc.id,
            subnet_id=foo_subnet.id,
            bandwidth=50,
            vpn_gateway_name="acc-test1",
            description="acc-test1",
            period=7,
            project_name="default")
        ```

        ## Import

        VpnGateway can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpn/gateway:Gateway default vgw-273zkshb2qayo7fap8t2****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] bandwidth: The bandwidth of the VPN gateway. Unit: Mbps. Values: 5, 10, 20, 50, 100, 200, 500.
        :param pulumi.Input[str] billing_type: The BillingType of the VPN gateway. Only support `PrePaid`. Terraform will only remove the PrePaid VPN gateway from the
               state file, not actually remove.
        :param pulumi.Input[str] description: The description of the VPN gateway.
        :param pulumi.Input[bool] ipsec_enabled: Whether ipsec is enabled.
        :param pulumi.Input[int] period: The Period of the VPN gateway. Default value is 12. This parameter is only useful when creating vpn gateway. Default period unit is Month.
               Value range: 1~9, 12, 24, 36. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] project_name: The project name of the VPN gateway.
        :param pulumi.Input[bool] ssl_enabled: Whether ssl is enabled.
        :param pulumi.Input[int] ssl_max_connections: The max connections of ssl. This parameter can only be passed in when ssl_enabled is true. Default is 5.
        :param pulumi.Input[str] subnet_id: The ID of the subnet where you want to create the VPN gateway.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GatewayTagArgs']]]] tags: Tags.
        :param pulumi.Input[str] vpc_id: The ID of the VPC where you want to create the VPN gateway.
        :param pulumi.Input[str] vpn_gateway_name: The name of the VPN gateway.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id="cn-beijing-a",
            vpc_id=foo_vpc.id)
        foo_gateway = volcengine.vpn.Gateway("fooGateway",
            vpc_id=foo_vpc.id,
            subnet_id=foo_subnet.id,
            bandwidth=50,
            vpn_gateway_name="acc-test1",
            description="acc-test1",
            period=7,
            project_name="default")
        ```

        ## Import

        VpnGateway can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpn/gateway:Gateway default vgw-273zkshb2qayo7fap8t2****
        ```

        :param str resource_name: The name of the resource.
        :param GatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 billing_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ipsec_enabled: Optional[pulumi.Input[bool]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 ssl_enabled: Optional[pulumi.Input[bool]] = None,
                 ssl_max_connections: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GatewayTagArgs']]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpn_gateway_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayArgs.__new__(GatewayArgs)

            if bandwidth is None and not opts.urn:
                raise TypeError("Missing required property 'bandwidth'")
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["billing_type"] = billing_type
            __props__.__dict__["description"] = description
            __props__.__dict__["ipsec_enabled"] = ipsec_enabled
            __props__.__dict__["period"] = period
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["ssl_enabled"] = ssl_enabled
            __props__.__dict__["ssl_max_connections"] = ssl_max_connections
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vpn_gateway_name"] = vpn_gateway_name
            __props__.__dict__["account_id"] = None
            __props__.__dict__["business_status"] = None
            __props__.__dict__["connection_count"] = None
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["deleted_time"] = None
            __props__.__dict__["expired_time"] = None
            __props__.__dict__["ip_address"] = None
            __props__.__dict__["lock_reason"] = None
            __props__.__dict__["renew_type"] = None
            __props__.__dict__["route_count"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["vpn_gateway_id"] = None
        super(Gateway, __self__).__init__(
            'volcengine:vpn/gateway:Gateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            bandwidth: Optional[pulumi.Input[int]] = None,
            billing_type: Optional[pulumi.Input[str]] = None,
            business_status: Optional[pulumi.Input[str]] = None,
            connection_count: Optional[pulumi.Input[int]] = None,
            creation_time: Optional[pulumi.Input[str]] = None,
            deleted_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            expired_time: Optional[pulumi.Input[str]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            ipsec_enabled: Optional[pulumi.Input[bool]] = None,
            lock_reason: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            renew_type: Optional[pulumi.Input[str]] = None,
            route_count: Optional[pulumi.Input[int]] = None,
            ssl_enabled: Optional[pulumi.Input[bool]] = None,
            ssl_max_connections: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GatewayTagArgs']]]]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vpn_gateway_id: Optional[pulumi.Input[str]] = None,
            vpn_gateway_name: Optional[pulumi.Input[str]] = None) -> 'Gateway':
        """
        Get an existing Gateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account ID of the VPN gateway.
        :param pulumi.Input[int] bandwidth: The bandwidth of the VPN gateway. Unit: Mbps. Values: 5, 10, 20, 50, 100, 200, 500.
        :param pulumi.Input[str] billing_type: The BillingType of the VPN gateway. Only support `PrePaid`. Terraform will only remove the PrePaid VPN gateway from the
               state file, not actually remove.
        :param pulumi.Input[str] business_status: The business status of the VPN gateway.
        :param pulumi.Input[int] connection_count: The connection count of the VPN gateway.
        :param pulumi.Input[str] creation_time: The create time of VPN gateway.
        :param pulumi.Input[str] deleted_time: The deleted time of the VPN gateway.
        :param pulumi.Input[str] description: The description of the VPN gateway.
        :param pulumi.Input[str] expired_time: The expired time of the VPN gateway.
        :param pulumi.Input[str] ip_address: The IP address of the VPN gateway.
        :param pulumi.Input[bool] ipsec_enabled: Whether ipsec is enabled.
        :param pulumi.Input[str] lock_reason: The lock reason of the VPN gateway.
        :param pulumi.Input[int] period: The Period of the VPN gateway. Default value is 12. This parameter is only useful when creating vpn gateway. Default period unit is Month.
               Value range: 1~9, 12, 24, 36. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] project_name: The project name of the VPN gateway.
        :param pulumi.Input[str] renew_type: The renew type of the VPN gateway.
        :param pulumi.Input[int] route_count: The route count of the VPN gateway.
        :param pulumi.Input[bool] ssl_enabled: Whether ssl is enabled.
        :param pulumi.Input[int] ssl_max_connections: The max connections of ssl. This parameter can only be passed in when ssl_enabled is true. Default is 5.
        :param pulumi.Input[str] status: The status of the VPN gateway.
        :param pulumi.Input[str] subnet_id: The ID of the subnet where you want to create the VPN gateway.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GatewayTagArgs']]]] tags: Tags.
        :param pulumi.Input[str] update_time: The update time of VPN gateway.
        :param pulumi.Input[str] vpc_id: The ID of the VPC where you want to create the VPN gateway.
        :param pulumi.Input[str] vpn_gateway_id: The ID of the VPN gateway.
        :param pulumi.Input[str] vpn_gateway_name: The name of the VPN gateway.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayState.__new__(_GatewayState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["billing_type"] = billing_type
        __props__.__dict__["business_status"] = business_status
        __props__.__dict__["connection_count"] = connection_count
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["deleted_time"] = deleted_time
        __props__.__dict__["description"] = description
        __props__.__dict__["expired_time"] = expired_time
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["ipsec_enabled"] = ipsec_enabled
        __props__.__dict__["lock_reason"] = lock_reason
        __props__.__dict__["period"] = period
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["renew_type"] = renew_type
        __props__.__dict__["route_count"] = route_count
        __props__.__dict__["ssl_enabled"] = ssl_enabled
        __props__.__dict__["ssl_max_connections"] = ssl_max_connections
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpn_gateway_id"] = vpn_gateway_id
        __props__.__dict__["vpn_gateway_name"] = vpn_gateway_name
        return Gateway(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The account ID of the VPN gateway.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[int]:
        """
        The bandwidth of the VPN gateway. Unit: Mbps. Values: 5, 10, 20, 50, 100, 200, 500.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> pulumi.Output[Optional[str]]:
        """
        The BillingType of the VPN gateway. Only support `PrePaid`. Terraform will only remove the PrePaid VPN gateway from the
        state file, not actually remove.
        """
        return pulumi.get(self, "billing_type")

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> pulumi.Output[str]:
        """
        The business status of the VPN gateway.
        """
        return pulumi.get(self, "business_status")

    @property
    @pulumi.getter(name="connectionCount")
    def connection_count(self) -> pulumi.Output[int]:
        """
        The connection count of the VPN gateway.
        """
        return pulumi.get(self, "connection_count")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        The create time of VPN gateway.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="deletedTime")
    def deleted_time(self) -> pulumi.Output[str]:
        """
        The deleted time of the VPN gateway.
        """
        return pulumi.get(self, "deleted_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the VPN gateway.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> pulumi.Output[str]:
        """
        The expired time of the VPN gateway.
        """
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        The IP address of the VPN gateway.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipsecEnabled")
    def ipsec_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether ipsec is enabled.
        """
        return pulumi.get(self, "ipsec_enabled")

    @property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> pulumi.Output[str]:
        """
        The lock reason of the VPN gateway.
        """
        return pulumi.get(self, "lock_reason")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        The Period of the VPN gateway. Default value is 12. This parameter is only useful when creating vpn gateway. Default period unit is Month.
        Value range: 1~9, 12, 24, 36. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        The project name of the VPN gateway.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="renewType")
    def renew_type(self) -> pulumi.Output[str]:
        """
        The renew type of the VPN gateway.
        """
        return pulumi.get(self, "renew_type")

    @property
    @pulumi.getter(name="routeCount")
    def route_count(self) -> pulumi.Output[int]:
        """
        The route count of the VPN gateway.
        """
        return pulumi.get(self, "route_count")

    @property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether ssl is enabled.
        """
        return pulumi.get(self, "ssl_enabled")

    @property
    @pulumi.getter(name="sslMaxConnections")
    def ssl_max_connections(self) -> pulumi.Output[int]:
        """
        The max connections of ssl. This parameter can only be passed in when ssl_enabled is true. Default is 5.
        """
        return pulumi.get(self, "ssl_max_connections")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the VPN gateway.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The ID of the subnet where you want to create the VPN gateway.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.GatewayTag']]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The update time of VPN gateway.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The ID of the VPC where you want to create the VPN gateway.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> pulumi.Output[str]:
        """
        The ID of the VPN gateway.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @property
    @pulumi.getter(name="vpnGatewayName")
    def vpn_gateway_name(self) -> pulumi.Output[str]:
        """
        The name of the VPN gateway.
        """
        return pulumi.get(self, "vpn_gateway_name")

