# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GatewaysResult',
    'AwaitableGatewaysResult',
    'gateways',
    'gateways_output',
]

@pulumi.output_type
class GatewaysResult:
    """
    A collection of values returned by Gateways.
    """
    def __init__(__self__, id=None, ids=None, ip_address=None, name_regex=None, output_file=None, subnet_id=None, tags=None, total_count=None, vpc_id=None, vpn_gateway_names=None, vpn_gateways=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if ip_address and not isinstance(ip_address, str):
            raise TypeError("Expected argument 'ip_address' to be a str")
        pulumi.set(__self__, "ip_address", ip_address)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)
        if vpn_gateway_names and not isinstance(vpn_gateway_names, list):
            raise TypeError("Expected argument 'vpn_gateway_names' to be a list")
        pulumi.set(__self__, "vpn_gateway_names", vpn_gateway_names)
        if vpn_gateways and not isinstance(vpn_gateways, list):
            raise TypeError("Expected argument 'vpn_gateways' to be a list")
        pulumi.set(__self__, "vpn_gateways", vpn_gateways)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        The IP address of the VPN gateway.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.GatewaysTagResult']]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of VPN gateway query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        The VPC ID of the VPN gateway.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpnGatewayNames")
    def vpn_gateway_names(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "vpn_gateway_names")

    @property
    @pulumi.getter(name="vpnGateways")
    def vpn_gateways(self) -> Sequence['outputs.GatewaysVpnGatewayResult']:
        """
        The collection of VPN gateway query.
        """
        return pulumi.get(self, "vpn_gateways")


class AwaitableGatewaysResult(GatewaysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GatewaysResult(
            id=self.id,
            ids=self.ids,
            ip_address=self.ip_address,
            name_regex=self.name_regex,
            output_file=self.output_file,
            subnet_id=self.subnet_id,
            tags=self.tags,
            total_count=self.total_count,
            vpc_id=self.vpc_id,
            vpn_gateway_names=self.vpn_gateway_names,
            vpn_gateways=self.vpn_gateways)


def gateways(ids: Optional[Sequence[str]] = None,
             ip_address: Optional[str] = None,
             name_regex: Optional[str] = None,
             output_file: Optional[str] = None,
             subnet_id: Optional[str] = None,
             tags: Optional[Sequence[pulumi.InputType['GatewaysTagArgs']]] = None,
             vpc_id: Optional[str] = None,
             vpn_gateway_names: Optional[Sequence[str]] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGatewaysResult:
    """
    Use this data source to query detailed information of vpn gateways
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id="cn-beijing-a",
        vpc_id=foo_vpc.id)
    foo_gateway = volcengine.vpn.Gateway("fooGateway",
        vpc_id=foo_vpc.id,
        subnet_id=foo_subnet.id,
        bandwidth=20,
        vpn_gateway_name="acc-test",
        description="acc-test",
        period=2,
        project_name="default")
    foo_gateways = volcengine.vpn.gateways_output(ids=[foo_gateway.id])
    ```


    :param Sequence[str] ids: A list of VPN gateway ids.
    :param str ip_address: A IP address of the VPN gateway.
    :param str name_regex: A Name Regex of VPN gateway.
    :param str output_file: File name where to save data source results.
    :param str subnet_id: A subnet ID of the VPN gateway.
    :param Sequence[pulumi.InputType['GatewaysTagArgs']] tags: Tags.
    :param str vpc_id: A VPC ID of the VPN gateway.
    :param Sequence[str] vpn_gateway_names: A list of VPN gateway names.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['ipAddress'] = ip_address
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['subnetId'] = subnet_id
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    __args__['vpnGatewayNames'] = vpn_gateway_names
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:vpn/gateways:Gateways', __args__, opts=opts, typ=GatewaysResult).value

    return AwaitableGatewaysResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        ip_address=pulumi.get(__ret__, 'ip_address'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        tags=pulumi.get(__ret__, 'tags'),
        total_count=pulumi.get(__ret__, 'total_count'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'),
        vpn_gateway_names=pulumi.get(__ret__, 'vpn_gateway_names'),
        vpn_gateways=pulumi.get(__ret__, 'vpn_gateways'))


@_utilities.lift_output_func(gateways)
def gateways_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                    ip_address: Optional[pulumi.Input[Optional[str]]] = None,
                    name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                    output_file: Optional[pulumi.Input[Optional[str]]] = None,
                    subnet_id: Optional[pulumi.Input[Optional[str]]] = None,
                    tags: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GatewaysTagArgs']]]]] = None,
                    vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                    vpn_gateway_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GatewaysResult]:
    """
    Use this data source to query detailed information of vpn gateways
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id="cn-beijing-a",
        vpc_id=foo_vpc.id)
    foo_gateway = volcengine.vpn.Gateway("fooGateway",
        vpc_id=foo_vpc.id,
        subnet_id=foo_subnet.id,
        bandwidth=20,
        vpn_gateway_name="acc-test",
        description="acc-test",
        period=2,
        project_name="default")
    foo_gateways = volcengine.vpn.gateways_output(ids=[foo_gateway.id])
    ```


    :param Sequence[str] ids: A list of VPN gateway ids.
    :param str ip_address: A IP address of the VPN gateway.
    :param str name_regex: A Name Regex of VPN gateway.
    :param str output_file: File name where to save data source results.
    :param str subnet_id: A subnet ID of the VPN gateway.
    :param Sequence[pulumi.InputType['GatewaysTagArgs']] tags: Tags.
    :param str vpc_id: A VPC ID of the VPN gateway.
    :param Sequence[str] vpn_gateway_names: A list of VPN gateway names.
    """
    ...
