# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SslVpnClientCertArgs', 'SslVpnClientCert']

@pulumi.input_type
class SslVpnClientCertArgs:
    def __init__(__self__, *,
                 ssl_vpn_server_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 ssl_vpn_client_cert_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SslVpnClientCert resource.
        :param pulumi.Input[str] ssl_vpn_server_id: The id of the ssl vpn server.
        :param pulumi.Input[str] description: The description of the ssl vpn client cert.
        :param pulumi.Input[str] ssl_vpn_client_cert_name: The name of the ssl vpn client cert.
        """
        pulumi.set(__self__, "ssl_vpn_server_id", ssl_vpn_server_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ssl_vpn_client_cert_name is not None:
            pulumi.set(__self__, "ssl_vpn_client_cert_name", ssl_vpn_client_cert_name)

    @property
    @pulumi.getter(name="sslVpnServerId")
    def ssl_vpn_server_id(self) -> pulumi.Input[str]:
        """
        The id of the ssl vpn server.
        """
        return pulumi.get(self, "ssl_vpn_server_id")

    @ssl_vpn_server_id.setter
    def ssl_vpn_server_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "ssl_vpn_server_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the ssl vpn client cert.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="sslVpnClientCertName")
    def ssl_vpn_client_cert_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ssl vpn client cert.
        """
        return pulumi.get(self, "ssl_vpn_client_cert_name")

    @ssl_vpn_client_cert_name.setter
    def ssl_vpn_client_cert_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_vpn_client_cert_name", value)


@pulumi.input_type
class _SslVpnClientCertState:
    def __init__(__self__, *,
                 ca_certificate: Optional[pulumi.Input[str]] = None,
                 certificate_status: Optional[pulumi.Input[str]] = None,
                 client_certificate: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 creation_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expired_time: Optional[pulumi.Input[str]] = None,
                 open_vpn_client_config: Optional[pulumi.Input[str]] = None,
                 ssl_vpn_client_cert_name: Optional[pulumi.Input[str]] = None,
                 ssl_vpn_server_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SslVpnClientCert resources.
        :param pulumi.Input[str] ca_certificate: The CA certificate.
        :param pulumi.Input[str] certificate_status: The status of the ssl vpn client cert.
        :param pulumi.Input[str] client_certificate: The client certificate.
        :param pulumi.Input[str] client_key: The key of the ssl vpn client.
        :param pulumi.Input[str] creation_time: The creation time of the ssl vpn client cert.
        :param pulumi.Input[str] description: The description of the ssl vpn client cert.
        :param pulumi.Input[str] expired_time: The expired time of the ssl vpn client cert.
        :param pulumi.Input[str] open_vpn_client_config: The config of the open vpn client.
        :param pulumi.Input[str] ssl_vpn_client_cert_name: The name of the ssl vpn client cert.
        :param pulumi.Input[str] ssl_vpn_server_id: The id of the ssl vpn server.
        :param pulumi.Input[str] status: The status of the ssl vpn client.
        :param pulumi.Input[str] update_time: The update time of the ssl vpn client cert.
        """
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if certificate_status is not None:
            pulumi.set(__self__, "certificate_status", certificate_status)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expired_time is not None:
            pulumi.set(__self__, "expired_time", expired_time)
        if open_vpn_client_config is not None:
            pulumi.set(__self__, "open_vpn_client_config", open_vpn_client_config)
        if ssl_vpn_client_cert_name is not None:
            pulumi.set(__self__, "ssl_vpn_client_cert_name", ssl_vpn_client_cert_name)
        if ssl_vpn_server_id is not None:
            pulumi.set(__self__, "ssl_vpn_server_id", ssl_vpn_server_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The CA certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate", value)

    @property
    @pulumi.getter(name="certificateStatus")
    def certificate_status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the ssl vpn client cert.
        """
        return pulumi.get(self, "certificate_status")

    @certificate_status.setter
    def certificate_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_status", value)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The client certificate.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        """
        The key of the ssl vpn client.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time of the ssl vpn client cert.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the ssl vpn client cert.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> Optional[pulumi.Input[str]]:
        """
        The expired time of the ssl vpn client cert.
        """
        return pulumi.get(self, "expired_time")

    @expired_time.setter
    def expired_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expired_time", value)

    @property
    @pulumi.getter(name="openVpnClientConfig")
    def open_vpn_client_config(self) -> Optional[pulumi.Input[str]]:
        """
        The config of the open vpn client.
        """
        return pulumi.get(self, "open_vpn_client_config")

    @open_vpn_client_config.setter
    def open_vpn_client_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "open_vpn_client_config", value)

    @property
    @pulumi.getter(name="sslVpnClientCertName")
    def ssl_vpn_client_cert_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ssl vpn client cert.
        """
        return pulumi.get(self, "ssl_vpn_client_cert_name")

    @ssl_vpn_client_cert_name.setter
    def ssl_vpn_client_cert_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_vpn_client_cert_name", value)

    @property
    @pulumi.getter(name="sslVpnServerId")
    def ssl_vpn_server_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the ssl vpn server.
        """
        return pulumi.get(self, "ssl_vpn_server_id")

    @ssl_vpn_server_id.setter
    def ssl_vpn_server_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_vpn_server_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the ssl vpn client.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The update time of the ssl vpn client cert.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class SslVpnClientCert(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ssl_vpn_client_cert_name: Optional[pulumi.Input[str]] = None,
                 ssl_vpn_server_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage ssl vpn client cert
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_gateway = volcengine.vpn.Gateway("fooGateway",
            vpc_id=foo_vpc.id,
            subnet_id=foo_subnet.id,
            bandwidth=5,
            vpn_gateway_name="acc-test1",
            description="acc-test1",
            period=7,
            project_name="default",
            ssl_enabled=True,
            ssl_max_connections=5)
        foo_ssl_vpn_server = volcengine.vpn.SslVpnServer("fooSslVpnServer",
            vpn_gateway_id=foo_gateway.id,
            local_subnets=[foo_subnet.cidr_block],
            client_ip_pool="172.16.2.0/24",
            ssl_vpn_server_name="acc-test-ssl",
            description="acc-test",
            protocol="UDP",
            cipher="AES-128-CBC",
            auth="SHA1",
            compress=True)
        foo_ssl_vpn_client_cert = volcengine.vpn.SslVpnClientCert("fooSslVpnClientCert",
            ssl_vpn_server_id=foo_ssl_vpn_server.id,
            ssl_vpn_client_cert_name="acc-test-client-cert",
            description="acc-test")
        ```

        ## Import

        SSL VPN Client Cert can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpn/sslVpnClientCert:SslVpnClientCert default vsc-2d6b7gjrzc2yo58ozfcx2****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the ssl vpn client cert.
        :param pulumi.Input[str] ssl_vpn_client_cert_name: The name of the ssl vpn client cert.
        :param pulumi.Input[str] ssl_vpn_server_id: The id of the ssl vpn server.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SslVpnClientCertArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage ssl vpn client cert
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_gateway = volcengine.vpn.Gateway("fooGateway",
            vpc_id=foo_vpc.id,
            subnet_id=foo_subnet.id,
            bandwidth=5,
            vpn_gateway_name="acc-test1",
            description="acc-test1",
            period=7,
            project_name="default",
            ssl_enabled=True,
            ssl_max_connections=5)
        foo_ssl_vpn_server = volcengine.vpn.SslVpnServer("fooSslVpnServer",
            vpn_gateway_id=foo_gateway.id,
            local_subnets=[foo_subnet.cidr_block],
            client_ip_pool="172.16.2.0/24",
            ssl_vpn_server_name="acc-test-ssl",
            description="acc-test",
            protocol="UDP",
            cipher="AES-128-CBC",
            auth="SHA1",
            compress=True)
        foo_ssl_vpn_client_cert = volcengine.vpn.SslVpnClientCert("fooSslVpnClientCert",
            ssl_vpn_server_id=foo_ssl_vpn_server.id,
            ssl_vpn_client_cert_name="acc-test-client-cert",
            description="acc-test")
        ```

        ## Import

        SSL VPN Client Cert can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpn/sslVpnClientCert:SslVpnClientCert default vsc-2d6b7gjrzc2yo58ozfcx2****
        ```

        :param str resource_name: The name of the resource.
        :param SslVpnClientCertArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SslVpnClientCertArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ssl_vpn_client_cert_name: Optional[pulumi.Input[str]] = None,
                 ssl_vpn_server_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SslVpnClientCertArgs.__new__(SslVpnClientCertArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["ssl_vpn_client_cert_name"] = ssl_vpn_client_cert_name
            if ssl_vpn_server_id is None and not opts.urn:
                raise TypeError("Missing required property 'ssl_vpn_server_id'")
            __props__.__dict__["ssl_vpn_server_id"] = ssl_vpn_server_id
            __props__.__dict__["ca_certificate"] = None
            __props__.__dict__["certificate_status"] = None
            __props__.__dict__["client_certificate"] = None
            __props__.__dict__["client_key"] = None
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["expired_time"] = None
            __props__.__dict__["open_vpn_client_config"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["update_time"] = None
        super(SslVpnClientCert, __self__).__init__(
            'volcengine:vpn/sslVpnClientCert:SslVpnClientCert',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ca_certificate: Optional[pulumi.Input[str]] = None,
            certificate_status: Optional[pulumi.Input[str]] = None,
            client_certificate: Optional[pulumi.Input[str]] = None,
            client_key: Optional[pulumi.Input[str]] = None,
            creation_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            expired_time: Optional[pulumi.Input[str]] = None,
            open_vpn_client_config: Optional[pulumi.Input[str]] = None,
            ssl_vpn_client_cert_name: Optional[pulumi.Input[str]] = None,
            ssl_vpn_server_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'SslVpnClientCert':
        """
        Get an existing SslVpnClientCert resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ca_certificate: The CA certificate.
        :param pulumi.Input[str] certificate_status: The status of the ssl vpn client cert.
        :param pulumi.Input[str] client_certificate: The client certificate.
        :param pulumi.Input[str] client_key: The key of the ssl vpn client.
        :param pulumi.Input[str] creation_time: The creation time of the ssl vpn client cert.
        :param pulumi.Input[str] description: The description of the ssl vpn client cert.
        :param pulumi.Input[str] expired_time: The expired time of the ssl vpn client cert.
        :param pulumi.Input[str] open_vpn_client_config: The config of the open vpn client.
        :param pulumi.Input[str] ssl_vpn_client_cert_name: The name of the ssl vpn client cert.
        :param pulumi.Input[str] ssl_vpn_server_id: The id of the ssl vpn server.
        :param pulumi.Input[str] status: The status of the ssl vpn client.
        :param pulumi.Input[str] update_time: The update time of the ssl vpn client cert.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SslVpnClientCertState.__new__(_SslVpnClientCertState)

        __props__.__dict__["ca_certificate"] = ca_certificate
        __props__.__dict__["certificate_status"] = certificate_status
        __props__.__dict__["client_certificate"] = client_certificate
        __props__.__dict__["client_key"] = client_key
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["description"] = description
        __props__.__dict__["expired_time"] = expired_time
        __props__.__dict__["open_vpn_client_config"] = open_vpn_client_config
        __props__.__dict__["ssl_vpn_client_cert_name"] = ssl_vpn_client_cert_name
        __props__.__dict__["ssl_vpn_server_id"] = ssl_vpn_server_id
        __props__.__dict__["status"] = status
        __props__.__dict__["update_time"] = update_time
        return SslVpnClientCert(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> pulumi.Output[str]:
        """
        The CA certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="certificateStatus")
    def certificate_status(self) -> pulumi.Output[str]:
        """
        The status of the ssl vpn client cert.
        """
        return pulumi.get(self, "certificate_status")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> pulumi.Output[str]:
        """
        The client certificate.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> pulumi.Output[str]:
        """
        The key of the ssl vpn client.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        The creation time of the ssl vpn client cert.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the ssl vpn client cert.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> pulumi.Output[str]:
        """
        The expired time of the ssl vpn client cert.
        """
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter(name="openVpnClientConfig")
    def open_vpn_client_config(self) -> pulumi.Output[str]:
        """
        The config of the open vpn client.
        """
        return pulumi.get(self, "open_vpn_client_config")

    @property
    @pulumi.getter(name="sslVpnClientCertName")
    def ssl_vpn_client_cert_name(self) -> pulumi.Output[str]:
        """
        The name of the ssl vpn client cert.
        """
        return pulumi.get(self, "ssl_vpn_client_cert_name")

    @property
    @pulumi.getter(name="sslVpnServerId")
    def ssl_vpn_server_id(self) -> pulumi.Output[str]:
        """
        The id of the ssl vpn server.
        """
        return pulumi.get(self, "ssl_vpn_server_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the ssl vpn client.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The update time of the ssl vpn client cert.
        """
        return pulumi.get(self, "update_time")

