# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'SslVpnClientCertsResult',
    'AwaitableSslVpnClientCertsResult',
    'ssl_vpn_client_certs',
    'ssl_vpn_client_certs_output',
]

@pulumi.output_type
class SslVpnClientCertsResult:
    """
    A collection of values returned by SslVpnClientCerts.
    """
    def __init__(__self__, id=None, ids=None, name_regex=None, output_file=None, ssl_vpn_client_cert_name=None, ssl_vpn_client_certs=None, ssl_vpn_server_id=None, total_count=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if ssl_vpn_client_cert_name and not isinstance(ssl_vpn_client_cert_name, str):
            raise TypeError("Expected argument 'ssl_vpn_client_cert_name' to be a str")
        pulumi.set(__self__, "ssl_vpn_client_cert_name", ssl_vpn_client_cert_name)
        if ssl_vpn_client_certs and not isinstance(ssl_vpn_client_certs, list):
            raise TypeError("Expected argument 'ssl_vpn_client_certs' to be a list")
        pulumi.set(__self__, "ssl_vpn_client_certs", ssl_vpn_client_certs)
        if ssl_vpn_server_id and not isinstance(ssl_vpn_server_id, str):
            raise TypeError("Expected argument 'ssl_vpn_server_id' to be a str")
        pulumi.set(__self__, "ssl_vpn_server_id", ssl_vpn_server_id)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="sslVpnClientCertName")
    def ssl_vpn_client_cert_name(self) -> Optional[str]:
        """
        The name of the ssl vpn client cert.
        """
        return pulumi.get(self, "ssl_vpn_client_cert_name")

    @property
    @pulumi.getter(name="sslVpnClientCerts")
    def ssl_vpn_client_certs(self) -> Sequence['outputs.SslVpnClientCertsSslVpnClientCertResult']:
        """
        The collection of of ssl vpn client certs.
        """
        return pulumi.get(self, "ssl_vpn_client_certs")

    @property
    @pulumi.getter(name="sslVpnServerId")
    def ssl_vpn_server_id(self) -> Optional[str]:
        """
        The id of the ssl vpn server.
        """
        return pulumi.get(self, "ssl_vpn_server_id")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of ssl vpn client cert query.
        """
        return pulumi.get(self, "total_count")


class AwaitableSslVpnClientCertsResult(SslVpnClientCertsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return SslVpnClientCertsResult(
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            output_file=self.output_file,
            ssl_vpn_client_cert_name=self.ssl_vpn_client_cert_name,
            ssl_vpn_client_certs=self.ssl_vpn_client_certs,
            ssl_vpn_server_id=self.ssl_vpn_server_id,
            total_count=self.total_count)


def ssl_vpn_client_certs(ids: Optional[Sequence[str]] = None,
                         name_regex: Optional[str] = None,
                         output_file: Optional[str] = None,
                         ssl_vpn_client_cert_name: Optional[str] = None,
                         ssl_vpn_server_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableSslVpnClientCertsResult:
    """
    Use this data source to query detailed information of ssl vpn client certs
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_gateway = volcengine.vpn.Gateway("fooGateway",
        vpc_id=foo_vpc.id,
        subnet_id=foo_subnet.id,
        bandwidth=5,
        vpn_gateway_name="acc-test1",
        description="acc-test1",
        period=7,
        project_name="default",
        ssl_enabled=True,
        ssl_max_connections=5)
    foo_ssl_vpn_server = volcengine.vpn.SslVpnServer("fooSslVpnServer",
        vpn_gateway_id=foo_gateway.id,
        local_subnets=[foo_subnet.cidr_block],
        client_ip_pool="172.16.2.0/24",
        ssl_vpn_server_name="acc-test-ssl",
        description="acc-test",
        protocol="UDP",
        cipher="AES-128-CBC",
        auth="SHA1",
        compress=True)
    foo_ssl_vpn_client_cert = []
    for range in [{"value": i} for i in range(0, 5)]:
        foo_ssl_vpn_client_cert.append(volcengine.vpn.SslVpnClientCert(f"fooSslVpnClientCert-{range['value']}",
            ssl_vpn_server_id=foo_ssl_vpn_server.id,
            ssl_vpn_client_cert_name=f"acc-test-client-cert-{range['value']}",
            description="acc-test"))
    foo_ssl_vpn_client_certs = volcengine.vpn.ssl_vpn_client_certs_output(ids=[__item.id for __item in foo_ssl_vpn_client_cert])
    ```


    :param Sequence[str] ids: The ids list of ssl vpn client cert.
    :param str name_regex: A Name Regex of ssl vpn client cert.
    :param str output_file: File name where to save data source results.
    :param str ssl_vpn_client_cert_name: The name of the ssl vpn client cert.
    :param str ssl_vpn_server_id: The id of the ssl vpn server.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['sslVpnClientCertName'] = ssl_vpn_client_cert_name
    __args__['sslVpnServerId'] = ssl_vpn_server_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:vpn/sslVpnClientCerts:SslVpnClientCerts', __args__, opts=opts, typ=SslVpnClientCertsResult).value

    return AwaitableSslVpnClientCertsResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        ssl_vpn_client_cert_name=pulumi.get(__ret__, 'ssl_vpn_client_cert_name'),
        ssl_vpn_client_certs=pulumi.get(__ret__, 'ssl_vpn_client_certs'),
        ssl_vpn_server_id=pulumi.get(__ret__, 'ssl_vpn_server_id'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(ssl_vpn_client_certs)
def ssl_vpn_client_certs_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                                output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                ssl_vpn_client_cert_name: Optional[pulumi.Input[Optional[str]]] = None,
                                ssl_vpn_server_id: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[SslVpnClientCertsResult]:
    """
    Use this data source to query detailed information of ssl vpn client certs
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_gateway = volcengine.vpn.Gateway("fooGateway",
        vpc_id=foo_vpc.id,
        subnet_id=foo_subnet.id,
        bandwidth=5,
        vpn_gateway_name="acc-test1",
        description="acc-test1",
        period=7,
        project_name="default",
        ssl_enabled=True,
        ssl_max_connections=5)
    foo_ssl_vpn_server = volcengine.vpn.SslVpnServer("fooSslVpnServer",
        vpn_gateway_id=foo_gateway.id,
        local_subnets=[foo_subnet.cidr_block],
        client_ip_pool="172.16.2.0/24",
        ssl_vpn_server_name="acc-test-ssl",
        description="acc-test",
        protocol="UDP",
        cipher="AES-128-CBC",
        auth="SHA1",
        compress=True)
    foo_ssl_vpn_client_cert = []
    for range in [{"value": i} for i in range(0, 5)]:
        foo_ssl_vpn_client_cert.append(volcengine.vpn.SslVpnClientCert(f"fooSslVpnClientCert-{range['value']}",
            ssl_vpn_server_id=foo_ssl_vpn_server.id,
            ssl_vpn_client_cert_name=f"acc-test-client-cert-{range['value']}",
            description="acc-test"))
    foo_ssl_vpn_client_certs = volcengine.vpn.ssl_vpn_client_certs_output(ids=[__item.id for __item in foo_ssl_vpn_client_cert])
    ```


    :param Sequence[str] ids: The ids list of ssl vpn client cert.
    :param str name_regex: A Name Regex of ssl vpn client cert.
    :param str output_file: File name where to save data source results.
    :param str ssl_vpn_client_cert_name: The name of the ssl vpn client cert.
    :param str ssl_vpn_server_id: The id of the ssl vpn server.
    """
    ...
