# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SslVpnServerArgs', 'SslVpnServer']

@pulumi.input_type
class SslVpnServerArgs:
    def __init__(__self__, *,
                 client_ip_pool: pulumi.Input[str],
                 local_subnets: pulumi.Input[Sequence[pulumi.Input[str]]],
                 vpn_gateway_id: pulumi.Input[str],
                 auth: Optional[pulumi.Input[str]] = None,
                 cipher: Optional[pulumi.Input[str]] = None,
                 compress: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 ssl_vpn_server_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SslVpnServer resource.
        :param pulumi.Input[str] client_ip_pool: SSL client network segment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_subnets: The local network segment of the SSL server. The local network segment is the address segment that the client accesses through the SSL VPN connection.
        :param pulumi.Input[str] vpn_gateway_id: The vpn gateway id.
        :param pulumi.Input[str] auth: The authentication algorithm of the SSL server.
               Values:
               `SHA1` (default)
               `MD5`
               `None` (do not use encryption).
        :param pulumi.Input[str] cipher: The encryption algorithm of the SSL server.
               Values:
               `AES-128-CBC` (default)
               `AES-192-CBC`
               `AES-256-CBC`
               `None` (do not use encryption).
        :param pulumi.Input[bool] compress: Whether to compress the transmitted data. The default value is false.
        :param pulumi.Input[str] description: The description of the ssl server.
        :param pulumi.Input[str] protocol: The protocol used by the SSL server. Valid values are `TCP`, `UDP`. Default Value: `UDP`.
        :param pulumi.Input[str] ssl_vpn_server_name: The name of the SSL server.
        """
        pulumi.set(__self__, "client_ip_pool", client_ip_pool)
        pulumi.set(__self__, "local_subnets", local_subnets)
        pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if cipher is not None:
            pulumi.set(__self__, "cipher", cipher)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if ssl_vpn_server_name is not None:
            pulumi.set(__self__, "ssl_vpn_server_name", ssl_vpn_server_name)

    @property
    @pulumi.getter(name="clientIpPool")
    def client_ip_pool(self) -> pulumi.Input[str]:
        """
        SSL client network segment.
        """
        return pulumi.get(self, "client_ip_pool")

    @client_ip_pool.setter
    def client_ip_pool(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_ip_pool", value)

    @property
    @pulumi.getter(name="localSubnets")
    def local_subnets(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The local network segment of the SSL server. The local network segment is the address segment that the client accesses through the SSL VPN connection.
        """
        return pulumi.get(self, "local_subnets")

    @local_subnets.setter
    def local_subnets(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "local_subnets", value)

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> pulumi.Input[str]:
        """
        The vpn gateway id.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @vpn_gateway_id.setter
    def vpn_gateway_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpn_gateway_id", value)

    @property
    @pulumi.getter
    def auth(self) -> Optional[pulumi.Input[str]]:
        """
        The authentication algorithm of the SSL server.
        Values:
        `SHA1` (default)
        `MD5`
        `None` (do not use encryption).
        """
        return pulumi.get(self, "auth")

    @auth.setter
    def auth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth", value)

    @property
    @pulumi.getter
    def cipher(self) -> Optional[pulumi.Input[str]]:
        """
        The encryption algorithm of the SSL server.
        Values:
        `AES-128-CBC` (default)
        `AES-192-CBC`
        `AES-256-CBC`
        `None` (do not use encryption).
        """
        return pulumi.get(self, "cipher")

    @cipher.setter
    def cipher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cipher", value)

    @property
    @pulumi.getter
    def compress(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to compress the transmitted data. The default value is false.
        """
        return pulumi.get(self, "compress")

    @compress.setter
    def compress(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "compress", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the ssl server.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol used by the SSL server. Valid values are `TCP`, `UDP`. Default Value: `UDP`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sslVpnServerName")
    def ssl_vpn_server_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SSL server.
        """
        return pulumi.get(self, "ssl_vpn_server_name")

    @ssl_vpn_server_name.setter
    def ssl_vpn_server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_vpn_server_name", value)


@pulumi.input_type
class _SslVpnServerState:
    def __init__(__self__, *,
                 auth: Optional[pulumi.Input[str]] = None,
                 cipher: Optional[pulumi.Input[str]] = None,
                 client_ip_pool: Optional[pulumi.Input[str]] = None,
                 compress: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 local_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 ssl_vpn_server_id: Optional[pulumi.Input[str]] = None,
                 ssl_vpn_server_name: Optional[pulumi.Input[str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SslVpnServer resources.
        :param pulumi.Input[str] auth: The authentication algorithm of the SSL server.
               Values:
               `SHA1` (default)
               `MD5`
               `None` (do not use encryption).
        :param pulumi.Input[str] cipher: The encryption algorithm of the SSL server.
               Values:
               `AES-128-CBC` (default)
               `AES-192-CBC`
               `AES-256-CBC`
               `None` (do not use encryption).
        :param pulumi.Input[str] client_ip_pool: SSL client network segment.
        :param pulumi.Input[bool] compress: Whether to compress the transmitted data. The default value is false.
        :param pulumi.Input[str] description: The description of the ssl server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_subnets: The local network segment of the SSL server. The local network segment is the address segment that the client accesses through the SSL VPN connection.
        :param pulumi.Input[str] protocol: The protocol used by the SSL server. Valid values are `TCP`, `UDP`. Default Value: `UDP`.
        :param pulumi.Input[str] ssl_vpn_server_id: The id of the ssl vpn server.
        :param pulumi.Input[str] ssl_vpn_server_name: The name of the SSL server.
        :param pulumi.Input[str] vpn_gateway_id: The vpn gateway id.
        """
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if cipher is not None:
            pulumi.set(__self__, "cipher", cipher)
        if client_ip_pool is not None:
            pulumi.set(__self__, "client_ip_pool", client_ip_pool)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if local_subnets is not None:
            pulumi.set(__self__, "local_subnets", local_subnets)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if ssl_vpn_server_id is not None:
            pulumi.set(__self__, "ssl_vpn_server_id", ssl_vpn_server_id)
        if ssl_vpn_server_name is not None:
            pulumi.set(__self__, "ssl_vpn_server_name", ssl_vpn_server_name)
        if vpn_gateway_id is not None:
            pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)

    @property
    @pulumi.getter
    def auth(self) -> Optional[pulumi.Input[str]]:
        """
        The authentication algorithm of the SSL server.
        Values:
        `SHA1` (default)
        `MD5`
        `None` (do not use encryption).
        """
        return pulumi.get(self, "auth")

    @auth.setter
    def auth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth", value)

    @property
    @pulumi.getter
    def cipher(self) -> Optional[pulumi.Input[str]]:
        """
        The encryption algorithm of the SSL server.
        Values:
        `AES-128-CBC` (default)
        `AES-192-CBC`
        `AES-256-CBC`
        `None` (do not use encryption).
        """
        return pulumi.get(self, "cipher")

    @cipher.setter
    def cipher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cipher", value)

    @property
    @pulumi.getter(name="clientIpPool")
    def client_ip_pool(self) -> Optional[pulumi.Input[str]]:
        """
        SSL client network segment.
        """
        return pulumi.get(self, "client_ip_pool")

    @client_ip_pool.setter
    def client_ip_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_ip_pool", value)

    @property
    @pulumi.getter
    def compress(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to compress the transmitted data. The default value is false.
        """
        return pulumi.get(self, "compress")

    @compress.setter
    def compress(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "compress", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the ssl server.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="localSubnets")
    def local_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The local network segment of the SSL server. The local network segment is the address segment that the client accesses through the SSL VPN connection.
        """
        return pulumi.get(self, "local_subnets")

    @local_subnets.setter
    def local_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "local_subnets", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol used by the SSL server. Valid values are `TCP`, `UDP`. Default Value: `UDP`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sslVpnServerId")
    def ssl_vpn_server_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the ssl vpn server.
        """
        return pulumi.get(self, "ssl_vpn_server_id")

    @ssl_vpn_server_id.setter
    def ssl_vpn_server_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_vpn_server_id", value)

    @property
    @pulumi.getter(name="sslVpnServerName")
    def ssl_vpn_server_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SSL server.
        """
        return pulumi.get(self, "ssl_vpn_server_name")

    @ssl_vpn_server_name.setter
    def ssl_vpn_server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_vpn_server_name", value)

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vpn gateway id.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @vpn_gateway_id.setter
    def vpn_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_gateway_id", value)


class SslVpnServer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth: Optional[pulumi.Input[str]] = None,
                 cipher: Optional[pulumi.Input[str]] = None,
                 client_ip_pool: Optional[pulumi.Input[str]] = None,
                 compress: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 local_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 ssl_vpn_server_name: Optional[pulumi.Input[str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage ssl vpn server
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_gateway = volcengine.vpn.Gateway("fooGateway",
            vpc_id=foo_vpc.id,
            subnet_id=foo_subnet.id,
            bandwidth=5,
            vpn_gateway_name="acc-test1",
            description="acc-test1",
            period=7,
            project_name="default",
            ssl_enabled=True,
            ssl_max_connections=5)
        foo_ssl_vpn_server = volcengine.vpn.SslVpnServer("fooSslVpnServer",
            vpn_gateway_id=foo_gateway.id,
            local_subnets=[foo_subnet.cidr_block],
            client_ip_pool="172.16.2.0/24",
            ssl_vpn_server_name="acc-test-ssl",
            description="acc-test",
            protocol="UDP",
            cipher="AES-128-CBC",
            auth="SHA1",
            compress=True)
        ```

        ## Import

        SSL VPN server can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpn/sslVpnServer:SslVpnServer default vss-zm55pqtvk17oq32zd****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auth: The authentication algorithm of the SSL server.
               Values:
               `SHA1` (default)
               `MD5`
               `None` (do not use encryption).
        :param pulumi.Input[str] cipher: The encryption algorithm of the SSL server.
               Values:
               `AES-128-CBC` (default)
               `AES-192-CBC`
               `AES-256-CBC`
               `None` (do not use encryption).
        :param pulumi.Input[str] client_ip_pool: SSL client network segment.
        :param pulumi.Input[bool] compress: Whether to compress the transmitted data. The default value is false.
        :param pulumi.Input[str] description: The description of the ssl server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_subnets: The local network segment of the SSL server. The local network segment is the address segment that the client accesses through the SSL VPN connection.
        :param pulumi.Input[str] protocol: The protocol used by the SSL server. Valid values are `TCP`, `UDP`. Default Value: `UDP`.
        :param pulumi.Input[str] ssl_vpn_server_name: The name of the SSL server.
        :param pulumi.Input[str] vpn_gateway_id: The vpn gateway id.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SslVpnServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage ssl vpn server
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_gateway = volcengine.vpn.Gateway("fooGateway",
            vpc_id=foo_vpc.id,
            subnet_id=foo_subnet.id,
            bandwidth=5,
            vpn_gateway_name="acc-test1",
            description="acc-test1",
            period=7,
            project_name="default",
            ssl_enabled=True,
            ssl_max_connections=5)
        foo_ssl_vpn_server = volcengine.vpn.SslVpnServer("fooSslVpnServer",
            vpn_gateway_id=foo_gateway.id,
            local_subnets=[foo_subnet.cidr_block],
            client_ip_pool="172.16.2.0/24",
            ssl_vpn_server_name="acc-test-ssl",
            description="acc-test",
            protocol="UDP",
            cipher="AES-128-CBC",
            auth="SHA1",
            compress=True)
        ```

        ## Import

        SSL VPN server can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpn/sslVpnServer:SslVpnServer default vss-zm55pqtvk17oq32zd****
        ```

        :param str resource_name: The name of the resource.
        :param SslVpnServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SslVpnServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth: Optional[pulumi.Input[str]] = None,
                 cipher: Optional[pulumi.Input[str]] = None,
                 client_ip_pool: Optional[pulumi.Input[str]] = None,
                 compress: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 local_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 ssl_vpn_server_name: Optional[pulumi.Input[str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SslVpnServerArgs.__new__(SslVpnServerArgs)

            __props__.__dict__["auth"] = auth
            __props__.__dict__["cipher"] = cipher
            if client_ip_pool is None and not opts.urn:
                raise TypeError("Missing required property 'client_ip_pool'")
            __props__.__dict__["client_ip_pool"] = client_ip_pool
            __props__.__dict__["compress"] = compress
            __props__.__dict__["description"] = description
            if local_subnets is None and not opts.urn:
                raise TypeError("Missing required property 'local_subnets'")
            __props__.__dict__["local_subnets"] = local_subnets
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["ssl_vpn_server_name"] = ssl_vpn_server_name
            if vpn_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpn_gateway_id'")
            __props__.__dict__["vpn_gateway_id"] = vpn_gateway_id
            __props__.__dict__["ssl_vpn_server_id"] = None
        super(SslVpnServer, __self__).__init__(
            'volcengine:vpn/sslVpnServer:SslVpnServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth: Optional[pulumi.Input[str]] = None,
            cipher: Optional[pulumi.Input[str]] = None,
            client_ip_pool: Optional[pulumi.Input[str]] = None,
            compress: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            local_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            ssl_vpn_server_id: Optional[pulumi.Input[str]] = None,
            ssl_vpn_server_name: Optional[pulumi.Input[str]] = None,
            vpn_gateway_id: Optional[pulumi.Input[str]] = None) -> 'SslVpnServer':
        """
        Get an existing SslVpnServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auth: The authentication algorithm of the SSL server.
               Values:
               `SHA1` (default)
               `MD5`
               `None` (do not use encryption).
        :param pulumi.Input[str] cipher: The encryption algorithm of the SSL server.
               Values:
               `AES-128-CBC` (default)
               `AES-192-CBC`
               `AES-256-CBC`
               `None` (do not use encryption).
        :param pulumi.Input[str] client_ip_pool: SSL client network segment.
        :param pulumi.Input[bool] compress: Whether to compress the transmitted data. The default value is false.
        :param pulumi.Input[str] description: The description of the ssl server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_subnets: The local network segment of the SSL server. The local network segment is the address segment that the client accesses through the SSL VPN connection.
        :param pulumi.Input[str] protocol: The protocol used by the SSL server. Valid values are `TCP`, `UDP`. Default Value: `UDP`.
        :param pulumi.Input[str] ssl_vpn_server_id: The id of the ssl vpn server.
        :param pulumi.Input[str] ssl_vpn_server_name: The name of the SSL server.
        :param pulumi.Input[str] vpn_gateway_id: The vpn gateway id.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SslVpnServerState.__new__(_SslVpnServerState)

        __props__.__dict__["auth"] = auth
        __props__.__dict__["cipher"] = cipher
        __props__.__dict__["client_ip_pool"] = client_ip_pool
        __props__.__dict__["compress"] = compress
        __props__.__dict__["description"] = description
        __props__.__dict__["local_subnets"] = local_subnets
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["ssl_vpn_server_id"] = ssl_vpn_server_id
        __props__.__dict__["ssl_vpn_server_name"] = ssl_vpn_server_name
        __props__.__dict__["vpn_gateway_id"] = vpn_gateway_id
        return SslVpnServer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def auth(self) -> pulumi.Output[Optional[str]]:
        """
        The authentication algorithm of the SSL server.
        Values:
        `SHA1` (default)
        `MD5`
        `None` (do not use encryption).
        """
        return pulumi.get(self, "auth")

    @property
    @pulumi.getter
    def cipher(self) -> pulumi.Output[Optional[str]]:
        """
        The encryption algorithm of the SSL server.
        Values:
        `AES-128-CBC` (default)
        `AES-192-CBC`
        `AES-256-CBC`
        `None` (do not use encryption).
        """
        return pulumi.get(self, "cipher")

    @property
    @pulumi.getter(name="clientIpPool")
    def client_ip_pool(self) -> pulumi.Output[str]:
        """
        SSL client network segment.
        """
        return pulumi.get(self, "client_ip_pool")

    @property
    @pulumi.getter
    def compress(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to compress the transmitted data. The default value is false.
        """
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the ssl server.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="localSubnets")
    def local_subnets(self) -> pulumi.Output[Sequence[str]]:
        """
        The local network segment of the SSL server. The local network segment is the address segment that the client accesses through the SSL VPN connection.
        """
        return pulumi.get(self, "local_subnets")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[str]]:
        """
        The protocol used by the SSL server. Valid values are `TCP`, `UDP`. Default Value: `UDP`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sslVpnServerId")
    def ssl_vpn_server_id(self) -> pulumi.Output[str]:
        """
        The id of the ssl vpn server.
        """
        return pulumi.get(self, "ssl_vpn_server_id")

    @property
    @pulumi.getter(name="sslVpnServerName")
    def ssl_vpn_server_name(self) -> pulumi.Output[str]:
        """
        The name of the SSL server.
        """
        return pulumi.get(self, "ssl_vpn_server_name")

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> pulumi.Output[str]:
        """
        The vpn gateway id.
        """
        return pulumi.get(self, "vpn_gateway_id")

