PMAP = [  # Platforms MAP
    {
        "netmiko": {"platform": "nokia_srl"},
        "containerlab": {
            "platform": "nokia_srlinux",
            "username": "admin",
            "password": "admin",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "nokia_sros"},
        "containerlab": {
            "platform": "nokia_sros",
            "username": "admin",
            "password": "admin",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "arista_eos"},
        "containerlab": {
            "platform": "arista_ceos",
            "username": "admin",
            "password": "admin",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "arista_eos"},
        "containerlab": {
            "platform": "arista_veos",
            "username": "admin",
            "password": "admin",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "arista_eos"},
        "containerlab": {"platform": "ceos", "username": "admin", "password": "admin"},
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "juniper_junos"},
        "containerlab": {
            "platform": "juniper_crpd",
            "username": "root",
            "password": "clab123",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "juniper_junos"},
        "containerlab": {"platform": "crpd", "username": "admin", "password": "admin"},
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "juniper_junos"},
        "containerlab": {
            "platform": "juniper_vmx",
            "username": "admin",
            "password": "admin@123",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "juniper_junos"},
        "containerlab": {
            "platform": "juniper_vqfx",
            "username": "admin",
            "password": "admin@123",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "juniper_junos"},
        "containerlab": {
            "platform": "juniper_vsrx",
            "username": "admin",
            "password": "admin@123",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "juniper_junos"},
        "containerlab": {
            "platform": "juniper_vjunosrouter",
            "username": "admin",
            "password": "admin@123",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "juniper_junos"},
        "containerlab": {
            "platform": "juniper_vjunosswitch",
            "username": "admin",
            "password": "admin@123",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "juniper_junos"},
        "containerlab": {
            "platform": "juniper_vjunosevolved",
            "username": "admin",
            "password": "admin@123",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "cisco_xr"},
        "containerlab": {
            "platform": "cisco_xrd",
            "username": "clab",
            "password": "clab@123",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "cisco_xr"},
        "containerlab": {
            "platform": "xrd",
            "username": "clab",
            "password": "clab@123",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "cisco_xr"},
        "containerlab": {
            "platform": "cisco_xrv9k",
            "username": "clab",
            "password": "clab@123",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "cisco_xr"},
        "containerlab": {
            "platform": "cisco_xrv",
            "username": "clab",
            "password": "clab@123",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "cisco_xe"},
        "containerlab": {
            "platform": "cisco_csr1000v",
            "username": "admin",
            "password": "admin",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "cisco_nxos"},
        "containerlab": {
            "platform": "cisco_n9kv",
            "username": "admin",
            "password": "admin",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "cisco_xe"},
        "containerlab": {
            "platform": "cisco_c8000",
            "username": "cisco",
            "password": "cisco123",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "cisco_xe"},
        "containerlab": {
            "platform": "cisco_c8000v",
            "username": "admin",
            "password": "admin",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "cisco_xe"},
        "containerlab": {
            "platform": "cisco_cat9kv",
            "username": "admin",
            "password": "admin",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "cisco_ios"},
        "containerlab": {
            "platform": "cisco_iol",
            "username": "admin",
            "password": "admin",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "cisco_ftd"},
        "containerlab": {
            "platform": "cisco_ftdv",
            "username": "admin",
            "password": "Admin@123",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "aruba_aoscx"},
        "containerlab": {
            "platform": "aruba_aoscx",
            "username": "admin",
            "password": "admin",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "dell_sonic"},
        "containerlab": {
            "platform": "dell_sonic",
            "username": "admin",
            "password": "admin",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "mikrotik_routeros"},
        "containerlab": {
            "platform": "mikrotik_ros",
            "username": "admin",
            "password": "admin",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "huawei_vrp"},
        "containerlab": {
            "platform": "huawei_vrp",
            "username": "admin",
            "password": "admin",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
    {
        "netmiko": {"platform": "paloalto_panos"},
        "containerlab": {
            "platform": "paloalto_panos",
            "username": "admin",
            "password": "admin",
        },
        "napalm": {},
        "scrapli": {},
        "scrapli_netconf": {},
        "ncclient": {},
        "pyats": {},
    },
]


class PlatformMap:
    """
    A utility to map platform names between:

      - Netmiko
      - NAPALM
      - Scrapli
      - Scrapli Netconf
      - Containerlab
      - Ncclient
      - PyATS
    """

    def __init__(self):
        pass

    @classmethod
    def convert(cls, from_kind: str, to_kind: str, platform: str) -> dict:
        """
        Converts a platform definition from one format to another based on the known mapping.

        Args:
            from_name (str): The key representing the source format in the platform map.
            to_name (str): The key representing the target format in the platform map.
            platform (str): The platform value to be matched in the source format.

        Returns:
            dict: The platform definition in the target format if a match is found.
                  Returns an empty dictionary if no match is found.
        """
        for platform_definition in PMAP:
            if platform_definition.get(from_kind, {}).get("platform") == platform:
                if platform_definition.get(to_kind, {}).get("platform"):
                    return platform_definition[to_kind]

        return {}

    @classmethod
    def get(cls, kind: str, platform: str) -> dict:
        """
        Retrieve the platform definition for a given kind and platform.

        Args:
            kind (str): The type of platform definition to retrieve.
            platform (str): The specific platform to match.

        Returns:
            dict: The platform definition matching the given kind and platform.
                  Returns an empty dictionary if no match is found.
        """
        for platform_definition in PMAP:
            if platform_definition.get(kind, {}).get("platform") == platform:
                return platform_definition[kind]

        return {}
