"""
OD generate constants
"""

import pycityproto.city.geo.v2.geo_pb2 as geov2
import pycityproto.city.map.v2.map_pb2 as mapv2
import pycityproto.city.person.v2.person_pb2 as personv2
import pycityproto.city.trip.v2.trip_pb2 as tripv2
import numpy as np

DIS_CAR = 1000
DIS_BIKE = 500
V_CAR = 20 / 3.6
V_BIKE = 10 / 3.6
HUMAN_MODE_STATS = {
    "HWH": 18.79,
    "HWH+": 20.03,
    "HW+WH": 13.76,
    "HWHWH": 1.09,
    "HSH": 3.1,
    "HSH+": 3.36,
    "HOH": 10.91,
    "HOH+": 11.45,
    "HWHWH+": 1.43,
    "HSOSH": 0.00,
}
BUS_SUBWAY = tripv2.TRIP_MODE_BUS_SUBWAY_WALK
BUS = tripv2.TRIP_MODE_BUS_WALK
SUBWAY = tripv2.TRIP_MODE_SUBWAY_WALK
CAR = tripv2.TRIP_MODE_DRIVE_ONLY
TAXI = tripv2.TRIP_MODE_TAXI
BIKE = tripv2.TRIP_MODE_BIKE_WALK
WALK = tripv2.TRIP_MODE_WALK_ONLY
LANE_TYPE_DRIVING = mapv2.LANE_TYPE_DRIVING
ALL_TRIP_MODES = [
    BUS,
    SUBWAY,
    CAR,
    CAR,
    WALK,
]
TRIP_MODES_DICT = {
    BUS: "bus",
    BUS_SUBWAY: "bus_subway",
    SUBWAY: "subway",
    CAR: "drive",
    TAXI: "taxi",
    WALK: "walk",
}
PT_START_ID = 1_0000_0000
TAXI_START_ID = 2_0000_0000
PRIMARY_SCHOOL, JUNIOR_HIGH_SCHOOL, HIGH_SCHOOL, COLLEGE, BACHELOR, MASTER, DOCTOR = (
    personv2.EDUCATION_PRIMARY_SCHOOL,
    personv2.EDUCATION_JUNIOR_HIGH_SCHOOL,
    personv2.EDUCATION_HIGH_SCHOOL,
    personv2.EDUCATION_COLLEGE,
    personv2.EDUCATION_BACHELOR,
    personv2.EDUCATION_MASTER,
    personv2.EDUCATION_DOCTOR,
)
EDUCATION_LEVELS = [
    PRIMARY_SCHOOL,
    JUNIOR_HIGH_SCHOOL,
    HIGH_SCHOOL,
    COLLEGE,
    BACHELOR,
    MASTER,
    DOCTOR,
]
# probabilities
EDUCATION_STATS = [1 / len(EDUCATION_LEVELS) for _ in range(len(EDUCATION_LEVELS))]
CONSUMPTION_LEVELS = [
    personv2.CONSUMPTION_LOW,
    personv2.CONSUMPTION_RELATIVELY_LOW,
    personv2.CONSUMPTION_MEDIUM,
    personv2.CONSUMPTION_RELATIVELY_HIGH,
    personv2.CONSUMPTION_HIGH,
]
# probabilities
CONSUMPTION_STATS = [
    1 / len(CONSUMPTION_LEVELS) for _ in range(len(CONSUMPTION_LEVELS))
]
GENDERS = [
    personv2.GENDER_FEMALE,
    personv2.GENDER_MALE,
]
# probabilities
GENDER_STATS = [1 / len(GENDERS) for _ in range(len(GENDERS))]
AGES = [i for i in range(8, 75)]
# probabilities
# mean_age: 40 
# std_dev: 15
_age_pdf = [np.exp(-((age - 40) ** 2) / (2 * 15 ** 2)) for age in AGES]
# normalization
AGE_STATS = [p / sum(_age_pdf) for p in _age_pdf]
# work catg
WORK_CATGS = {"business", "industrial", "administrative"}
# education catg
EDUCATION_CATGS = {"education"}
# home catg
HOME_CATGS = {"residential"}
CALIBRATED_MAX_ACC_PDF = [
    0.013941517103511023,
    0.020000714966780662,
    0.02446914993393108,
    0.044291127450010855,
    0.05510474014153518,
    0.06246872098980547,
    0.06765210550968795,
    0.07154858085465843,
    0.072013298066435,
    0.06942160575647946,
    0.06493529707926896,
    0.059448058888193545,
    0.053746335876311384,
    0.04811610780469813,
    0.04237863732268152,
    0.03589046971776978,
    0.030724958907947388,
    0.026542503751886933,
    0.02205619502466213,
    0.01874955316197454,
    0.015228426378451603,
    0.012297133047202986,
    0.012154143116650855,
    0.009312218490746964,
    0.007703581899571955,
    0.006684778725661259,
    0.005844712947435722,
    0.005111889609622139,
    0.003628369198927742,
    0.003556874238653106,
    0.003217273182350018,
    0.0024129548842617985,
    0.0020733538279587094,
    0.0019303639124108685,
    0.0015192678908317145,
    0.0010366769154797838,
    0.0009115607359994576,
    0.0007506970758816708,
    0.0005004647169210186,
    0.00041109601807815313,
    0.0002144848786732916,
]
CALIBRATED_HEADWAY_PDF = [
    0.11953227764297882,
    0.18502092093826158,
    0.18519191637708438,
    0.1633496404396733,
    0.09571688185255992,
    0.04796465382704443,
    0.03797995895331154,
    0.03150869480393995,
    0.02528938981976895,
    0.021159588492459105,
    0.017260169233779227,
    0.014470700453813237,
    0.01240683168297191,
    0.01007789942803244,
    0.009003639816491903,
    0.0070901712664767965,
    0.006725531373957196,
    0.005107411799312519,
    0.005143721798082854,
]
CALIBRATED_BRAKE_ACC_PDF = [
    0.00031900342432624254,
    0.00048795710619575446,
    0.0005391938195280784,
    0.0006489836151576824,
    0.0007471858403394611,
    0.0008508764487738386,
    0.0010173913409883652,
    0.0011857386450307755,
    0.0014474061688294674,
    0.0017127340901684008,
    0.0021232253224230412,
    0.002737441800121722,
    0.0033303155487526357,
    0.004178142403928861,
    0.005271167207030457,
    0.006645378703401679,
    0.008244056222573133,
    0.01007450728127872,
    0.01258199910146314,
    0.015729330182127927,
    0.019265805339864064,
    0.023373191860989666,
    0.028630939085744413,
    0.034590739050817054,
    0.04060238210704911,
    0.04729960832772574,
    0.0543792730604514,
    0.060519003473898735,
    0.06668862344549513,
    0.07172069631791096,
    0.0755115182043653,
    0.07874545951364852,
    0.0807198611276156,
    0.0770052790811016,
    0.07966770264916824,
    0.08140788308171518,
]
CALIBRATED_MAX_ACC_VALUES = [
    1.0,
    1.1,
    1.2,
    1.3,
    1.4,
    1.5,
    1.6,
    1.7,
    1.8,
    1.9,
    2.0,
    2.1,
    2.2,
    2.3,
    2.4,
    2.5,
    2.6,
    2.7,
    2.8,
    2.9,
    3.0,
    3.1,
    3.2,
    3.3,
    3.4,
    3.5,
    3.6,
    3.7,
    3.8,
    3.9,
    4.0,
    4.1,
    4.2,
    4.3,
    4.4,
    4.5,
    4.6,
    4.7,
    4.8,
    4.9,
    5.0,
]
CALIBRATED_HEADWAY_VALUES = [
    1.0,
    1.5,
    2.0,
    2.5,
    3.0,
    3.5,
    4.0,
    4.5,
    5.0,
    5.5,
    6.0,
    6.5,
    7.0,
    7.5,
    8.0,
    8.5,
    9.0,
    9.5,
    10.0,
]
CALIBRATED_BRAKE_ACC_VALUES = [
    -4.0,
    -3.9,
    -3.8,
    -3.7,
    -3.6,
    -3.5,
    -3.4,
    -3.3,
    -3.2,
    -3.1,
    -3.0,
    -2.9,
    -2.8,
    -2.7,
    -2.6,
    -2.5,
    -2.4,
    -2.3,
    -2.2,
    -2.1,
    -2.0,
    -1.9,
    -1.8,
    -1.7,
    -1.6,
    -1.5,
    -1.4,
    -1.3,
    -1.2,
    -1.1,
    -1.0,
    -0.9,
    -0.8,
    -0.7,
    -0.6,
    -0.5,
]
