# generated by datamodel-codegen:
#   filename:  api/dataInsight/createDataInsightChart.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...dataInsight import dataInsightChart
from ...type import basic, entityReferenceList


class CreateDataInsightChart(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies this data insight chart.'),
    ]
    displayName: Annotated[
        Optional[str], Field(None, description='Display Name the data insight chart.')
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the data insight chart.'),
    ]
    dataIndexType: Annotated[
        Optional[dataInsightChart.DataReportIndex],
        Field(None, description='Elasticsearch index name'),
    ]
    dimensions: Annotated[
        Optional[List[dataInsightChart.ChartParameterValues]],
        Field(None, description='Dimensions of the chart'),
    ]
    metrics: Annotated[
        Optional[List[dataInsightChart.ChartParameterValues]],
        Field(None, description='Metrics of the chart'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this chart'),
    ]
    domains: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Fully qualified names of the domains the Data Insight Chart belongs to.',
        ),
    ]
