# generated by datamodel-codegen:
#   filename:  api/services/createDriveService.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.services import driveService
from ...type import basic, entityReferenceList, tagLabel


class CreateDriveServiceRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies this drive service.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this drive service.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of drive service entity.'),
    ]
    serviceType: Annotated[
        driveService.DriveServiceType, Field(description='Type of drive service')
    ]
    connection: Optional[driveService.DriveConnection] = None
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this Drive Service.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this Drive service.'),
    ]
    dataProducts: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified names of data products this entity is part of.',
        ),
    ]
    domains: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='Fully qualified names of the domains the Drive Service belongs to.',
        ),
    ]
