# generated by datamodel-codegen:
#   filename:  auth/personalAccessToken.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import basic
from . import emailVerificationToken


class PersonalAccessToken(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    token: Annotated[basic.Uuid, Field(description='Unique Refresh Token for user')]
    tokenName: Annotated[Optional[str], Field(None, description='Name of the token')]
    userId: Annotated[
        basic.Uuid,
        Field(description='User Id of the User this refresh token is given to'),
    ]
    tokenType: Annotated[
        Optional[emailVerificationToken.TokenType],
        Field('PERSONAL_ACCESS', description='Token Type'),
    ]
    expiryDate: Annotated[
        basic.Timestamp, Field(description='Expiry Date-Time of the token')
    ]
    jwtToken: Annotated[Optional[str], Field(None, description='JWT Auth Token.')]
