# generated by datamodel-codegen:
#   filename:  configuration/authenticationConfiguration.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..entity.services.connections.metadata import openMetadataConnection
from ..security.client import oidcClientConfig, samlSSOClientConfig
from . import ldapConfiguration


class ClientType(Enum):
    public = 'public'
    confidential = 'confidential'


class TokenValidationAlgorithm(Enum):
    RS256 = 'RS256'
    RS384 = 'RS384'
    RS512 = 'RS512'


class ResponseType(Enum):
    id_token = 'id_token'
    code = 'code'


class AuthenticationConfiguration(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    clientType: Annotated[
        Optional[ClientType], Field(ClientType.public, description='Client Type')
    ]
    provider: openMetadataConnection.AuthProvider
    responseType: Annotated[
        Optional[ResponseType],
        Field(
            ResponseType.id_token,
            description='This is used by auth provider provide response as either id_token or code.',
        ),
    ]
    providerName: Annotated[
        str, Field(description='Custom OIDC Authentication Provider Name')
    ]
    publicKeyUrls: Annotated[List[str], Field(description='List of Public Key URLs')]
    tokenValidationAlgorithm: Annotated[
        Optional[TokenValidationAlgorithm],
        Field(
            TokenValidationAlgorithm.RS256,
            description='Token Validation Algorithm to use.',
        ),
    ]
    authority: Annotated[str, Field(description='Authentication Authority')]
    clientId: Annotated[str, Field(description='Client ID')]
    callbackUrl: Annotated[str, Field(description='Callback URL')]
    jwtPrincipalClaims: Annotated[List[str], Field(description='Jwt Principal Claim')]
    jwtPrincipalClaimsMapping: Annotated[
        Optional[List[str]], Field(None, description='Jwt Principal Claim Mapping')
    ]
    enableSelfSignup: Annotated[
        Optional[bool], Field(False, description='Enable Self Sign Up')
    ]
    ldapConfiguration: Annotated[
        Optional[ldapConfiguration.LdapConfiguration],
        Field(None, description='LDAP Configuration in case the Provider is LDAP'),
    ]
    samlConfiguration: Annotated[
        Optional[samlSSOClientConfig.SamlSSOClientConfig],
        Field(
            None,
            description='Saml Configuration that is applicable only when the provider is Saml',
        ),
    ]
    oidcConfiguration: Annotated[
        Optional[oidcClientConfig.OidcClientConfig],
        Field(None, description='Oidc Configuration for Confidential Client Type'),
    ]
