# generated by datamodel-codegen:
#   filename:  configuration/lineageSettings.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from enum import Enum

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class LineageLayer(Enum):
    EntityLineage = 'EntityLineage'
    ColumnLevelLineage = 'ColumnLevelLineage'
    DataObservability = 'DataObservability'


class LineageSettings(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    upstreamDepth: Annotated[
        int, Field(description='Upstream Depth for Lineage.', ge=1, le=5)
    ]
    downstreamDepth: Annotated[
        int, Field(description='DownStream Depth for Lineage.', ge=1, le=5)
    ]
    lineageLayer: Annotated[LineageLayer, Field(description='Lineage Layer.')]
