# generated by datamodel-codegen:
#   filename:  entity/applications/configuration/external/automator/removeTermsAction.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ......type import basic, tagLabel


class RemoveTermsActionType(Enum):
    RemoveTermsAction = 'RemoveTermsAction'


class LabelType(Enum):
    Manual = 'Manual'
    Propagated = 'Propagated'
    Automated = 'Automated'


class RemoveTermsAction(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        RemoveTermsActionType,
        Field(description='Application Type', title='Application Type'),
    ]
    terms: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Glossary Terms to remove'),
    ]
    labels: Annotated[
        Optional[List[LabelType]],
        Field(None, description='Remove terms by its label type'),
    ]
    applyToChildren: Annotated[
        Optional[List[basic.EntityName]],
        Field(
            None,
            description='Remove terms from the children of the selected assets. E.g., columns, tasks, topic fields,...',
            title='Apply to Children',
        ),
    ]
    applyToAll: Annotated[
        Optional[bool],
        Field(
            None,
            description='Remove terms from all the children and parent of the selected assets.',
            title='Apply to All',
        ),
    ]
