# generated by datamodel-codegen:
#   filename:  entity/applications/marketplace/createAppMarketPlaceDefinitionReq.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ....events.api import createEventSubscription
from ....type import basic, entityReferenceList, tagLabel
from .. import app
from ..configuration import applicationConfig


class CreateAppMarketPlaceDefinitionRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[basic.EntityName, Field(description='Name of the Application.')]
    displayName: Annotated[
        Optional[str], Field(None, description='Display Name for the application.')
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the Application.'),
    ]
    features: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Features of the Application.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this workflow.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags associated with the entity.'),
    ]
    developer: Annotated[
        Optional[str], Field(None, description='Developer For the Application.')
    ]
    developerUrl: Annotated[
        Optional[str], Field(None, description='Url for the developer')
    ]
    privacyPolicyUrl: Annotated[
        Optional[str], Field(None, description='Privacy Policy for the developer')
    ]
    supportEmail: Annotated[
        Optional[str], Field(None, description='Support Email for the application')
    ]
    className: Annotated[
        str,
        Field(
            description="Full Qualified ClassName for the the application. Use can use 'org.openmetadata.service.apps.AbstractNativeApplication' if you don't have one yet."
        ),
    ]
    sourcePythonClass: Annotated[
        Optional[str],
        Field(
            None,
            description='Fully Qualified class name for the Python source that will execute the external application.',
        ),
    ]
    appType: Annotated[
        app.AppType, Field(description='This schema defines the type of application.')
    ]
    agentType: Annotated[
        Optional[app.AgentType],
        Field(None, description='This schema defines the type of the agent.'),
    ]
    scheduleType: Annotated[
        app.ScheduleType,
        Field(description='This schema defines the Schedule Type of Application.'),
    ]
    permission: Annotated[
        app.Permissions, Field(description='Permission used by Native Applications.')
    ]
    runtime: Annotated[
        Optional[app.ExecutionContext],
        Field(
            None,
            description='If app type is live, user can provide additional runtime context.',
        ),
    ]
    allowConfiguration: Annotated[
        Optional[bool],
        Field(
            True,
            description='Allow users to configure the app from the UI. If `false`, the `configure` step will be hidden.',
        ),
    ]
    appConfiguration: Annotated[
        Optional[applicationConfig.AppConfig],
        Field(None, description='Application Configuration object.'),
    ]
    appLogoUrl: Annotated[
        Optional[AnyUrl], Field(None, description='Application Logo Url.')
    ]
    appScreenshots: Annotated[
        Optional[List[str]], Field(None, description='Application Screenshots.')
    ]
    system: Annotated[
        Optional[bool],
        Field(False, description='A system app cannot be uninstalled or modified.'),
    ]
    domains: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Fully qualified names of the domains the Application belongs to.',
        ),
    ]
    supportsInterrupt: Annotated[
        Optional[bool],
        Field(
            False,
            description='If the app run can be interrupted as part of the execution.',
        ),
    ]
    eventSubscriptions: Annotated[
        Optional[List[createEventSubscription.CreateEventSubscription]],
        Field(
            [],
            description='Event subscriptions that will be created when the application is installed.',
        ),
    ]
    enabled: Annotated[
        Optional[bool],
        Field(
            True,
            description='The app will be installable only if this flag is set to true.',
        ),
    ]
    supportsIngestionRunner: Annotated[
        Optional[bool],
        Field(
            False,
            description='If the app support execution through the external runner.',
        ),
    ]
