# generated by datamodel-codegen:
#   filename:  entity/classification/classification.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityHistory, entityReferenceList


class Classification(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid, Field(description='Unique identifier of this entity instance.')
    ]
    name: basic.EntityName
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this entity.'),
    ]
    description: Annotated[
        basic.Markdown, Field(description='Description of the classification.')
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    termCount: Annotated[
        Optional[int],
        Field(
            None,
            description='Total number of children tag terms under this classification. This includes all the children in the hierarchy.',
            ge=0,
        ),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(
            None,
            description='Link to the resource corresponding to the classification.',
        ),
    ]
    usageCount: Annotated[
        Optional[int],
        Field(
            None,
            description='Count of how many times the tags from this classification are used.',
        ),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    disabled: Annotated[
        Optional[bool],
        Field(
            False,
            description="System classifications can't be deleted. Use this flag to disable them.",
        ),
    ]
    mutuallyExclusive: Annotated[
        Optional[bool],
        Field(
            'false',
            description='Tags under this classification are mutually exclusive. When mutually exclusive is `true` the tags from this classification are used to **classify** an entity. An entity can only be in one class - example, it can only be either `tier1` or `tier2` and not both. When mutually exclusive is `false`, the tags from this classification are used to **categorize** an entity. An entity have multiple tags simultaneously - example a customer can be `newCustomer` and `atRisk` simultaneously.',
        ),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Domains the asset belongs to. When not set, the asset inherits the domain from the parent it belongs to.',
        ),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this Classification.'),
    ]
