# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/grafanaConnection.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class GrafanaType(Enum):
    Grafana = 'Grafana'


class GrafanaConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[GrafanaType],
        Field(GrafanaType.Grafana, description='Service Type', title='Service Type'),
    ]
    hostPort: Annotated[
        AnyUrl, Field(description='URL to the Grafana instance.', title='Host and Port')
    ]
    apiKey: Annotated[
        CustomSecretStr,
        Field(
            description='Service Account Token to authenticate to the Grafana APIs. Use Service Account Tokens (format: glsa_xxxx) for authentication. Legacy API Keys are no longer supported by Grafana as of January 2025. Both self-hosted and Grafana Cloud are supported. Requires Admin role for full metadata extraction.',
            title='Service Account Token',
        ),
    ]
    verifySSL: Annotated[
        Optional[bool],
        Field(
            True,
            description='Boolean marking if we need to verify the SSL certs for Grafana. Default to True.',
            title='Verify SSL',
        ),
    ]
    dashboardFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to exclude or include dashboards that matches the pattern.',
            title='Default Dashboard Filter Pattern',
        ),
    ]
    chartFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude or include charts that matches the pattern.',
            title='Default Chart Filter Pattern',
        ),
    ]
    pageSize: Annotated[
        Optional[int],
        Field(
            100,
            description='Page size for pagination in API requests. Default is 100.',
            ge=1,
            title='Page Size',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
