# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/modeConnection.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class ModeType(Enum):
    Mode = 'Mode'


class ModeConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[ModeType],
        Field(ModeType.Mode, description='Service Type', title='Service Type'),
    ]
    hostPort: Annotated[
        Optional[AnyUrl],
        Field(
            'https://app.mode.com',
            description='URL for the mode instance.',
            title='Host and Port',
        ),
    ]
    accessToken: Annotated[
        str, Field(description='Access Token for Mode Dashboard', title='Access Token')
    ]
    accessTokenPassword: Annotated[
        CustomSecretStr,
        Field(
            description='Access Token Password for Mode Dashboard',
            title='Access Token Password',
        ),
    ]
    workspaceName: Annotated[
        str, Field(description='Mode Workspace Name', title='Workspace Name')
    ]
    filterQueryParam: Annotated[
        Optional[str],
        Field(
            None,
            description='Filter query parameter for some of the Mode API calls',
            title='Filter Query Param',
        ),
    ]
    dashboardFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to exclude or include dashboards that matches the pattern.',
            title='Default Dashboard Filter Pattern',
        ),
    ]
    chartFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude or include charts that matches the pattern.',
            title='Default Chart Filter Pattern',
        ),
    ]
    dataModelFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude or include data models that matches the pattern.',
            title='Default Data Model Filter Pattern',
        ),
    ]
    projectFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to exclude or include projects that matches the pattern.',
            title='Default Project Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
