# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/sigmaConnection.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class SigmaType(Enum):
    Sigma = 'Sigma'


class SigmaConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[SigmaType],
        Field(SigmaType.Sigma, description='Service Type', title='Service Type'),
    ]
    hostPort: Annotated[
        AnyUrl, Field(description='Sigma API url.', title='Host and Port')
    ]
    clientId: Annotated[
        str, Field(description='client_id for Sigma.', title='Client ID')
    ]
    clientSecret: Annotated[
        CustomSecretStr,
        Field(description='clientSecret for Sigma.', title='Client Secret'),
    ]
    apiVersion: Annotated[
        Optional[str],
        Field('v2', description='Sigma API version.', title='API Version'),
    ]
    dashboardFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to exclude or include dashboards that matches the pattern.',
            title='Default Dashboard Filter Pattern',
        ),
    ]
    chartFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude or include charts that matches the pattern.',
            title='Default Chart Filter Pattern',
        ),
    ]
    dataModelFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude or include data models that matches the pattern.',
            title='Default Data Model Filter Pattern',
        ),
    ]
    projectFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to exclude or include projects that matches the pattern.',
            title='Default Project Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
