# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/customDatabaseConnection.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....type import filterPattern
from .. import connectionBasicType


class CustomDatabaseType(Enum):
    CustomDatabase = 'CustomDatabase'


class CustomDatabaseConnection(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    type: Annotated[
        CustomDatabaseType,
        Field(description='Custom database service type', title='Service Type'),
    ]
    sourcePythonClass: Annotated[
        Optional[str],
        Field(
            None,
            description='Source Python Class Name to instantiated by the ingestion workflow',
            title='Source Python Class Name',
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    schemaFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude schemas that matches the pattern.',
            title='Default Schema Filter Pattern',
        ),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude tables that matches the pattern.',
            title='Default Table Filter Pattern',
        ),
    ]
    databaseFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude databases that matches the pattern.',
            title='Default Database Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
