# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/serviceNowConnection.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class ServiceNowType(Enum):
    ServiceNow = 'ServiceNow'


class ServiceNowConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[ServiceNowType],
        Field(
            ServiceNowType.ServiceNow, description='Service Type', title='Service Type'
        ),
    ]
    hostPort: Annotated[
        AnyUrl,
        Field(
            description='ServiceNow instance URL (e.g., https://your-instance.service-now.com)',
            title='ServiceNow Instance URL',
        ),
    ]
    username: Annotated[
        str,
        Field(
            description='Username to connect to ServiceNow. This user should have read access to sys_db_object and sys_dictionary tables.',
            title='Username',
        ),
    ]
    password: Annotated[
        CustomSecretStr,
        Field(description='Password to connect to ServiceNow.', title='Password'),
    ]
    includeScopes: Annotated[
        Optional[bool],
        Field(
            False,
            description='If true, ServiceNow application scopes will be imported as database schemas. Otherwise, a single default schema will be used.',
            title='Include Scopes as Schemas',
        ),
    ]
    includeSystemTables: Annotated[
        Optional[bool],
        Field(
            False,
            description='If true, both admin and system tables (sys_* tables) will be fetched. If false, only admin tables will be fetched.',
            title='Include System Tables',
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude tables that matches the pattern.',
            title='Default Table Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
    supportsLineageExtraction: Annotated[
        Optional[connectionBasicType.SupportsLineageExtraction],
        Field(None, title='Supports Lineage Extraction'),
    ]
