# generated by datamodel-codegen:
#   filename:  entity/services/connections/metadata/amundsenConnection.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class AmundsenType(Enum):
    Amundsen = 'Amundsen'


class AmundsenConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[AmundsenType], Field(AmundsenType.Amundsen, description='Service Type')
    ]
    username: Annotated[
        str, Field(description='username to connect to the Amundsen Neo4j Connection.')
    ]
    password: Annotated[
        CustomSecretStr,
        Field(description='password to connect to the Amundsen Neo4j Connection.'),
    ]
    hostPort: Annotated[
        AnyUrl,
        Field(
            description='Host and port of the Amundsen Neo4j Connection. This expect a URI format like: bolt://localhost:7687.',
            title='Host and Port',
        ),
    ]
    maxConnectionLifeTime: Annotated[
        Optional[int],
        Field(
            50,
            description='Maximum connection lifetime for the Amundsen Neo4j Connection.',
        ),
    ]
    validateSSL: Annotated[
        Optional[bool],
        Field(
            False,
            description='Enable SSL validation for the Amundsen Neo4j Connection.',
        ),
    ]
    encrypted: Annotated[
        Optional[bool],
        Field(
            False, description='Enable encryption for the Amundsen Neo4j Connection.'
        ),
    ]
    schemaFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude schemas that matches the pattern.',
            title='Default Schema Filter Pattern',
        ),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude tables that matches the pattern.',
            title='Default Table Filter Pattern',
        ),
    ]
    databaseFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude databases that matches the pattern.',
            title='Default Database Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
