# generated by datamodel-codegen:
#   filename:  entity/services/connections/mlmodel/vertexaiConnection.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.credentials import gcpCredentials
from .....type import filterPattern
from .. import connectionBasicType


class VertexAIType(Enum):
    VertexAI = 'VertexAI'


class VertexAIConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[VertexAIType],
        Field(VertexAIType.VertexAI, description='Service Type', title='Service Type'),
    ]
    credentials: Annotated[
        gcpCredentials.GCPCredentials,
        Field(description='GCP Credentials', title='GCP Credentials'),
    ]
    location: Annotated[
        str,
        Field(
            description='location/region of google cloud project',
            title='Project location',
        ),
    ]
    mlModelFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only fetch MlModels with names matching the pattern.',
            title='Default ML Model Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
