# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/stitchConnection.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class StitchType(Enum):
    Stitch = 'Stitch'


class StitchConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[StitchType],
        Field(StitchType.Stitch, description='Service Type', title='Service Type'),
    ]
    hostPort: Annotated[
        str,
        Field(
            description='Host and port of the Stitch API host', title='Host and Port'
        ),
    ]
    token: Annotated[
        CustomSecretStr,
        Field(description='Token to connect to Stitch api doc', title='JWT Token'),
    ]
    pipelineFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude pipelines.',
            title='Default Pipeline Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
