# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/wherescapeConnection.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .. import connectionBasicType
from ..database import mssqlConnection


class WherescapeType(Enum):
    Wherescape = 'Wherescape'


class WherescapeConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[WherescapeType],
        Field(
            WherescapeType.Wherescape, description='Service Type', title='Service Type'
        ),
    ]
    hostPort: Annotated[
        Optional[AnyUrl],
        Field(
            None,
            description='Pipeline Service Management/UI URI.',
            title='Host And Port',
        ),
    ]
    databaseConnection: Annotated[
        mssqlConnection.MssqlConnection,
        Field(
            description='Underlying database connection',
            title='Metadata Database Connection',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
