# generated by datamodel-codegen:
#   filename:  events/subscriptionStatus.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import basic


class Status(Enum):
    disabled = 'disabled'
    failed = 'failed'
    retryLimitReached = 'retryLimitReached'
    awaitingRetry = 'awaitingRetry'
    active = 'active'


class SubscriptionStatus(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    status: Annotated[
        Optional[Status],
        Field(
            None,
            description='Status is `disabled` when the event subscription was created with `enabled` set to false and it never started publishing events. Status is `active` when the event subscription is functioning normally and a 200 OK response was received for the callback notification. Status is `failed` when a bad callback URL, connection failures, or `1xx` or `3xx` response was received for the callback notification. Status is `awaitingRetry` when the previous attempt at callback timed out or received a `4xx` or `5xx` response. Status is `retryLimitReached` after all retries fail.',
        ),
    ]
    lastSuccessfulAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Timestamp of the last successful callback in UNIX UTC epoch time in milliseconds.',
        ),
    ]
    lastFailedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Timestamp of the last failed callback in UNIX UTC epoch time in milliseconds.',
        ),
    ]
    lastFailedStatusCode: Annotated[
        Optional[int],
        Field(
            None,
            description='HTTP status code received during the last failed callback attempt.',
        ),
    ]
    lastFailedReason: Annotated[
        Optional[str],
        Field(
            None,
            description='Detailed reason for the last failure received during callback.',
        ),
    ]
    nextAttempt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Timestamp for the next retry attempt in UNIX epoch time in milliseconds. Only valid if `status` is `awaitingRetry`.',
        ),
    ]
    timestamp: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Current timestamp of this status in UNIX epoch time in milliseconds.',
        ),
    ]
