# generated by datamodel-codegen:
#   filename:  metadataIngestion/metadataToElasticSearchPipeline.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..configuration import elasticSearchConfiguration


class MetadataToESConfigType(Enum):
    MetadataToElasticSearch = 'MetadataToElasticSearch'


class MetadataToElasticSearchPipeline(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[MetadataToESConfigType, Field(description='Pipeline type')]
    regionName: Annotated[
        Optional[str],
        Field(
            None,
            description='Region name. Required when using AWS Credentials.',
            title='AWS Region Name',
        ),
    ]
    caCerts: Annotated[
        Optional[str],
        Field(
            None,
            description='Certificate path to be added in configuration. The path should be local in the Ingestion Container.',
            title='CA Certificates',
        ),
    ]
    timeout: Annotated[Optional[int], Field(30, description='Connection Timeout')]
    useSSL: Annotated[
        Optional[bool],
        Field(
            False,
            description='Indicates whether to use SSL when connecting to ElasticSearch. By default, we will ignore SSL settings.',
            title='Use SSL',
        ),
    ]
    verifyCerts: Annotated[
        Optional[bool],
        Field(
            False,
            description='Indicates whether to verify certificates when using SSL connection to ElasticSearch. Ignored by default. Is set to true, make sure to send the certificates in the property `CA Certificates`.',
            title='Validate Certificates',
        ),
    ]
    useAwsCredentials: Annotated[
        Optional[bool],
        Field(
            False,
            description='Indicates whether to use aws credentials when connecting to OpenSearch in AWS.',
            title='Use AWS Credentials',
        ),
    ]
    searchIndexMappingLanguage: Annotated[
        Optional[elasticSearchConfiguration.SearchIndexMappingLanguage],
        Field(
            elasticSearchConfiguration.SearchIndexMappingLanguage.EN,
            description='Recreate Indexes with updated Language',
        ),
    ]
    batchSize: Annotated[
        Optional[int],
        Field(
            1000,
            description='Maximum number of events entities in a batch (Default 1000).',
            title='Batch Size',
        ),
    ]
    recreateIndex: Annotated[Optional[bool], Field(True, title='Recreate Indexes')]
