# generated by datamodel-codegen:
#   filename:  security/credentials/gcpCredentials.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from typing import Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated, Literal

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import gcpExternalAccount, gcpValues


class GCPImpersonateServiceAccountValues(BaseModel):
    impersonateServiceAccount: Annotated[
        Optional[str],
        Field(
            None,
            description='The impersonated service account email',
            title='Target Service Account Email',
        ),
    ]
    lifetime: Annotated[
        Optional[int],
        Field(
            3600,
            description='Number of seconds the delegated credential should be valid',
            title='Lifetime',
        ),
    ]


class GcpADC(BaseModel):
    type: Annotated[
        Literal['gcp_adc'],
        Field(
            'gcp_adc',
            description='Google Cloud Platform ADC ( Application Default Credentials )',
            title='Credentials Type',
        ),
    ]
    projectId: Annotated[
        Optional[Union[gcpValues.SingleProjectId, gcpValues.MultipleProjectId]],
        Field(
            None,
            description='GCP Project ID to parse metadata from',
            title='GCP Project ID',
        ),
    ]


class GcpCredentialsPath(BaseModel):
    type: Annotated[
        Literal['gcp_credential_path'],
        Field(
            'gcp_credential_path',
            description='Google Cloud Platform account type.',
            title='Credentials Type',
        ),
    ]
    path: Annotated[
        Optional[str],
        Field(
            None,
            description='Path of the file containing the GCP credentials info',
            title='Path',
        ),
    ]
    projectId: Annotated[
        Optional[Union[gcpValues.SingleProjectId, gcpValues.MultipleProjectId]],
        Field(
            None,
            description='GCP Project ID to parse metadata from',
            title='GCP Project ID',
        ),
    ]


class GCPCredentials(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    gcpConfig: Annotated[
        Union[
            gcpValues.GcpCredentialsValues,
            GcpCredentialsPath,
            gcpExternalAccount.GcpExternalAccount,
            GcpADC,
        ],
        Field(
            description='We support two ways of authenticating to GCP i.e via GCP Credentials Values or GCP Credentials Path',
            title='GCP Credentials Configuration',
        ),
    ]
    gcpImpersonateServiceAccount: Annotated[
        Optional[GCPImpersonateServiceAccountValues],
        Field(
            None,
            description='we enable the authenticated service account to impersonate another service account',
            title='GCP Impersonate Service Account Configuration',
        ),
    ]
