# generated by datamodel-codegen:
#   filename:  system/ui/page.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import entityReference, entityReferenceList
from . import tab


class EntityType(Enum):
    Page = 'Page'


class PageType(Enum):
    LandingPage = 'LandingPage'
    Table = 'Table'
    StoredProcedure = 'StoredProcedure'
    Database = 'Database'
    DatabaseSchema = 'DatabaseSchema'
    Topic = 'Topic'
    Pipeline = 'Pipeline'
    Dashboard = 'Dashboard'
    DashboardDataModel = 'DashboardDataModel'
    Container = 'Container'
    SearchIndex = 'SearchIndex'
    Glossary = 'Glossary'
    GlossaryTerm = 'GlossaryTerm'
    Domain = 'Domain'
    APICollection = 'APICollection'
    APIEndpoint = 'APIEndpoint'
    Metric = 'Metric'
    MlModel = 'MlModel'
    Chart = 'Chart'


class Team(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    entityType: Annotated[EntityType, Field(description='Entity Type.')]
    pageType: PageType
    layout: Annotated[
        Dict[str, Any], Field(description='Configuration for the Knowledge Panel.')
    ]
    tabs: Annotated[
        Optional[List[tab.Tab]], Field([], description='Tabs included in this page.')
    ]
    persona: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Persona this page belongs to.'),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Domains this page belongs to.'),
    ]
    knowledgePanels: Annotated[
        entityReferenceList.EntityReferenceList,
        Field(description='KnowledgePanels that are part of this Page.'),
    ]
