# generated by datamodel-codegen:
#   filename:  type/bulkOperationResult.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from typing import Any, List, Optional

from pydantic import ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import basic


class RowCount(RootModel[int]):
    root: Annotated[int, Field(description='Type used to indicate row count', ge=0)]


class Index(RootModel[int]):
    root: Annotated[
        int,
        Field(
            description='Type used to indicate row number or field number. In CSV the indexes start with 1.',
            ge=1,
        ),
    ]


class Response(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    request: Annotated[
        Optional[Any],
        Field(None, description='Request that can be processed successfully.'),
    ]
    message: Annotated[
        Optional[str], Field(None, description='Message for the request.')
    ]


class BulkOperationResult(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    dryRun: Annotated[
        Optional[bool],
        Field(None, description='True if the operation has dryRun flag enabled'),
    ]
    status: Optional[basic.Status] = None
    abortReason: Annotated[
        Optional[str],
        Field(
            None,
            description='Reason why import was aborted. This is set only when the `status` field is set to `aborted`',
        ),
    ]
    numberOfRowsProcessed: Optional[RowCount] = None
    numberOfRowsPassed: Optional[RowCount] = None
    numberOfRowsFailed: Optional[RowCount] = None
    successRequest: Annotated[
        Optional[List[Response]],
        Field(None, description='Request that can be processed successfully.'),
    ]
    failedRequest: Annotated[
        Optional[List[Response]],
        Field(None, description='Failure Request that can be processed successfully.'),
    ]
