# generated by datamodel-codegen:
#   filename:  type/tableUsageCount.json
#   timestamp: 2025-10-23T04:50:45+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..api.data import createQuery


class TableColumn(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    table: Annotated[Optional[str], Field(None, description='Name of the table')]
    column: Annotated[Optional[str], Field(None, description='Name of the column')]


class TableColumnJoin(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    tableColumn: Annotated[
        Optional[TableColumn], Field(None, description='Source table column')
    ]
    joinedWith: Annotated[
        Optional[List[TableColumn]],
        Field(
            None,
            description='List of table columns with which the table is joined with',
        ),
    ]


class QueryCostWrapper(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    cost: Annotated[float, Field(description='Avg query cost per execution')]
    count: Annotated[float, Field(description='Number of times the query was executed')]
    date: Annotated[
        Optional[str], Field(None, description='Date of execution of SQL query')
    ]
    queryHash: Annotated[Optional[str], Field(None, description='Hash of the query')]
    query: Annotated[Optional[str], Field(None, description='SQL query')]
    dialect: Annotated[Optional[str], Field(None, description='SQL dialect')]
    totalDuration: Annotated[
        Optional[float], Field(None, description='Total duration of the query')
    ]


class TableUsageCount(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    table: Annotated[str, Field(description='Name of the table')]
    date: Annotated[str, Field(description='Date of execution of SQL query')]
    databaseName: Annotated[
        Optional[str],
        Field(None, description='Database associated with the table in the query'),
    ]
    count: Annotated[Optional[int], Field(1, description='Usage count of table')]
    databaseSchema: Annotated[
        Optional[str],
        Field(None, description='Database schema of the associated with table'),
    ]
    sqlQueries: Annotated[
        Optional[List[createQuery.CreateQueryRequest]],
        Field(None, description='List of SQL Queries associated with table'),
    ]
    joins: Annotated[
        Optional[List[TableColumnJoin]],
        Field(None, description='List of joins associated with table'),
    ]
    serviceName: Annotated[
        str, Field(description='Name that identifies this database service.')
    ]
