# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LetsEncryptCertificateArgs', 'LetsEncryptCertificate']

@pulumi.input_type
class LetsEncryptCertificateArgs:
    def __init__(__self__, *,
                 auto_renew: pulumi.Input[_builtins.bool],
                 domain_id: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 alternate_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LetsEncryptCertificate resource.
        :param pulumi.Input[_builtins.bool] auto_renew: True if the certificate should auto-renew
        :param pulumi.Input[_builtins.str] domain_id: The domain to be issued the certificate for
        :param pulumi.Input[_builtins.str] name: The certificate name; use `""` for the root domain. Wildcard names are supported.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alternate_names: The certificate alternate names
        :param pulumi.Input[_builtins.str] signature_algorithm: The signature algorithm to use for the certificate
        """
        pulumi.set(__self__, "auto_renew", auto_renew)
        pulumi.set(__self__, "domain_id", domain_id)
        pulumi.set(__self__, "name", name)
        if alternate_names is not None:
            pulumi.set(__self__, "alternate_names", alternate_names)
        if signature_algorithm is not None:
            pulumi.set(__self__, "signature_algorithm", signature_algorithm)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Input[_builtins.bool]:
        """
        True if the certificate should auto-renew
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Input[_builtins.str]:
        """
        The domain to be issued the certificate for
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The certificate name; use `""` for the root domain. Wildcard names are supported.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="alternateNames")
    def alternate_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The certificate alternate names
        """
        return pulumi.get(self, "alternate_names")

    @alternate_names.setter
    def alternate_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alternate_names", value)

    @_builtins.property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The signature algorithm to use for the certificate
        """
        return pulumi.get(self, "signature_algorithm")

    @signature_algorithm.setter
    def signature_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signature_algorithm", value)


@pulumi.input_type
class _LetsEncryptCertificateState:
    def __init__(__self__, *,
                 alternate_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authority_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 csr: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 years: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering LetsEncryptCertificate resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alternate_names: The certificate alternate names
        :param pulumi.Input[_builtins.str] authority_identifier: The identifying certification authority (CA)
        :param pulumi.Input[_builtins.bool] auto_renew: True if the certificate should auto-renew
        :param pulumi.Input[_builtins.str] created_at: The datetime the certificate was created
        :param pulumi.Input[_builtins.str] csr: The certificate signing request
        :param pulumi.Input[_builtins.str] domain_id: The domain to be issued the certificate for
        :param pulumi.Input[_builtins.str] expires_at: The datetime the certificate will expire
        :param pulumi.Input[_builtins.str] name: The certificate name; use `""` for the root domain. Wildcard names are supported.
        :param pulumi.Input[_builtins.str] signature_algorithm: The signature algorithm to use for the certificate
        :param pulumi.Input[_builtins.str] state: The state of the certificate
        :param pulumi.Input[_builtins.str] updated_at: The datetime the certificate was last updated
        :param pulumi.Input[_builtins.int] years: The years the certificate will last
        """
        if alternate_names is not None:
            pulumi.set(__self__, "alternate_names", alternate_names)
        if authority_identifier is not None:
            pulumi.set(__self__, "authority_identifier", authority_identifier)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if csr is not None:
            pulumi.set(__self__, "csr", csr)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if signature_algorithm is not None:
            pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if years is not None:
            pulumi.set(__self__, "years", years)

    @_builtins.property
    @pulumi.getter(name="alternateNames")
    def alternate_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The certificate alternate names
        """
        return pulumi.get(self, "alternate_names")

    @alternate_names.setter
    def alternate_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alternate_names", value)

    @_builtins.property
    @pulumi.getter(name="authorityIdentifier")
    def authority_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifying certification authority (CA)
        """
        return pulumi.get(self, "authority_identifier")

    @authority_identifier.setter
    def authority_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authority_identifier", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if the certificate should auto-renew
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The datetime the certificate was created
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def csr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate signing request
        """
        return pulumi.get(self, "csr")

    @csr.setter
    def csr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "csr", value)

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain to be issued the certificate for
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_id", value)

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The datetime the certificate will expire
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expires_at", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate name; use `""` for the root domain. Wildcard names are supported.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The signature algorithm to use for the certificate
        """
        return pulumi.get(self, "signature_algorithm")

    @signature_algorithm.setter
    def signature_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signature_algorithm", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the certificate
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The datetime the certificate was last updated
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter
    def years(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The years the certificate will last
        """
        return pulumi.get(self, "years")

    @years.setter
    def years(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "years", value)


@pulumi.type_token("dnsimple:index/letsEncryptCertificate:LetsEncryptCertificate")
class LetsEncryptCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alternate_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a DNSimple Let's Encrypt certificate resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dnsimple as dnsimple

        foobar = dnsimple.LetsEncryptCertificate("foobar",
            domain_id=dnsimple["domainId"],
            auto_renew=False,
            name="www",
            alternate_names=[
                "docs.example.com",
                "status.example.com",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alternate_names: The certificate alternate names
        :param pulumi.Input[_builtins.bool] auto_renew: True if the certificate should auto-renew
        :param pulumi.Input[_builtins.str] domain_id: The domain to be issued the certificate for
        :param pulumi.Input[_builtins.str] name: The certificate name; use `""` for the root domain. Wildcard names are supported.
        :param pulumi.Input[_builtins.str] signature_algorithm: The signature algorithm to use for the certificate
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LetsEncryptCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DNSimple Let's Encrypt certificate resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dnsimple as dnsimple

        foobar = dnsimple.LetsEncryptCertificate("foobar",
            domain_id=dnsimple["domainId"],
            auto_renew=False,
            name="www",
            alternate_names=[
                "docs.example.com",
                "status.example.com",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param LetsEncryptCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LetsEncryptCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alternate_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LetsEncryptCertificateArgs.__new__(LetsEncryptCertificateArgs)

            __props__.__dict__["alternate_names"] = alternate_names
            if auto_renew is None and not opts.urn:
                raise TypeError("Missing required property 'auto_renew'")
            __props__.__dict__["auto_renew"] = auto_renew
            if domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'domain_id'")
            __props__.__dict__["domain_id"] = domain_id
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["signature_algorithm"] = signature_algorithm
            __props__.__dict__["authority_identifier"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["csr"] = None
            __props__.__dict__["expires_at"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["years"] = None
        super(LetsEncryptCertificate, __self__).__init__(
            'dnsimple:index/letsEncryptCertificate:LetsEncryptCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alternate_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            authority_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            csr: Optional[pulumi.Input[_builtins.str]] = None,
            domain_id: Optional[pulumi.Input[_builtins.str]] = None,
            expires_at: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            years: Optional[pulumi.Input[_builtins.int]] = None) -> 'LetsEncryptCertificate':
        """
        Get an existing LetsEncryptCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alternate_names: The certificate alternate names
        :param pulumi.Input[_builtins.str] authority_identifier: The identifying certification authority (CA)
        :param pulumi.Input[_builtins.bool] auto_renew: True if the certificate should auto-renew
        :param pulumi.Input[_builtins.str] created_at: The datetime the certificate was created
        :param pulumi.Input[_builtins.str] csr: The certificate signing request
        :param pulumi.Input[_builtins.str] domain_id: The domain to be issued the certificate for
        :param pulumi.Input[_builtins.str] expires_at: The datetime the certificate will expire
        :param pulumi.Input[_builtins.str] name: The certificate name; use `""` for the root domain. Wildcard names are supported.
        :param pulumi.Input[_builtins.str] signature_algorithm: The signature algorithm to use for the certificate
        :param pulumi.Input[_builtins.str] state: The state of the certificate
        :param pulumi.Input[_builtins.str] updated_at: The datetime the certificate was last updated
        :param pulumi.Input[_builtins.int] years: The years the certificate will last
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LetsEncryptCertificateState.__new__(_LetsEncryptCertificateState)

        __props__.__dict__["alternate_names"] = alternate_names
        __props__.__dict__["authority_identifier"] = authority_identifier
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["csr"] = csr
        __props__.__dict__["domain_id"] = domain_id
        __props__.__dict__["expires_at"] = expires_at
        __props__.__dict__["name"] = name
        __props__.__dict__["signature_algorithm"] = signature_algorithm
        __props__.__dict__["state"] = state
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["years"] = years
        return LetsEncryptCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alternateNames")
    def alternate_names(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The certificate alternate names
        """
        return pulumi.get(self, "alternate_names")

    @_builtins.property
    @pulumi.getter(name="authorityIdentifier")
    def authority_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The identifying certification authority (CA)
        """
        return pulumi.get(self, "authority_identifier")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[_builtins.bool]:
        """
        True if the certificate should auto-renew
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The datetime the certificate was created
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def csr(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate signing request
        """
        return pulumi.get(self, "csr")

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[_builtins.str]:
        """
        The domain to be issued the certificate for
        """
        return pulumi.get(self, "domain_id")

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> pulumi.Output[_builtins.str]:
        """
        The datetime the certificate will expire
        """
        return pulumi.get(self, "expires_at")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate name; use `""` for the root domain. Wildcard names are supported.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The signature algorithm to use for the certificate
        """
        return pulumi.get(self, "signature_algorithm")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the certificate
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The datetime the certificate was last updated
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def years(self) -> pulumi.Output[_builtins.int]:
        """
        The years the certificate will last
        """
        return pulumi.get(self, "years")

