# svVascularize


[![Version](https://img.shields.io/pypi/v/svv.svg?logo=pypi&label=PyPI%20version)](https:://pypi.org/project/svv/)
![Platform](https://img.shields.io/badge/platform-macOS%20|%20linux%20|%20windows-blue)
![Latest Release](https://img.shields.io/github/v/release/SimVascular/svVascularize?label=latest)
[![codecov](https://codecov.io/github/SimVascular/svVascularize/graph/badge.svg)](https://codecov.io/github/SimVascular/svVascularize)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.15151168.svg)]()
[![Docs](https://img.shields.io/badge/docs-gh--pages-brightgreen)](https://simvascular.github.io/svVascularize/)

<p align="left">
The svVascularize (svv) is an open-source API for automated vascular generation and multi-fidelity hemodynamic simulation
written in Python. Often small-caliber vessels are difficult or infeasible to obtain from experimental data sources 
despite playing important roles in blood flow regulation and cell microenvironments. svVascularize aims to provide tissue 
engineers and computational hemodynamic scientists with de novo vasculature that can easily be applied in 
biomanufacturing applications or computational fluid dynamic (CFD) analysis.
</p>

* **Website:** https://simvascular.github.io/svVascularize/
* **PyPi:** https://pypi.org/project/svv/
* **Source code:** https://github.com/SimVascular/svVascularize

## Installation

The package is published on PyPI as `svv`:

```bash
pip install svv
```

On clusters / HPC systems (for example Stanford Sherlock), use a recent Python (3.9–3.12) and `pip`, and install into a clean virtual environment or user site-packages. The runtime dependencies now require `numpy>=1.26`, which has pre-built wheels for Python 3.12 on standard x86_64 Linux, so `pip install svv` should no longer try to build NumPy (or SciPy) from source on these systems.
