# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsGovcloudIntegrationsArgs', 'AwsGovcloudIntegrations']

@pulumi.input_type
class AwsGovcloudIntegrationsArgs:
    def __init__(__self__, *,
                 linked_account_id: pulumi.Input[_builtins.str],
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 alb: Optional[pulumi.Input['AwsGovcloudIntegrationsAlbArgs']] = None,
                 api_gateway: Optional[pulumi.Input['AwsGovcloudIntegrationsApiGatewayArgs']] = None,
                 auto_scaling: Optional[pulumi.Input['AwsGovcloudIntegrationsAutoScalingArgs']] = None,
                 aws_direct_connect: Optional[pulumi.Input['AwsGovcloudIntegrationsAwsDirectConnectArgs']] = None,
                 aws_states: Optional[pulumi.Input['AwsGovcloudIntegrationsAwsStatesArgs']] = None,
                 cloudtrail: Optional[pulumi.Input['AwsGovcloudIntegrationsCloudtrailArgs']] = None,
                 dynamo_db: Optional[pulumi.Input['AwsGovcloudIntegrationsDynamoDbArgs']] = None,
                 ebs: Optional[pulumi.Input['AwsGovcloudIntegrationsEbsArgs']] = None,
                 ec2: Optional[pulumi.Input['AwsGovcloudIntegrationsEc2Args']] = None,
                 elastic_search: Optional[pulumi.Input['AwsGovcloudIntegrationsElasticSearchArgs']] = None,
                 elb: Optional[pulumi.Input['AwsGovcloudIntegrationsElbArgs']] = None,
                 emr: Optional[pulumi.Input['AwsGovcloudIntegrationsEmrArgs']] = None,
                 iam: Optional[pulumi.Input['AwsGovcloudIntegrationsIamArgs']] = None,
                 lambda_: Optional[pulumi.Input['AwsGovcloudIntegrationsLambdaArgs']] = None,
                 rds: Optional[pulumi.Input['AwsGovcloudIntegrationsRdsArgs']] = None,
                 red_shift: Optional[pulumi.Input['AwsGovcloudIntegrationsRedShiftArgs']] = None,
                 route53: Optional[pulumi.Input['AwsGovcloudIntegrationsRoute53Args']] = None,
                 s3: Optional[pulumi.Input['AwsGovcloudIntegrationsS3Args']] = None,
                 sns: Optional[pulumi.Input['AwsGovcloudIntegrationsSnsArgs']] = None,
                 sqs: Optional[pulumi.Input['AwsGovcloudIntegrationsSqsArgs']] = None):
        """
        The set of arguments for constructing a AwsGovcloudIntegrations resource.
        :param pulumi.Input[_builtins.str] linked_account_id: The access key of the AwsGovCloud.
        :param pulumi.Input[_builtins.str] account_id: The New Relic account ID to operate on. This allows the user to override the `account_id` attribute set on the provider. Defaults to the environment variable `NEW_RELIC_ACCOUNT_ID`.
        :param pulumi.Input['AwsGovcloudIntegrationsAlbArgs'] alb: Application load balancer AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsApiGatewayArgs'] api_gateway: Api Gateway AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsAutoScalingArgs'] auto_scaling: Autoscaling AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsAwsDirectConnectArgs'] aws_direct_connect: Aws Direct Connect AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsAwsStatesArgs'] aws_states: Aws States AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsCloudtrailArgs'] cloudtrail: Cloudtrail AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsDynamoDbArgs'] dynamo_db: Dynamo DB AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsEbsArgs'] ebs: Elastic Beanstalk AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsEc2Args'] ec2: EC2 AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsElasticSearchArgs'] elastic_search: Elastic search AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsElbArgs'] elb: Elb AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsEmrArgs'] emr: Emr AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsIamArgs'] iam: IAM AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsLambdaArgs'] lambda_: Lambda AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsRdsArgs'] rds: RDS AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsRedShiftArgs'] red_shift: Redshift AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsRoute53Args'] route53: Route53 AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsS3Args'] s3: The s3 integration
        :param pulumi.Input['AwsGovcloudIntegrationsSnsArgs'] sns: SNS AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsSqsArgs'] sqs: SQS AwsGovCloud integration.See Integration blocks below for details.
        """
        pulumi.set(__self__, "linked_account_id", linked_account_id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if alb is not None:
            pulumi.set(__self__, "alb", alb)
        if api_gateway is not None:
            pulumi.set(__self__, "api_gateway", api_gateway)
        if auto_scaling is not None:
            pulumi.set(__self__, "auto_scaling", auto_scaling)
        if aws_direct_connect is not None:
            pulumi.set(__self__, "aws_direct_connect", aws_direct_connect)
        if aws_states is not None:
            pulumi.set(__self__, "aws_states", aws_states)
        if cloudtrail is not None:
            pulumi.set(__self__, "cloudtrail", cloudtrail)
        if dynamo_db is not None:
            pulumi.set(__self__, "dynamo_db", dynamo_db)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)
        if ec2 is not None:
            pulumi.set(__self__, "ec2", ec2)
        if elastic_search is not None:
            pulumi.set(__self__, "elastic_search", elastic_search)
        if elb is not None:
            pulumi.set(__self__, "elb", elb)
        if emr is not None:
            pulumi.set(__self__, "emr", emr)
        if iam is not None:
            pulumi.set(__self__, "iam", iam)
        if lambda_ is not None:
            pulumi.set(__self__, "lambda_", lambda_)
        if rds is not None:
            pulumi.set(__self__, "rds", rds)
        if red_shift is not None:
            pulumi.set(__self__, "red_shift", red_shift)
        if route53 is not None:
            pulumi.set(__self__, "route53", route53)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if sns is not None:
            pulumi.set(__self__, "sns", sns)
        if sqs is not None:
            pulumi.set(__self__, "sqs", sqs)

    @_builtins.property
    @pulumi.getter(name="linkedAccountId")
    def linked_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The access key of the AwsGovCloud.
        """
        return pulumi.get(self, "linked_account_id")

    @linked_account_id.setter
    def linked_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "linked_account_id", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The New Relic account ID to operate on. This allows the user to override the `account_id` attribute set on the provider. Defaults to the environment variable `NEW_RELIC_ACCOUNT_ID`.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def alb(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsAlbArgs']]:
        """
        Application load balancer AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "alb")

    @alb.setter
    def alb(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsAlbArgs']]):
        pulumi.set(self, "alb", value)

    @_builtins.property
    @pulumi.getter(name="apiGateway")
    def api_gateway(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsApiGatewayArgs']]:
        """
        Api Gateway AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "api_gateway")

    @api_gateway.setter
    def api_gateway(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsApiGatewayArgs']]):
        pulumi.set(self, "api_gateway", value)

    @_builtins.property
    @pulumi.getter(name="autoScaling")
    def auto_scaling(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsAutoScalingArgs']]:
        """
        Autoscaling AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "auto_scaling")

    @auto_scaling.setter
    def auto_scaling(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsAutoScalingArgs']]):
        pulumi.set(self, "auto_scaling", value)

    @_builtins.property
    @pulumi.getter(name="awsDirectConnect")
    def aws_direct_connect(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsAwsDirectConnectArgs']]:
        """
        Aws Direct Connect AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "aws_direct_connect")

    @aws_direct_connect.setter
    def aws_direct_connect(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsAwsDirectConnectArgs']]):
        pulumi.set(self, "aws_direct_connect", value)

    @_builtins.property
    @pulumi.getter(name="awsStates")
    def aws_states(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsAwsStatesArgs']]:
        """
        Aws States AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "aws_states")

    @aws_states.setter
    def aws_states(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsAwsStatesArgs']]):
        pulumi.set(self, "aws_states", value)

    @_builtins.property
    @pulumi.getter
    def cloudtrail(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsCloudtrailArgs']]:
        """
        Cloudtrail AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "cloudtrail")

    @cloudtrail.setter
    def cloudtrail(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsCloudtrailArgs']]):
        pulumi.set(self, "cloudtrail", value)

    @_builtins.property
    @pulumi.getter(name="dynamoDb")
    def dynamo_db(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsDynamoDbArgs']]:
        """
        Dynamo DB AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "dynamo_db")

    @dynamo_db.setter
    def dynamo_db(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsDynamoDbArgs']]):
        pulumi.set(self, "dynamo_db", value)

    @_builtins.property
    @pulumi.getter
    def ebs(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsEbsArgs']]:
        """
        Elastic Beanstalk AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "ebs")

    @ebs.setter
    def ebs(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsEbsArgs']]):
        pulumi.set(self, "ebs", value)

    @_builtins.property
    @pulumi.getter
    def ec2(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsEc2Args']]:
        """
        EC2 AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "ec2")

    @ec2.setter
    def ec2(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsEc2Args']]):
        pulumi.set(self, "ec2", value)

    @_builtins.property
    @pulumi.getter(name="elasticSearch")
    def elastic_search(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsElasticSearchArgs']]:
        """
        Elastic search AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "elastic_search")

    @elastic_search.setter
    def elastic_search(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsElasticSearchArgs']]):
        pulumi.set(self, "elastic_search", value)

    @_builtins.property
    @pulumi.getter
    def elb(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsElbArgs']]:
        """
        Elb AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "elb")

    @elb.setter
    def elb(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsElbArgs']]):
        pulumi.set(self, "elb", value)

    @_builtins.property
    @pulumi.getter
    def emr(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsEmrArgs']]:
        """
        Emr AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "emr")

    @emr.setter
    def emr(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsEmrArgs']]):
        pulumi.set(self, "emr", value)

    @_builtins.property
    @pulumi.getter
    def iam(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsIamArgs']]:
        """
        IAM AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "iam")

    @iam.setter
    def iam(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsIamArgs']]):
        pulumi.set(self, "iam", value)

    @_builtins.property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsLambdaArgs']]:
        """
        Lambda AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "lambda_")

    @lambda_.setter
    def lambda_(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsLambdaArgs']]):
        pulumi.set(self, "lambda_", value)

    @_builtins.property
    @pulumi.getter
    def rds(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsRdsArgs']]:
        """
        RDS AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "rds")

    @rds.setter
    def rds(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsRdsArgs']]):
        pulumi.set(self, "rds", value)

    @_builtins.property
    @pulumi.getter(name="redShift")
    def red_shift(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsRedShiftArgs']]:
        """
        Redshift AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "red_shift")

    @red_shift.setter
    def red_shift(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsRedShiftArgs']]):
        pulumi.set(self, "red_shift", value)

    @_builtins.property
    @pulumi.getter
    def route53(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsRoute53Args']]:
        """
        Route53 AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "route53")

    @route53.setter
    def route53(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsRoute53Args']]):
        pulumi.set(self, "route53", value)

    @_builtins.property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsS3Args']]:
        """
        The s3 integration
        """
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsS3Args']]):
        pulumi.set(self, "s3", value)

    @_builtins.property
    @pulumi.getter
    def sns(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsSnsArgs']]:
        """
        SNS AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "sns")

    @sns.setter
    def sns(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsSnsArgs']]):
        pulumi.set(self, "sns", value)

    @_builtins.property
    @pulumi.getter
    def sqs(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsSqsArgs']]:
        """
        SQS AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "sqs")

    @sqs.setter
    def sqs(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsSqsArgs']]):
        pulumi.set(self, "sqs", value)


@pulumi.input_type
class _AwsGovcloudIntegrationsState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 alb: Optional[pulumi.Input['AwsGovcloudIntegrationsAlbArgs']] = None,
                 api_gateway: Optional[pulumi.Input['AwsGovcloudIntegrationsApiGatewayArgs']] = None,
                 auto_scaling: Optional[pulumi.Input['AwsGovcloudIntegrationsAutoScalingArgs']] = None,
                 aws_direct_connect: Optional[pulumi.Input['AwsGovcloudIntegrationsAwsDirectConnectArgs']] = None,
                 aws_states: Optional[pulumi.Input['AwsGovcloudIntegrationsAwsStatesArgs']] = None,
                 cloudtrail: Optional[pulumi.Input['AwsGovcloudIntegrationsCloudtrailArgs']] = None,
                 dynamo_db: Optional[pulumi.Input['AwsGovcloudIntegrationsDynamoDbArgs']] = None,
                 ebs: Optional[pulumi.Input['AwsGovcloudIntegrationsEbsArgs']] = None,
                 ec2: Optional[pulumi.Input['AwsGovcloudIntegrationsEc2Args']] = None,
                 elastic_search: Optional[pulumi.Input['AwsGovcloudIntegrationsElasticSearchArgs']] = None,
                 elb: Optional[pulumi.Input['AwsGovcloudIntegrationsElbArgs']] = None,
                 emr: Optional[pulumi.Input['AwsGovcloudIntegrationsEmrArgs']] = None,
                 iam: Optional[pulumi.Input['AwsGovcloudIntegrationsIamArgs']] = None,
                 lambda_: Optional[pulumi.Input['AwsGovcloudIntegrationsLambdaArgs']] = None,
                 linked_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rds: Optional[pulumi.Input['AwsGovcloudIntegrationsRdsArgs']] = None,
                 red_shift: Optional[pulumi.Input['AwsGovcloudIntegrationsRedShiftArgs']] = None,
                 route53: Optional[pulumi.Input['AwsGovcloudIntegrationsRoute53Args']] = None,
                 s3: Optional[pulumi.Input['AwsGovcloudIntegrationsS3Args']] = None,
                 sns: Optional[pulumi.Input['AwsGovcloudIntegrationsSnsArgs']] = None,
                 sqs: Optional[pulumi.Input['AwsGovcloudIntegrationsSqsArgs']] = None):
        """
        Input properties used for looking up and filtering AwsGovcloudIntegrations resources.
        :param pulumi.Input[_builtins.str] account_id: The New Relic account ID to operate on. This allows the user to override the `account_id` attribute set on the provider. Defaults to the environment variable `NEW_RELIC_ACCOUNT_ID`.
        :param pulumi.Input['AwsGovcloudIntegrationsAlbArgs'] alb: Application load balancer AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsApiGatewayArgs'] api_gateway: Api Gateway AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsAutoScalingArgs'] auto_scaling: Autoscaling AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsAwsDirectConnectArgs'] aws_direct_connect: Aws Direct Connect AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsAwsStatesArgs'] aws_states: Aws States AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsCloudtrailArgs'] cloudtrail: Cloudtrail AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsDynamoDbArgs'] dynamo_db: Dynamo DB AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsEbsArgs'] ebs: Elastic Beanstalk AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsEc2Args'] ec2: EC2 AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsElasticSearchArgs'] elastic_search: Elastic search AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsElbArgs'] elb: Elb AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsEmrArgs'] emr: Emr AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsIamArgs'] iam: IAM AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsLambdaArgs'] lambda_: Lambda AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[_builtins.str] linked_account_id: The access key of the AwsGovCloud.
        :param pulumi.Input['AwsGovcloudIntegrationsRdsArgs'] rds: RDS AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsRedShiftArgs'] red_shift: Redshift AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsRoute53Args'] route53: Route53 AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsS3Args'] s3: The s3 integration
        :param pulumi.Input['AwsGovcloudIntegrationsSnsArgs'] sns: SNS AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input['AwsGovcloudIntegrationsSqsArgs'] sqs: SQS AwsGovCloud integration.See Integration blocks below for details.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if alb is not None:
            pulumi.set(__self__, "alb", alb)
        if api_gateway is not None:
            pulumi.set(__self__, "api_gateway", api_gateway)
        if auto_scaling is not None:
            pulumi.set(__self__, "auto_scaling", auto_scaling)
        if aws_direct_connect is not None:
            pulumi.set(__self__, "aws_direct_connect", aws_direct_connect)
        if aws_states is not None:
            pulumi.set(__self__, "aws_states", aws_states)
        if cloudtrail is not None:
            pulumi.set(__self__, "cloudtrail", cloudtrail)
        if dynamo_db is not None:
            pulumi.set(__self__, "dynamo_db", dynamo_db)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)
        if ec2 is not None:
            pulumi.set(__self__, "ec2", ec2)
        if elastic_search is not None:
            pulumi.set(__self__, "elastic_search", elastic_search)
        if elb is not None:
            pulumi.set(__self__, "elb", elb)
        if emr is not None:
            pulumi.set(__self__, "emr", emr)
        if iam is not None:
            pulumi.set(__self__, "iam", iam)
        if lambda_ is not None:
            pulumi.set(__self__, "lambda_", lambda_)
        if linked_account_id is not None:
            pulumi.set(__self__, "linked_account_id", linked_account_id)
        if rds is not None:
            pulumi.set(__self__, "rds", rds)
        if red_shift is not None:
            pulumi.set(__self__, "red_shift", red_shift)
        if route53 is not None:
            pulumi.set(__self__, "route53", route53)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if sns is not None:
            pulumi.set(__self__, "sns", sns)
        if sqs is not None:
            pulumi.set(__self__, "sqs", sqs)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The New Relic account ID to operate on. This allows the user to override the `account_id` attribute set on the provider. Defaults to the environment variable `NEW_RELIC_ACCOUNT_ID`.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def alb(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsAlbArgs']]:
        """
        Application load balancer AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "alb")

    @alb.setter
    def alb(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsAlbArgs']]):
        pulumi.set(self, "alb", value)

    @_builtins.property
    @pulumi.getter(name="apiGateway")
    def api_gateway(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsApiGatewayArgs']]:
        """
        Api Gateway AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "api_gateway")

    @api_gateway.setter
    def api_gateway(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsApiGatewayArgs']]):
        pulumi.set(self, "api_gateway", value)

    @_builtins.property
    @pulumi.getter(name="autoScaling")
    def auto_scaling(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsAutoScalingArgs']]:
        """
        Autoscaling AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "auto_scaling")

    @auto_scaling.setter
    def auto_scaling(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsAutoScalingArgs']]):
        pulumi.set(self, "auto_scaling", value)

    @_builtins.property
    @pulumi.getter(name="awsDirectConnect")
    def aws_direct_connect(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsAwsDirectConnectArgs']]:
        """
        Aws Direct Connect AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "aws_direct_connect")

    @aws_direct_connect.setter
    def aws_direct_connect(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsAwsDirectConnectArgs']]):
        pulumi.set(self, "aws_direct_connect", value)

    @_builtins.property
    @pulumi.getter(name="awsStates")
    def aws_states(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsAwsStatesArgs']]:
        """
        Aws States AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "aws_states")

    @aws_states.setter
    def aws_states(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsAwsStatesArgs']]):
        pulumi.set(self, "aws_states", value)

    @_builtins.property
    @pulumi.getter
    def cloudtrail(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsCloudtrailArgs']]:
        """
        Cloudtrail AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "cloudtrail")

    @cloudtrail.setter
    def cloudtrail(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsCloudtrailArgs']]):
        pulumi.set(self, "cloudtrail", value)

    @_builtins.property
    @pulumi.getter(name="dynamoDb")
    def dynamo_db(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsDynamoDbArgs']]:
        """
        Dynamo DB AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "dynamo_db")

    @dynamo_db.setter
    def dynamo_db(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsDynamoDbArgs']]):
        pulumi.set(self, "dynamo_db", value)

    @_builtins.property
    @pulumi.getter
    def ebs(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsEbsArgs']]:
        """
        Elastic Beanstalk AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "ebs")

    @ebs.setter
    def ebs(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsEbsArgs']]):
        pulumi.set(self, "ebs", value)

    @_builtins.property
    @pulumi.getter
    def ec2(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsEc2Args']]:
        """
        EC2 AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "ec2")

    @ec2.setter
    def ec2(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsEc2Args']]):
        pulumi.set(self, "ec2", value)

    @_builtins.property
    @pulumi.getter(name="elasticSearch")
    def elastic_search(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsElasticSearchArgs']]:
        """
        Elastic search AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "elastic_search")

    @elastic_search.setter
    def elastic_search(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsElasticSearchArgs']]):
        pulumi.set(self, "elastic_search", value)

    @_builtins.property
    @pulumi.getter
    def elb(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsElbArgs']]:
        """
        Elb AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "elb")

    @elb.setter
    def elb(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsElbArgs']]):
        pulumi.set(self, "elb", value)

    @_builtins.property
    @pulumi.getter
    def emr(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsEmrArgs']]:
        """
        Emr AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "emr")

    @emr.setter
    def emr(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsEmrArgs']]):
        pulumi.set(self, "emr", value)

    @_builtins.property
    @pulumi.getter
    def iam(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsIamArgs']]:
        """
        IAM AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "iam")

    @iam.setter
    def iam(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsIamArgs']]):
        pulumi.set(self, "iam", value)

    @_builtins.property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsLambdaArgs']]:
        """
        Lambda AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "lambda_")

    @lambda_.setter
    def lambda_(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsLambdaArgs']]):
        pulumi.set(self, "lambda_", value)

    @_builtins.property
    @pulumi.getter(name="linkedAccountId")
    def linked_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access key of the AwsGovCloud.
        """
        return pulumi.get(self, "linked_account_id")

    @linked_account_id.setter
    def linked_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "linked_account_id", value)

    @_builtins.property
    @pulumi.getter
    def rds(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsRdsArgs']]:
        """
        RDS AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "rds")

    @rds.setter
    def rds(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsRdsArgs']]):
        pulumi.set(self, "rds", value)

    @_builtins.property
    @pulumi.getter(name="redShift")
    def red_shift(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsRedShiftArgs']]:
        """
        Redshift AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "red_shift")

    @red_shift.setter
    def red_shift(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsRedShiftArgs']]):
        pulumi.set(self, "red_shift", value)

    @_builtins.property
    @pulumi.getter
    def route53(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsRoute53Args']]:
        """
        Route53 AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "route53")

    @route53.setter
    def route53(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsRoute53Args']]):
        pulumi.set(self, "route53", value)

    @_builtins.property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsS3Args']]:
        """
        The s3 integration
        """
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsS3Args']]):
        pulumi.set(self, "s3", value)

    @_builtins.property
    @pulumi.getter
    def sns(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsSnsArgs']]:
        """
        SNS AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "sns")

    @sns.setter
    def sns(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsSnsArgs']]):
        pulumi.set(self, "sns", value)

    @_builtins.property
    @pulumi.getter
    def sqs(self) -> Optional[pulumi.Input['AwsGovcloudIntegrationsSqsArgs']]:
        """
        SQS AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "sqs")

    @sqs.setter
    def sqs(self, value: Optional[pulumi.Input['AwsGovcloudIntegrationsSqsArgs']]):
        pulumi.set(self, "sqs", value)


@pulumi.type_token("newrelic:cloud/awsGovcloudIntegrations:AwsGovcloudIntegrations")
class AwsGovcloudIntegrations(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 alb: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsAlbArgs', 'AwsGovcloudIntegrationsAlbArgsDict']]] = None,
                 api_gateway: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsApiGatewayArgs', 'AwsGovcloudIntegrationsApiGatewayArgsDict']]] = None,
                 auto_scaling: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsAutoScalingArgs', 'AwsGovcloudIntegrationsAutoScalingArgsDict']]] = None,
                 aws_direct_connect: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsAwsDirectConnectArgs', 'AwsGovcloudIntegrationsAwsDirectConnectArgsDict']]] = None,
                 aws_states: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsAwsStatesArgs', 'AwsGovcloudIntegrationsAwsStatesArgsDict']]] = None,
                 cloudtrail: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsCloudtrailArgs', 'AwsGovcloudIntegrationsCloudtrailArgsDict']]] = None,
                 dynamo_db: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsDynamoDbArgs', 'AwsGovcloudIntegrationsDynamoDbArgsDict']]] = None,
                 ebs: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsEbsArgs', 'AwsGovcloudIntegrationsEbsArgsDict']]] = None,
                 ec2: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsEc2Args', 'AwsGovcloudIntegrationsEc2ArgsDict']]] = None,
                 elastic_search: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsElasticSearchArgs', 'AwsGovcloudIntegrationsElasticSearchArgsDict']]] = None,
                 elb: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsElbArgs', 'AwsGovcloudIntegrationsElbArgsDict']]] = None,
                 emr: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsEmrArgs', 'AwsGovcloudIntegrationsEmrArgsDict']]] = None,
                 iam: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsIamArgs', 'AwsGovcloudIntegrationsIamArgsDict']]] = None,
                 lambda_: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsLambdaArgs', 'AwsGovcloudIntegrationsLambdaArgsDict']]] = None,
                 linked_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rds: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsRdsArgs', 'AwsGovcloudIntegrationsRdsArgsDict']]] = None,
                 red_shift: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsRedShiftArgs', 'AwsGovcloudIntegrationsRedShiftArgsDict']]] = None,
                 route53: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsRoute53Args', 'AwsGovcloudIntegrationsRoute53ArgsDict']]] = None,
                 s3: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsS3Args', 'AwsGovcloudIntegrationsS3ArgsDict']]] = None,
                 sns: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsSnsArgs', 'AwsGovcloudIntegrationsSnsArgsDict']]] = None,
                 sqs: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsSqsArgs', 'AwsGovcloudIntegrationsSqsArgsDict']]] = None,
                 __props__=None):
        """
        > **IMPORTANT!** This resource is in alpha state, and could still contain issues and missing functionality. If you encounter any issue please create a ticket on Github with all the required information.

        Use this resource to integrate an AWSGovCloud account to New Relic.

        ## Prerequisite

        Obtain the AwsGovCloud account designed to address the specific regulatory needs of United States (federal, state, and local agencies), education institutions, and the supporting ecosystem.

        It is an isolated AWS region designed to host sensitive data and regulated workloads in the cloud, helping customers support their US government compliance requirements.

        To pull data from AWSGovCloud, complete the [steps outlined here](https://docs.newrelic.com/docs/infrastructure/amazon-integrations/connect/connect-aws-govcloud-new-relic).

        ## Import

        Integrate AWSGovCloud accounts can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import newrelic:cloud/awsGovcloudIntegrations:AwsGovcloudIntegrations foo <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The New Relic account ID to operate on. This allows the user to override the `account_id` attribute set on the provider. Defaults to the environment variable `NEW_RELIC_ACCOUNT_ID`.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsAlbArgs', 'AwsGovcloudIntegrationsAlbArgsDict']] alb: Application load balancer AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsApiGatewayArgs', 'AwsGovcloudIntegrationsApiGatewayArgsDict']] api_gateway: Api Gateway AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsAutoScalingArgs', 'AwsGovcloudIntegrationsAutoScalingArgsDict']] auto_scaling: Autoscaling AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsAwsDirectConnectArgs', 'AwsGovcloudIntegrationsAwsDirectConnectArgsDict']] aws_direct_connect: Aws Direct Connect AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsAwsStatesArgs', 'AwsGovcloudIntegrationsAwsStatesArgsDict']] aws_states: Aws States AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsCloudtrailArgs', 'AwsGovcloudIntegrationsCloudtrailArgsDict']] cloudtrail: Cloudtrail AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsDynamoDbArgs', 'AwsGovcloudIntegrationsDynamoDbArgsDict']] dynamo_db: Dynamo DB AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsEbsArgs', 'AwsGovcloudIntegrationsEbsArgsDict']] ebs: Elastic Beanstalk AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsEc2Args', 'AwsGovcloudIntegrationsEc2ArgsDict']] ec2: EC2 AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsElasticSearchArgs', 'AwsGovcloudIntegrationsElasticSearchArgsDict']] elastic_search: Elastic search AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsElbArgs', 'AwsGovcloudIntegrationsElbArgsDict']] elb: Elb AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsEmrArgs', 'AwsGovcloudIntegrationsEmrArgsDict']] emr: Emr AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsIamArgs', 'AwsGovcloudIntegrationsIamArgsDict']] iam: IAM AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsLambdaArgs', 'AwsGovcloudIntegrationsLambdaArgsDict']] lambda_: Lambda AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[_builtins.str] linked_account_id: The access key of the AwsGovCloud.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsRdsArgs', 'AwsGovcloudIntegrationsRdsArgsDict']] rds: RDS AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsRedShiftArgs', 'AwsGovcloudIntegrationsRedShiftArgsDict']] red_shift: Redshift AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsRoute53Args', 'AwsGovcloudIntegrationsRoute53ArgsDict']] route53: Route53 AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsS3Args', 'AwsGovcloudIntegrationsS3ArgsDict']] s3: The s3 integration
        :param pulumi.Input[Union['AwsGovcloudIntegrationsSnsArgs', 'AwsGovcloudIntegrationsSnsArgsDict']] sns: SNS AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsSqsArgs', 'AwsGovcloudIntegrationsSqsArgsDict']] sqs: SQS AwsGovCloud integration.See Integration blocks below for details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsGovcloudIntegrationsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **IMPORTANT!** This resource is in alpha state, and could still contain issues and missing functionality. If you encounter any issue please create a ticket on Github with all the required information.

        Use this resource to integrate an AWSGovCloud account to New Relic.

        ## Prerequisite

        Obtain the AwsGovCloud account designed to address the specific regulatory needs of United States (federal, state, and local agencies), education institutions, and the supporting ecosystem.

        It is an isolated AWS region designed to host sensitive data and regulated workloads in the cloud, helping customers support their US government compliance requirements.

        To pull data from AWSGovCloud, complete the [steps outlined here](https://docs.newrelic.com/docs/infrastructure/amazon-integrations/connect/connect-aws-govcloud-new-relic).

        ## Import

        Integrate AWSGovCloud accounts can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import newrelic:cloud/awsGovcloudIntegrations:AwsGovcloudIntegrations foo <id>
        ```

        :param str resource_name: The name of the resource.
        :param AwsGovcloudIntegrationsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsGovcloudIntegrationsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 alb: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsAlbArgs', 'AwsGovcloudIntegrationsAlbArgsDict']]] = None,
                 api_gateway: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsApiGatewayArgs', 'AwsGovcloudIntegrationsApiGatewayArgsDict']]] = None,
                 auto_scaling: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsAutoScalingArgs', 'AwsGovcloudIntegrationsAutoScalingArgsDict']]] = None,
                 aws_direct_connect: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsAwsDirectConnectArgs', 'AwsGovcloudIntegrationsAwsDirectConnectArgsDict']]] = None,
                 aws_states: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsAwsStatesArgs', 'AwsGovcloudIntegrationsAwsStatesArgsDict']]] = None,
                 cloudtrail: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsCloudtrailArgs', 'AwsGovcloudIntegrationsCloudtrailArgsDict']]] = None,
                 dynamo_db: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsDynamoDbArgs', 'AwsGovcloudIntegrationsDynamoDbArgsDict']]] = None,
                 ebs: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsEbsArgs', 'AwsGovcloudIntegrationsEbsArgsDict']]] = None,
                 ec2: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsEc2Args', 'AwsGovcloudIntegrationsEc2ArgsDict']]] = None,
                 elastic_search: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsElasticSearchArgs', 'AwsGovcloudIntegrationsElasticSearchArgsDict']]] = None,
                 elb: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsElbArgs', 'AwsGovcloudIntegrationsElbArgsDict']]] = None,
                 emr: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsEmrArgs', 'AwsGovcloudIntegrationsEmrArgsDict']]] = None,
                 iam: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsIamArgs', 'AwsGovcloudIntegrationsIamArgsDict']]] = None,
                 lambda_: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsLambdaArgs', 'AwsGovcloudIntegrationsLambdaArgsDict']]] = None,
                 linked_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rds: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsRdsArgs', 'AwsGovcloudIntegrationsRdsArgsDict']]] = None,
                 red_shift: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsRedShiftArgs', 'AwsGovcloudIntegrationsRedShiftArgsDict']]] = None,
                 route53: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsRoute53Args', 'AwsGovcloudIntegrationsRoute53ArgsDict']]] = None,
                 s3: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsS3Args', 'AwsGovcloudIntegrationsS3ArgsDict']]] = None,
                 sns: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsSnsArgs', 'AwsGovcloudIntegrationsSnsArgsDict']]] = None,
                 sqs: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsSqsArgs', 'AwsGovcloudIntegrationsSqsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsGovcloudIntegrationsArgs.__new__(AwsGovcloudIntegrationsArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["alb"] = alb
            __props__.__dict__["api_gateway"] = api_gateway
            __props__.__dict__["auto_scaling"] = auto_scaling
            __props__.__dict__["aws_direct_connect"] = aws_direct_connect
            __props__.__dict__["aws_states"] = aws_states
            __props__.__dict__["cloudtrail"] = cloudtrail
            __props__.__dict__["dynamo_db"] = dynamo_db
            __props__.__dict__["ebs"] = ebs
            __props__.__dict__["ec2"] = ec2
            __props__.__dict__["elastic_search"] = elastic_search
            __props__.__dict__["elb"] = elb
            __props__.__dict__["emr"] = emr
            __props__.__dict__["iam"] = iam
            __props__.__dict__["lambda_"] = lambda_
            if linked_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'linked_account_id'")
            __props__.__dict__["linked_account_id"] = linked_account_id
            __props__.__dict__["rds"] = rds
            __props__.__dict__["red_shift"] = red_shift
            __props__.__dict__["route53"] = route53
            __props__.__dict__["s3"] = s3
            __props__.__dict__["sns"] = sns
            __props__.__dict__["sqs"] = sqs
        super(AwsGovcloudIntegrations, __self__).__init__(
            'newrelic:cloud/awsGovcloudIntegrations:AwsGovcloudIntegrations',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            alb: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsAlbArgs', 'AwsGovcloudIntegrationsAlbArgsDict']]] = None,
            api_gateway: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsApiGatewayArgs', 'AwsGovcloudIntegrationsApiGatewayArgsDict']]] = None,
            auto_scaling: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsAutoScalingArgs', 'AwsGovcloudIntegrationsAutoScalingArgsDict']]] = None,
            aws_direct_connect: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsAwsDirectConnectArgs', 'AwsGovcloudIntegrationsAwsDirectConnectArgsDict']]] = None,
            aws_states: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsAwsStatesArgs', 'AwsGovcloudIntegrationsAwsStatesArgsDict']]] = None,
            cloudtrail: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsCloudtrailArgs', 'AwsGovcloudIntegrationsCloudtrailArgsDict']]] = None,
            dynamo_db: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsDynamoDbArgs', 'AwsGovcloudIntegrationsDynamoDbArgsDict']]] = None,
            ebs: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsEbsArgs', 'AwsGovcloudIntegrationsEbsArgsDict']]] = None,
            ec2: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsEc2Args', 'AwsGovcloudIntegrationsEc2ArgsDict']]] = None,
            elastic_search: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsElasticSearchArgs', 'AwsGovcloudIntegrationsElasticSearchArgsDict']]] = None,
            elb: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsElbArgs', 'AwsGovcloudIntegrationsElbArgsDict']]] = None,
            emr: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsEmrArgs', 'AwsGovcloudIntegrationsEmrArgsDict']]] = None,
            iam: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsIamArgs', 'AwsGovcloudIntegrationsIamArgsDict']]] = None,
            lambda_: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsLambdaArgs', 'AwsGovcloudIntegrationsLambdaArgsDict']]] = None,
            linked_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            rds: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsRdsArgs', 'AwsGovcloudIntegrationsRdsArgsDict']]] = None,
            red_shift: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsRedShiftArgs', 'AwsGovcloudIntegrationsRedShiftArgsDict']]] = None,
            route53: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsRoute53Args', 'AwsGovcloudIntegrationsRoute53ArgsDict']]] = None,
            s3: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsS3Args', 'AwsGovcloudIntegrationsS3ArgsDict']]] = None,
            sns: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsSnsArgs', 'AwsGovcloudIntegrationsSnsArgsDict']]] = None,
            sqs: Optional[pulumi.Input[Union['AwsGovcloudIntegrationsSqsArgs', 'AwsGovcloudIntegrationsSqsArgsDict']]] = None) -> 'AwsGovcloudIntegrations':
        """
        Get an existing AwsGovcloudIntegrations resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The New Relic account ID to operate on. This allows the user to override the `account_id` attribute set on the provider. Defaults to the environment variable `NEW_RELIC_ACCOUNT_ID`.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsAlbArgs', 'AwsGovcloudIntegrationsAlbArgsDict']] alb: Application load balancer AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsApiGatewayArgs', 'AwsGovcloudIntegrationsApiGatewayArgsDict']] api_gateway: Api Gateway AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsAutoScalingArgs', 'AwsGovcloudIntegrationsAutoScalingArgsDict']] auto_scaling: Autoscaling AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsAwsDirectConnectArgs', 'AwsGovcloudIntegrationsAwsDirectConnectArgsDict']] aws_direct_connect: Aws Direct Connect AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsAwsStatesArgs', 'AwsGovcloudIntegrationsAwsStatesArgsDict']] aws_states: Aws States AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsCloudtrailArgs', 'AwsGovcloudIntegrationsCloudtrailArgsDict']] cloudtrail: Cloudtrail AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsDynamoDbArgs', 'AwsGovcloudIntegrationsDynamoDbArgsDict']] dynamo_db: Dynamo DB AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsEbsArgs', 'AwsGovcloudIntegrationsEbsArgsDict']] ebs: Elastic Beanstalk AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsEc2Args', 'AwsGovcloudIntegrationsEc2ArgsDict']] ec2: EC2 AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsElasticSearchArgs', 'AwsGovcloudIntegrationsElasticSearchArgsDict']] elastic_search: Elastic search AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsElbArgs', 'AwsGovcloudIntegrationsElbArgsDict']] elb: Elb AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsEmrArgs', 'AwsGovcloudIntegrationsEmrArgsDict']] emr: Emr AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsIamArgs', 'AwsGovcloudIntegrationsIamArgsDict']] iam: IAM AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsLambdaArgs', 'AwsGovcloudIntegrationsLambdaArgsDict']] lambda_: Lambda AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[_builtins.str] linked_account_id: The access key of the AwsGovCloud.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsRdsArgs', 'AwsGovcloudIntegrationsRdsArgsDict']] rds: RDS AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsRedShiftArgs', 'AwsGovcloudIntegrationsRedShiftArgsDict']] red_shift: Redshift AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsRoute53Args', 'AwsGovcloudIntegrationsRoute53ArgsDict']] route53: Route53 AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsS3Args', 'AwsGovcloudIntegrationsS3ArgsDict']] s3: The s3 integration
        :param pulumi.Input[Union['AwsGovcloudIntegrationsSnsArgs', 'AwsGovcloudIntegrationsSnsArgsDict']] sns: SNS AwsGovCloud integration.See Integration blocks below for details.
        :param pulumi.Input[Union['AwsGovcloudIntegrationsSqsArgs', 'AwsGovcloudIntegrationsSqsArgsDict']] sqs: SQS AwsGovCloud integration.See Integration blocks below for details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsGovcloudIntegrationsState.__new__(_AwsGovcloudIntegrationsState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["alb"] = alb
        __props__.__dict__["api_gateway"] = api_gateway
        __props__.__dict__["auto_scaling"] = auto_scaling
        __props__.__dict__["aws_direct_connect"] = aws_direct_connect
        __props__.__dict__["aws_states"] = aws_states
        __props__.__dict__["cloudtrail"] = cloudtrail
        __props__.__dict__["dynamo_db"] = dynamo_db
        __props__.__dict__["ebs"] = ebs
        __props__.__dict__["ec2"] = ec2
        __props__.__dict__["elastic_search"] = elastic_search
        __props__.__dict__["elb"] = elb
        __props__.__dict__["emr"] = emr
        __props__.__dict__["iam"] = iam
        __props__.__dict__["lambda_"] = lambda_
        __props__.__dict__["linked_account_id"] = linked_account_id
        __props__.__dict__["rds"] = rds
        __props__.__dict__["red_shift"] = red_shift
        __props__.__dict__["route53"] = route53
        __props__.__dict__["s3"] = s3
        __props__.__dict__["sns"] = sns
        __props__.__dict__["sqs"] = sqs
        return AwsGovcloudIntegrations(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The New Relic account ID to operate on. This allows the user to override the `account_id` attribute set on the provider. Defaults to the environment variable `NEW_RELIC_ACCOUNT_ID`.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def alb(self) -> pulumi.Output[Optional['outputs.AwsGovcloudIntegrationsAlb']]:
        """
        Application load balancer AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "alb")

    @_builtins.property
    @pulumi.getter(name="apiGateway")
    def api_gateway(self) -> pulumi.Output[Optional['outputs.AwsGovcloudIntegrationsApiGateway']]:
        """
        Api Gateway AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "api_gateway")

    @_builtins.property
    @pulumi.getter(name="autoScaling")
    def auto_scaling(self) -> pulumi.Output[Optional['outputs.AwsGovcloudIntegrationsAutoScaling']]:
        """
        Autoscaling AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "auto_scaling")

    @_builtins.property
    @pulumi.getter(name="awsDirectConnect")
    def aws_direct_connect(self) -> pulumi.Output[Optional['outputs.AwsGovcloudIntegrationsAwsDirectConnect']]:
        """
        Aws Direct Connect AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "aws_direct_connect")

    @_builtins.property
    @pulumi.getter(name="awsStates")
    def aws_states(self) -> pulumi.Output[Optional['outputs.AwsGovcloudIntegrationsAwsStates']]:
        """
        Aws States AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "aws_states")

    @_builtins.property
    @pulumi.getter
    def cloudtrail(self) -> pulumi.Output[Optional['outputs.AwsGovcloudIntegrationsCloudtrail']]:
        """
        Cloudtrail AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "cloudtrail")

    @_builtins.property
    @pulumi.getter(name="dynamoDb")
    def dynamo_db(self) -> pulumi.Output[Optional['outputs.AwsGovcloudIntegrationsDynamoDb']]:
        """
        Dynamo DB AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "dynamo_db")

    @_builtins.property
    @pulumi.getter
    def ebs(self) -> pulumi.Output[Optional['outputs.AwsGovcloudIntegrationsEbs']]:
        """
        Elastic Beanstalk AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "ebs")

    @_builtins.property
    @pulumi.getter
    def ec2(self) -> pulumi.Output[Optional['outputs.AwsGovcloudIntegrationsEc2']]:
        """
        EC2 AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "ec2")

    @_builtins.property
    @pulumi.getter(name="elasticSearch")
    def elastic_search(self) -> pulumi.Output[Optional['outputs.AwsGovcloudIntegrationsElasticSearch']]:
        """
        Elastic search AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "elastic_search")

    @_builtins.property
    @pulumi.getter
    def elb(self) -> pulumi.Output[Optional['outputs.AwsGovcloudIntegrationsElb']]:
        """
        Elb AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "elb")

    @_builtins.property
    @pulumi.getter
    def emr(self) -> pulumi.Output[Optional['outputs.AwsGovcloudIntegrationsEmr']]:
        """
        Emr AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "emr")

    @_builtins.property
    @pulumi.getter
    def iam(self) -> pulumi.Output[Optional['outputs.AwsGovcloudIntegrationsIam']]:
        """
        IAM AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "iam")

    @_builtins.property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> pulumi.Output[Optional['outputs.AwsGovcloudIntegrationsLambda']]:
        """
        Lambda AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "lambda_")

    @_builtins.property
    @pulumi.getter(name="linkedAccountId")
    def linked_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The access key of the AwsGovCloud.
        """
        return pulumi.get(self, "linked_account_id")

    @_builtins.property
    @pulumi.getter
    def rds(self) -> pulumi.Output[Optional['outputs.AwsGovcloudIntegrationsRds']]:
        """
        RDS AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "rds")

    @_builtins.property
    @pulumi.getter(name="redShift")
    def red_shift(self) -> pulumi.Output[Optional['outputs.AwsGovcloudIntegrationsRedShift']]:
        """
        Redshift AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "red_shift")

    @_builtins.property
    @pulumi.getter
    def route53(self) -> pulumi.Output[Optional['outputs.AwsGovcloudIntegrationsRoute53']]:
        """
        Route53 AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "route53")

    @_builtins.property
    @pulumi.getter
    def s3(self) -> pulumi.Output[Optional['outputs.AwsGovcloudIntegrationsS3']]:
        """
        The s3 integration
        """
        return pulumi.get(self, "s3")

    @_builtins.property
    @pulumi.getter
    def sns(self) -> pulumi.Output[Optional['outputs.AwsGovcloudIntegrationsSns']]:
        """
        SNS AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "sns")

    @_builtins.property
    @pulumi.getter
    def sqs(self) -> pulumi.Output[Optional['outputs.AwsGovcloudIntegrationsSqs']]:
        """
        SQS AwsGovCloud integration.See Integration blocks below for details.
        """
        return pulumi.get(self, "sqs")

